/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.dimension.end;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgiaoc.byg.BYG;
import corgiaoc.byg.common.world.dimension.DatapackLayer;
import corgiaoc.byg.common.world.dimension.end.SimpleLayerProvider;
import corgiaoc.byg.config.json.biomedata.BiomeData;
import corgiaoc.byg.config.json.biomedata.BiomeDataHolders;
import corgiaoc.byg.config.json.biomedata.WeightedBiomeData;
import corgiaoc.byg.mixin.access.WeightedListAccess;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.WeightedList;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.RegistryLookupCodec;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.EndBiomeProvider;
import net.minecraft.world.gen.SimplexNoiseGenerator;

public class BYGEndBiomeSource
extends BiomeProvider {
    public static final Codec<BYGEndBiomeSource> BYGENDCODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryLookupCodec.func_244331_a((RegistryKey)Registry.field_239720_u_).forGetter(theEndBiomeSource -> theEndBiomeSource.biomeRegistry), (App)Codec.LONG.fieldOf("seed").stable().forGetter(theEndBiomeSource -> theEndBiomeSource.seed)).apply((Applicative)instance, instance.stable(BYGEndBiomeSource::new)));
    private final long seed;
    private final DatapackLayer mainIslandLayer;
    private final DatapackLayer smallIslandLayer;
    private final Registry<Biome> biomeRegistry;
    private final SimplexNoiseGenerator generator;

    public BYGEndBiomeSource(Registry<Biome> registry, long seed) {
        super(new ArrayList());
        this.seed = seed;
        SharedSeedRandom sharedseedrandom = new SharedSeedRandom(seed);
        sharedseedrandom.func_202423_a(17292);
        this.biomeRegistry = registry;
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        WeightedList endBiomes = new WeightedList();
        HashMap<ResourceLocation, WeightedList<ResourceLocation>> endHills = new HashMap<ResourceLocation, WeightedList<ResourceLocation>>();
        HashMap<ResourceLocation, ResourceLocation> biomeToEdge = new HashMap<ResourceLocation, ResourceLocation>();
        HashSet allBiomes = new HashSet();
        BiomeDataHolders.EndBiomeDataHolder endBiomeDataHolder = BYG.getEndData(gson, BYG.CONFIG_PATH.resolve("byg-end-biomes.json"));
        Map<ResourceLocation, WeightedBiomeData> endBiomeData1 = endBiomeDataHolder.getEndBiomeData();
        endBiomeData1.remove(null);
        endBiomeData1.remove(BYG.EMPTY);
        endBiomeData1.forEach((biome, endBiomeData) -> {
            endBiomes.func_226313_a_(biome, endBiomeData.getWeight());
            endHills.put((ResourceLocation)biome, endBiomeData.getSubBiomes());
            ResourceLocation edgeBiome = endBiomeData.getEdgeBiome();
            if (!edgeBiome.equals((Object)BYG.EMPTY)) {
                biomeToEdge.put((ResourceLocation)biome, edgeBiome);
            }
            allBiomes.add(biome);
            allBiomes.addAll(((WeightedListAccess)endBiomeData.getSubBiomes()).getEntries().stream().map(WeightedList.Entry::func_220647_b).collect(Collectors.toList()));
        });
        endHills.remove(BYG.EMPTY);
        biomeToEdge.remove(BYG.EMPTY);
        endHills.remove(null);
        biomeToEdge.remove(null);
        WeightedList voidBiomes = new WeightedList();
        HashMap<ResourceLocation, WeightedList<ResourceLocation>> voidHillsMap = new HashMap<ResourceLocation, WeightedList<ResourceLocation>>();
        HashMap<ResourceLocation, ResourceLocation> voidBiomeToEdge = new HashMap<ResourceLocation, ResourceLocation>();
        Map<ResourceLocation, WeightedBiomeData> voidBiomeData = endBiomeDataHolder.getVoidBiomeData();
        voidBiomeData.remove(null);
        voidBiomeData.remove(BYG.EMPTY);
        voidBiomeData.forEach((biome, endBiomeData) -> {
            voidBiomes.func_226313_a_(biome, endBiomeData.getWeight());
            voidHillsMap.put((ResourceLocation)biome, endBiomeData.getSubBiomes());
            ResourceLocation edgeBiome = endBiomeData.getEdgeBiome();
            if (!edgeBiome.equals((Object)BYG.EMPTY)) {
                voidBiomeToEdge.put((ResourceLocation)biome, edgeBiome);
            }
            allBiomes.add(biome);
            allBiomes.addAll(((WeightedListAccess)endBiomeData.getSubBiomes()).getEntries().stream().map(WeightedList.Entry::func_220647_b).collect(Collectors.toList()));
        });
        BiomeDataHolders.EndSubBiomeDataHolder endSubBiomeDataHolder = BYG.getEndSubBiomeData(gson, BYG.CONFIG_PATH.resolve("byg-end-sub-biomes.json"));
        Map<ResourceLocation, BiomeData> endSubBiomeData = endSubBiomeDataHolder.getEndSubBiomeData();
        endSubBiomeData.remove(null);
        endSubBiomeData.remove(BYG.EMPTY);
        endSubBiomeData.forEach((biome, endBiomeData) -> {
            ResourceLocation edgeBiome = endBiomeData.getEdgeBiome();
            if (!edgeBiome.equals((Object)BYG.EMPTY)) {
                biomeToEdge.put((ResourceLocation)biome, edgeBiome);
            }
            allBiomes.add(biome);
            allBiomes.add(endBiomeData.getEdgeBiome());
        });
        Map<ResourceLocation, BiomeData> voidSubBiomeData = endSubBiomeDataHolder.getVoidSubBiomeData();
        voidSubBiomeData.remove(null);
        voidBiomeData.remove(BYG.EMPTY);
        voidSubBiomeData.forEach((biome, endBiomeData) -> {
            ResourceLocation edgeBiome = endBiomeData.getEdgeBiome();
            if (!edgeBiome.equals((Object)BYG.EMPTY)) {
                voidBiomeToEdge.put((ResourceLocation)biome, edgeBiome);
            }
            allBiomes.add(biome);
            allBiomes.add(endBiomeData.getEdgeBiome());
        });
        voidHillsMap.remove(BYG.EMPTY);
        voidBiomeToEdge.remove(BYG.EMPTY);
        voidHillsMap.remove(null);
        voidBiomeToEdge.remove(null);
        this.field_226837_c_.addAll(allBiomes.stream().filter(resourceLocation -> resourceLocation != null && !resourceLocation.equals((Object)BYG.EMPTY)).map(arg_0 -> registry.func_82594_a(arg_0)).collect(Collectors.toList()));
        this.mainIslandLayer = SimpleLayerProvider.stackLayers(this.biomeRegistry, seed, BYG.worldConfig().endBiomeSize, (WeightedList<ResourceLocation>)endBiomes, endHills, biomeToEdge);
        this.smallIslandLayer = SimpleLayerProvider.stackLayers(this.biomeRegistry, seed, BYG.worldConfig().voidBiomeSize, (WeightedList<ResourceLocation>)voidBiomes, voidHillsMap, voidBiomeToEdge);
        this.generator = new SimplexNoiseGenerator((Random)sharedseedrandom);
    }

    protected Codec<? extends BiomeProvider> func_230319_a_() {
        return BYGENDCODEC;
    }

    public BiomeProvider func_230320_a_(long seed) {
        return new BYGEndBiomeSource(this.biomeRegistry, seed);
    }

    public Biome func_225526_b_(int x, int y, int z) {
        int xBitOffset = x >> 2;
        int zBitOffset = z >> 2;
        if ((long)xBitOffset * (long)xBitOffset + (long)zBitOffset * (long)zBitOffset <= 4096L) {
            return (Biome)this.biomeRegistry.func_243576_d(Biomes.field_76779_k);
        }
        float sampledNoise = EndBiomeProvider.func_235317_a_((SimplexNoiseGenerator)this.generator, (int)(xBitOffset * 2 + 1), (int)(zBitOffset * 2 + 1));
        if (sampledNoise >= -20.0f) {
            return this.mainIslandLayer.sampleEnd(this.biomeRegistry, x, z);
        }
        return this.smallIslandLayer.sampleEndVoid(this.biomeRegistry, x, z);
    }
}

