/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.IFeatureConfig;

public class PumpkinConfig
implements IFeatureConfig {
    public static final Codec<PumpkinConfig> CODEC = RecordCodecBuilder.create(codecRecorder -> codecRecorder.group((App)BlockStateProvider.field_236796_a_.fieldOf("pumpkin_provider").forGetter(config -> config.pumpkinProvider), (App)BlockStateProvider.field_236796_a_.fieldOf("stem_provider").forGetter(config -> config.stemProvider), (App)BlockStateProvider.field_236796_a_.fieldOf("leaves_provider").forGetter(config -> config.leavesProvider)).apply((Applicative)codecRecorder, PumpkinConfig::new));
    private final BlockStateProvider pumpkinProvider;
    private final BlockStateProvider stemProvider;
    private final BlockStateProvider leavesProvider;

    PumpkinConfig(BlockStateProvider pumpkinProvider, BlockStateProvider stemProvider, BlockStateProvider leavesProvider) {
        this.pumpkinProvider = pumpkinProvider;
        this.stemProvider = stemProvider;
        this.leavesProvider = leavesProvider;
    }

    public BlockStateProvider getPumpkinProvider() {
        return this.pumpkinProvider;
    }

    public BlockStateProvider getStemProvider() {
        return this.stemProvider;
    }

    public BlockStateProvider getLeavesProvider() {
        return this.leavesProvider;
    }

    public static class Builder {
        private BlockStateProvider pumpkinProvider = new SimpleBlockStateProvider(Blocks.field_150423_aK.func_176223_P());
        private BlockStateProvider stemProvider = new SimpleBlockStateProvider(Blocks.field_196617_K.func_176223_P());
        private BlockStateProvider leavesProvider = new SimpleBlockStateProvider(Blocks.field_196642_W.func_176223_P());

        public Builder setPumpkinBlock(Block block) {
            this.pumpkinProvider = new SimpleBlockStateProvider(block.func_176223_P());
            return this;
        }

        public Builder setPumpkinBlock(BlockState state) {
            this.pumpkinProvider = new SimpleBlockStateProvider(state);
            return this;
        }

        public Builder setStemBlock(Block block) {
            this.stemProvider = new SimpleBlockStateProvider(block.func_176223_P());
            return this;
        }

        public Builder setStemBlock(BlockState state) {
            this.stemProvider = new SimpleBlockStateProvider(state);
            return this;
        }

        public Builder setLeavesBlock(Block block) {
            this.leavesProvider = new SimpleBlockStateProvider(block.func_176223_P());
            return this;
        }

        public Builder setLeavesBlock(BlockState state) {
            this.leavesProvider = new SimpleBlockStateProvider(state);
            return this;
        }

        public PumpkinConfig build() {
            return new PumpkinConfig(this.pumpkinProvider, this.stemProvider, this.leavesProvider);
        }
    }
}

