/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.feature.overworld.mushrooms.util;

import com.mojang.serialization.Codec;
import corgiaoc.byg.common.world.feature.FeatureUtil;
import corgiaoc.byg.common.world.feature.config.BYGMushroomConfig;
import corgiaoc.byg.util.MLBlockTags;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.Feature;

public abstract class BYGAbstractMushroomFeature<T extends BYGMushroomConfig>
extends Feature<T> {
    public BYGAbstractMushroomFeature(Codec<T> configCodec) {
        super(configCodec);
    }

    public static boolean canStemPlaceHere(IWorldGenerationBaseReader worldReader, BlockPos blockPos) {
        return worldReader.func_217375_a(blockPos, AbstractBlock.AbstractBlockState::func_196958_f) || FeatureUtil.isPlant(worldReader, blockPos);
    }

    public boolean canStemPlaceHereWater(IWorldGenerationBaseReader worldReader, BlockPos blockPos) {
        return worldReader.func_217375_a(blockPos, state -> state.func_196958_f() || state.func_185904_a() == Material.field_151586_h) || FeatureUtil.isPlant(worldReader, blockPos);
    }

    public boolean isAnotherMushroomHere(IWorldGenerationBaseReader worldReader, BlockPos blockPos) {
        return worldReader.func_217375_a(blockPos, state -> {
            Block block = state.func_177230_c();
            return block.func_203417_a((ITag)BlockTags.field_200031_h) || block.func_203417_a((ITag)BlockTags.field_206952_E);
        });
    }

    public boolean isAnotherMushroomLikeThisHere(IWorldGenerationBaseReader worldReader, BlockPos blockPos, Block logBlock, Block leafBlock) {
        return worldReader.func_217375_a(blockPos, state -> {
            Block block = state.func_177230_c();
            return block == logBlock || block == leafBlock;
        });
    }

    public void placeStem(BlockState stemBlockState, ISeedReader reader, BlockPos pos) {
        if (BYGAbstractMushroomFeature.canStemPlaceHere((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState((IWorldWriter)reader, pos, stemBlockState);
        }
    }

    public void placeStemBranch(BlockState stemBlockState, ISeedReader reader, BlockPos pos) {
        if (BYGAbstractMushroomFeature.canStemPlaceHere((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState((IWorldWriter)reader, pos, stemBlockState);
        }
    }

    public void placeMushroom(BlockState mushroomBlockState, ISeedReader reader, BlockPos pos) {
        if (BYGAbstractMushroomFeature.isAir((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState((IWorldWriter)reader, pos, mushroomBlockState);
        }
    }

    public void placeMushroom2(BlockState mushroomBlockState, ISeedReader reader, BlockPos pos) {
        if (BYGAbstractMushroomFeature.isAir((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState((IWorldWriter)reader, pos, mushroomBlockState);
        }
    }

    public void placeMushroom3(BlockState mushroomBlockState, ISeedReader reader, BlockPos pos) {
        if (BYGAbstractMushroomFeature.isAir((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState((IWorldWriter)reader, pos, mushroomBlockState);
        }
    }

    public void placePollen(BlockState pollenBlockState, ISeedReader reader, BlockPos pos) {
        if (BYGAbstractMushroomFeature.isAir((IWorldGenerationBaseReader)reader, pos)) {
            this.setFinalBlockState((IWorldWriter)reader, pos, pollenBlockState);
        }
    }

    public boolean canGiantMushroomGrowHere(IWorldGenerationBaseReader reader, BlockPos pos) {
        return reader.func_217375_a(pos, state -> {
            Block block = state.func_177230_c();
            return block.func_203417_a((ITag)BlockTags.field_200031_h) || block.func_203417_a((ITag)BlockTags.field_206952_E) || state.func_196958_f() || state.func_185904_a() == Material.field_151585_k || state.func_185904_a() == Material.field_151582_l || state.func_185904_a() == Material.field_203243_f || state.func_185904_a() == Material.field_151584_j || state.func_185904_a() == Material.field_151578_c;
        });
    }

    public static boolean isAir(IWorldGenerationBaseReader reader, BlockPos pos) {
        return reader.func_217375_a(pos, AbstractBlock.AbstractBlockState::func_196958_f);
    }

    public boolean isAirOrWater(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, state -> state.func_196958_f() || state.func_177230_c() == Blocks.field_150355_j);
    }

    public static boolean isDesiredGroundwDirtTag(BYGMushroomConfig config, IWorldGenerationBaseReader reader, BlockPos pos, Block ... desiredGroundBlock) {
        if (config.isPlacementForced()) {
            return true;
        }
        return reader.func_217375_a(pos, state -> {
            Block block = state.func_177230_c();
            int n = 0;
            Block[] blockArray = desiredGroundBlock;
            int n2 = blockArray.length;
            if (n < n2) {
                Block block1 = blockArray[n];
                return block.func_203417_a(MLBlockTags.DIRT) || block == block1;
            }
            return block.func_203417_a(MLBlockTags.DIRT);
        });
    }

    public static boolean isDesiredGroundwEndTags(BYGMushroomConfig config, IWorldGenerationBaseReader reader, BlockPos pos, Block ... desiredGroundBlock) {
        if (config.isPlacementForced()) {
            return true;
        }
        return reader.func_217375_a(pos, state -> {
            Block block = state.func_177230_c();
            int n = 0;
            Block[] blockArray = desiredGroundBlock;
            int n2 = blockArray.length;
            if (n < n2) {
                Block block1 = blockArray[n];
                return block.func_203417_a(MLBlockTags.END_STONES) || block == block1;
            }
            return block.func_203417_a(MLBlockTags.END_STONES);
        });
    }

    public boolean doesMushroomHaveSpaceToGrow(IWorldGenerationBaseReader reader, BlockPos pos, int treeHeight, int canopyStartHeight, int xDistance, int zDistance, boolean isSapling, BlockPos ... trunkPositions) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        if (isSapling) {
            for (int yOffSet = 0; yOffSet <= treeHeight; ++yOffSet) {
                if (!this.canGiantMushroomGrowHere(reader, (BlockPos)mutable.func_181079_c(x, y + yOffSet, z))) {
                    return false;
                }
                if (trunkPositions.length <= 0) continue;
                for (BlockPos trunkPos : trunkPositions) {
                    if (this.canGiantMushroomGrowHere(reader, (BlockPos)mutable.func_181079_c(trunkPos.func_177958_n(), trunkPos.func_177956_o() + yOffSet, trunkPos.func_177952_p()))) continue;
                    return false;
                }
            }
            for (int yOffset = canopyStartHeight; yOffset <= treeHeight + 1; ++yOffset) {
                for (int xOffset = -xDistance; xOffset <= xDistance; ++xOffset) {
                    for (int zOffset = -zDistance; zOffset <= zDistance; ++zOffset) {
                        if (this.canGiantMushroomGrowHere(reader, (BlockPos)mutable.func_181079_c(x + xOffset, y + yOffset, z + zOffset))) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean doesMushroomHaveSpaceToGrow(IWorldGenerationBaseReader reader, BlockPos pos, int treeHeight, int canopyStartHeight, int xNegativeDistance, int zNegativeDistance, int xPositiveDistance, int zPositiveDistance, boolean isSapling, BlockPos ... trunkPositions) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        if (isSapling) {
            for (int yOffSet = 0; yOffSet <= treeHeight; ++yOffSet) {
                if (!this.canGiantMushroomGrowHere(reader, (BlockPos)mutable.func_181079_c(x, y + yOffSet, z))) {
                    return false;
                }
                if (trunkPositions.length <= 0) continue;
                for (BlockPos trunkPos : trunkPositions) {
                    if (this.canGiantMushroomGrowHere(reader, (BlockPos)mutable.func_181079_c(trunkPos.func_177958_n(), trunkPos.func_177956_o() + yOffSet, trunkPos.func_177952_p()))) continue;
                    return false;
                }
            }
            for (int yOffset = canopyStartHeight; yOffset <= treeHeight + 1; ++yOffset) {
                for (int xOffset = -xNegativeDistance; xOffset <= xPositiveDistance; ++xOffset) {
                    for (int zOffset = -zNegativeDistance; zOffset <= zPositiveDistance; ++zOffset) {
                        if (this.canGiantMushroomGrowHere(reader, (BlockPos)mutable.func_181079_c(x + xOffset, y + yOffset, z + zOffset))) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public boolean isAnotherMushroomLikeThisNearby(IWorldGenerationBaseReader reader, BlockPos pos, int treeHeight, int distance, Block stemBlock, Block mushroomBlock, boolean isMushroom) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        if (!isMushroom) {
            for (int yOffset = 0; yOffset <= treeHeight + 1; ++yOffset) {
                for (int xOffset = -distance; xOffset <= distance; ++xOffset) {
                    for (int zOffset = -distance; zOffset <= distance; ++zOffset) {
                        if (!this.isAnotherMushroomLikeThisHere(reader, (BlockPos)mutable.func_181079_c(x + xOffset, y + yOffset, z + zOffset), stemBlock, mushroomBlock)) continue;
                        return false;
                    }
                }
            }
        }
        return true;
    }

    public final void setFinalBlockState(IWorldWriter worldIn, BlockPos pos, BlockState blockState) {
        this.setBlockStateWithoutUpdates(worldIn, pos, blockState);
    }

    public void setBlockStateWithoutUpdates(IWorldWriter worldWriter, BlockPos blockPos, BlockState blockState) {
        worldWriter.func_180501_a(blockPos, blockState, 2);
    }

    protected void func_230367_a_(IWorldWriter worldIn, BlockPos pos, BlockState state) {
        this.setBlockStateWithoutUpdates(worldIn, pos, state);
    }

    public boolean place(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos pos, T config) {
        return this.placeMushroom(worldIn, rand, pos, ((BYGMushroomConfig)config).isPlacementForced(), config);
    }

    protected abstract boolean placeMushroom(ISeedReader var1, Random var2, BlockPos var3, boolean var4, T var5);
}

