/*
 * Decompiled with CFR 0.152.
 */
package carpetextra;

import carpet.settings.ParsedRule;
import carpet.settings.Rule;
import carpet.settings.Validator;
import net.minecraft.class_2168;

public class CarpetExtraSettings {
    public static final String EXTRA = "extras";
    @Rule(desc="Max distance for scaffolding.", options={"2", "3", "5", "7"}, category={"feature", "extras"}, strict=false, validate={validatorScaffoldingDistance.class})
    public static int scaffoldingDistance = 7;
    @Rule(desc="Pistons and sticky pistons redirect redstone", extra={"When retracting, they will blink visually", "but that's only to minimize changes required for it to work"}, category={"extras", "feature"})
    public static boolean pistonRedirectsRedstone = false;
    @Rule(desc="Fixes updates suppression causing server crashes.", category={"bugfix", "extras"})
    public static boolean updateSuppressionCrashFix = false;
    @Rule(desc="Auto-crafting dropper", extra={"If a dropper points into a crafting table and contains a valid 3x3 crafting recipe, firing that ", "dropper will cause it to craft (drop as item) that recipe. ", "Overrides comparators so they indicate number of filled slots instead.", "Also makes hoppers, droppers and dispensers input max 1 item per slot."}, category={"creative", "extras", "dispenser"})
    public static boolean autoCraftingDropper = false;
    @Rule(desc="Dispensers can place blocks.", category={"creative", "extras", "dispenser"})
    public static boolean dispenserPlacesBlocks = false;
    @Rule(desc="Variable delays on wooden components (buttons, pressure plates).", category={"extras", "feature"})
    public static boolean variableWoodDelays = false;
    @Rule(desc="Allows Comparators to read the daytime instead of the rotation of clocks in item frames.", category={"feature", "extras", "experimental"})
    public static boolean comparatorReadsClock = false;
    @Rule(desc="Makes Hopper Minecarts have an 8gt cooldown like hoppers.", category={"bugfix", "feature", "extras", "experimental"})
    public static boolean hopperMinecart8gtCooldown = false;
    @Rule(desc="Allows Hopper Minecarts to transfer items into containers below them.", category={"bugfix", "feature", "extras", "experimental"})
    public static boolean hopperMinecartItemTransfer = false;
    @Rule(desc="Enables `/ping` for players to get their ping.", category={"command", "extras"})
    public static boolean commandPing = true;
    @Rule(desc="Minecarts can be filled with hoppers, chests, tnt and furnace.", category={"experimental", "feature", "extras", "dispenser"})
    public static boolean dispensersFillMinecarts = false;
    @Rule(desc="Clerics can warm nether farts.", extra={"This will also allow them to pick up wart items, as well as pathfind to soulsand."}, category={"extras", "feature"})
    public static boolean clericsFarmWarts = false;
    @Rule(desc="Multiple ice crushed by falling anvils make packed ice.", category={"extras", "experimental", "feature"})
    public static boolean renewablePackedIce = false;
    @Rule(desc="Dispensers can play records if there's a jukebox in front of them.", extra={"If a record already exists in the jukebox, it gets placed back in the dispenser."}, category={"extras", "feature", "dispenser"})
    public static boolean dispensersPlayRecords = false;
    @Rule(desc="Client can provide alternative block placement.", category={"extras", "survival"})
    public static boolean accurateBlockPlacement = false;
    @Rule(desc="Dispensers containing a stick can toggle things.", extra={"Works with buttons, redstone, noteblocks, comparators, repeaters, ", "daylight detectors, etc."}, category={"extras", "experimental", "feature", "dispenser"})
    public static boolean dispensersToggleThings = false;
    @Rule(desc="Dispensers with hoes can till soil.", category={"extras", "feature", "dispenser"})
    public static boolean dispensersTillSoil = false;
    @Rule(desc="Dispensers can feed animals.", category={"extras", "experimental", "feature", "dispenser"})
    public static boolean dispensersFeedAnimals = false;
    @Rule(desc="Disables player entity collision.", category={"extras", "creative", "experimental"})
    public static boolean disablePlayerCollision = false;
    @Rule(desc="Obsidian surrounded by 6 lava sources has a chance of converting to lava.", category={"extras", "experimental", "feature"}, extra={"Credits: Skyrising"})
    public static boolean renewableLava = false;
    @Rule(desc="Re-adds 1.8 double retraction to pistons.", category={"extras", "experimental"}, extra={"Gives pistons the ability to double retract without side effects.", "Fixes [MC-88959](https://bugs.mojang.com/browse/MC-88959)."})
    public static boolean doubleRetraction = false;
    @Rule(desc="Fixes block states in F3 debug mode not updating for some blocks.", category={"extras", "experimental"}, extra={"May cause increased network traffic.", "Works with cactus, sugar cane, saplings, hoppers, dispensers and droppers."})
    public static boolean blockStateSyncing = false;
    @Rule(desc="Cobblestone crushed by falling anvils makes sand.", category={"extras", "experimental", "feature"})
    public static boolean renewableSand = false;
    @Rule(desc="Reintroduce the Dragon Egg Bedrock breaking bug from 1.12.", category={"extras", "experimental"})
    public static boolean dragonEggBedrockBreaking = false;
    @Rule(desc="Fire charges from dispensers convert cobblestone to netherrack.", category={"extras", "experimental"}, extra={"Credits: Skyrising"})
    public static boolean fireChargeConvertsToNetherrack = false;
    @Rule(desc="Chickens can be sheared to get feathers. Beware! every time u shear a chicken, it gets damaged!", category={"extras", "feature"}, extra={"Baby chickens can't be sheared."})
    public static boolean chickenShearing = false;
    @Rule(desc="If a living entity dies on sand with fire on top the sand will convert into soul sand.", category={"extras", "feature", "experimental"})
    public static boolean mobInFireConvertsSandToSoulsand = false;
    @Rule(desc="Placing a wither rose in a flowerpot will load that chunk.", extra={"If u enable the rule the already existing chunks with flowerpots won't be loaded. ", "Also disabling the carpet rule won't remove the loaded chunks, u need to manually unload them using the /forceload command. ", "All the loaded chunks can be seen using `/forceload query`"}, category={"extras", "feature", "experimental"})
    public static boolean flowerPotChunkLoading = false;
    @Rule(desc="Won't let mobs glitch into blocks when reloaded.", extra={"Can cause slight differences in mobs behaviour.", "Fixes [MC-2025](https://bugs.mojang.com/browse/MC-2025)."}, category={"extras", "bugfix", "experimental"})
    public static boolean reloadSuffocationFix = false;
    @Rule(desc="Dispensers with empty buckets can milk cows and get stew from mooshrooms with bowls.", category={"experimental", "extras", "feature", "dispenser"})
    public static boolean dispensersMilkCows = false;
    @Rule(desc="Quick pulses won't get lost in repeater setups.", extra={"Probably brings back pre 1.8 behaviour.", "Fixes [MC-54711](https://bugs.mojang.com/browse/MC-54711)."}, category={"extras", "bugfix", "experimental"})
    public static boolean repeaterPriorityFix = false;
    @Rule(desc="Only strays spawn in igloos.", category={"feature", "extras"})
    public static boolean straySpawningInIgloos = false;
    @Rule(desc="Skeletons turn into wither skeletons when struck by lightning.", category={"feature", "extras"})
    public static boolean renewableWitherSkeletons = false;
    @Rule(desc="Only creepers spawn in jungle temples.", category={"feature", "extras"})
    public static boolean creeperSpawningInJungleTemples = false;
    @Rule(desc="Let dragon eggs break Y0 bedrock.", extra={"Requires dragonEggBedrockBreaking to be set to true."}, category={"experimental", "extras"})
    public static boolean y0DragonEggBedrockBreaking = false;
    @Rule(desc="Gives Spider jockeys a specified chance to drop enchanted golden apples.", extra={"0 is the default setting, no enchanted golden apples will be dropped"}, options={"0", "50", "100"}, category={"extras", "feature"}, validate={ValidateSpiderJokeyDropChance.class})
    public static int spiderJockeysDropGapples = 0;
    @Rule(desc="Dragon's breath from dispensers convert cobblestone to end stone.", category={"extras", "experimental", "dispenser"})
    public static boolean dragonsBreathConvertsCobbleToEndstone = false;
    @Rule(desc="Maximum water sucking for sponge.", options={"64"}, category={"feature", "extras"}, strict=false)
    public static int maxSpongeSuck = 64;
    @Rule(desc="Maximum offset limit for sponge.", options={"7"}, category={"feature", "extras"}, strict=false)
    public static int maxSpongeRange = 7;
    @Rule(desc="Empty Shulker Boxes will always stack, even inside inventories.", category={"feature", "extras", "experimental"})
    public static boolean emptyShulkerBoxStackAlways = false;
    @Rule(desc="Allow horizontally moving Ender Pearls to load chunks as entity ticking.", category={"feature", "extras"})
    public static boolean enderPearlChunkLoading = false;
    @Rule(desc="Bonemeal can be used to grow sugarcane and cactus.", category={"feature", "extras", "survival"})
    public static boolean betterBonemeal = false;
    @Rule(desc="Dispensers containing shears can carve pumpkins.", category={"extras", "feature", "dispenser"})
    public static boolean dispensersCarvePumpkins = false;
    @Rule(desc="Blaze powder fertilizes netherwart.", extra={"Via dispenser or player right click actions."}, category={"extras", "feature", "survival"})
    public static boolean blazeMeal = false;

    public static class ValidateSpiderJokeyDropChance
    extends Validator<Integer> {
        public Integer validate(class_2168 source, ParsedRule<Integer> currentRule, Integer newValue, String string) {
            return newValue >= 0 && newValue <= 100 ? newValue : null;
        }

        public String description() {
            return "You must choose a value from 0 to 100";
        }
    }

    public static class validatorScaffoldingDistance
    extends Validator<Integer> {
        public Integer validate(class_2168 source, ParsedRule<Integer> currentRule, Integer newValue, String string) {
            return newValue >= 0 && newValue <= 7 ? newValue : null;
        }

        public String description() {
            return "You must choose a value from 0 to 7";
        }
    }
}

