/*
 * Decompiled with CFR 0.152.
 */
package carpetextra.helpers;

import carpetextra.CarpetExtraSettings;
import carpetextra.utils.PlaceBlockDispenserBehavior;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1541;
import net.minecraft.class_1657;
import net.minecraft.class_1688;
import net.minecraft.class_1695;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2387;
import net.minecraft.class_2421;
import net.minecraft.class_243;
import net.minecraft.class_2601;
import net.minecraft.class_2619;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;

public class CarpetDispenserBehaviours {

    public static class BlazePowderBehavior
    extends class_2347 {
        protected class_1799 method_10135(class_2342 pointer, class_1799 stack) {
            int age;
            if (!CarpetExtraSettings.blazeMeal) {
                return super.method_10135(pointer, stack);
            }
            class_3218 world = pointer.method_10207();
            class_2350 direction = (class_2350)pointer.method_10120().method_11654((class_2769)class_2315.field_10918);
            class_2338 front = pointer.method_10122().method_10093(direction);
            class_2680 state = world.method_8320(front);
            if (state.method_26204() == class_2246.field_9974 && (age = ((Integer)state.method_11654((class_2769)class_2421.field_11306)).intValue()) < 3) {
                world.method_8652(front, (class_2680)class_2246.field_9974.method_9564().method_11657((class_2769)class_2421.field_11306, (Comparable)Integer.valueOf(age + 1)), 2);
                world.method_20290(2005, front, 0);
                stack.method_7934(1);
                return stack;
            }
            return stack;
        }
    }

    public static class MushroomStewBehavior
    extends class_2347 {
        protected class_1799 method_10135(class_2342 pointer, class_1799 stack) {
            class_2338 pos;
            List mooshroom;
            if (!CarpetExtraSettings.dispensersMilkCows) {
                return super.method_10135(pointer, stack);
            }
            class_3218 world = pointer.method_10207();
            if (!world.field_9236 && !(mooshroom = world.method_18023(class_1299.field_6143, new class_238(pos = pointer.method_10122().method_10093((class_2350)pointer.method_10120().method_11654((class_2769)class_2315.field_10918))), e -> e.method_5805() && !e.method_6109())).isEmpty()) {
                stack.method_7934(1);
                if (stack.method_7960()) {
                    return new class_1799((class_1935)class_1802.field_8208);
                }
                if (((class_2601)pointer.method_10121()).method_11075(new class_1799((class_1935)class_1802.field_8208)) < 0) {
                    super.method_10135(pointer, new class_1799((class_1935)class_1802.field_8208));
                }
                return stack;
            }
            return super.method_10135(pointer, stack);
        }
    }

    public static class DragonsBreathDispenserBehaviour
    extends class_2347 {
        protected class_1799 method_10135(class_2342 source, class_1799 stack) {
            if (!CarpetExtraSettings.dragonsBreathConvertsCobbleToEndstone) {
                return super.method_10135(source, stack);
            }
            class_3218 world = source.method_10207();
            class_2350 direction = (class_2350)source.method_10120().method_11654((class_2769)class_2315.field_10918);
            class_2338 front = source.method_10122().method_10093(direction);
            class_2680 state = world.method_8320(front);
            if (state.method_26204() == class_2246.field_10445) {
                world.method_8501(front, class_2246.field_10471.method_9564());
                stack.method_7934(1);
                return stack;
            }
            return super.method_10135(source, stack);
        }
    }

    public static class TillSoilDispenserBehaviour
    extends class_2347 {
        protected class_1799 method_10135(class_2342 blockPointer_1, class_1799 itemStack_1) {
            if (!CarpetExtraSettings.dispensersTillSoil) {
                return super.method_10135(blockPointer_1, itemStack_1);
            }
            class_3218 world = blockPointer_1.method_10207();
            class_2350 direction = (class_2350)blockPointer_1.method_10120().method_11654((class_2769)class_2315.field_10918);
            class_2338 front = blockPointer_1.method_10122().method_10093(direction);
            class_2338 down = blockPointer_1.method_10122().method_10074().method_10093(direction);
            class_2680 frontState = world.method_8320(front);
            class_2680 downState = world.method_8320(down);
            if (this.isFarmland(frontState) || this.isFarmland(downState)) {
                return itemStack_1;
            }
            if (this.canDirectlyTurnToFarmland(frontState)) {
                world.method_8501(front, class_2246.field_10362.method_9564());
            } else if (this.canDirectlyTurnToFarmland(downState)) {
                world.method_8501(down, class_2246.field_10362.method_9564());
            } else if (frontState.method_26204() == class_2246.field_10253) {
                world.method_8501(front, class_2246.field_10566.method_9564());
            } else if (downState.method_26204() == class_2246.field_10253) {
                world.method_8501(down, class_2246.field_10566.method_9564());
            }
            if (itemStack_1.method_7970(1, world.field_9229, null)) {
                itemStack_1.method_7939(0);
            }
            return itemStack_1;
        }

        private boolean canDirectlyTurnToFarmland(class_2680 state) {
            return state.method_26204() == class_2246.field_10566 || state.method_26204() == class_2246.field_10219 || state.method_26204() == class_2246.field_10194;
        }

        private boolean isFarmland(class_2680 state) {
            return state.method_26204() == class_2246.field_10362;
        }
    }

    public static class FeedAnimalDispenserBehaviour
    extends class_2347 {
        protected class_1799 method_10135(class_2342 source, class_1799 stack) {
            class_2338 pos = source.method_10122().method_10093((class_2350)source.method_10120().method_11654((class_2769)class_2315.field_10918));
            List list = source.method_10207().method_8390(class_1429.class, new class_238(pos), class_1301.field_6154);
            boolean failure = false;
            for (class_1429 mob : list) {
                if (!mob.method_6481(stack)) continue;
                if (mob.method_5618() == 0 && mob.method_6482()) {
                    mob.method_6480(null);
                } else if (mob.method_6109()) {
                    mob.method_5620((int)((float)(-mob.method_5618() / 20) * 0.1f), true);
                } else {
                    failure = true;
                    continue;
                }
                stack.method_7934(1);
                return stack;
            }
            if (failure) {
                return stack;
            }
            if (stack.method_7909() instanceof class_1747 && PlaceBlockDispenserBehavior.canPlace(((class_1747)stack.method_7909()).method_7711())) {
                return PlaceBlockDispenserBehavior.getInstance().method_10135(source, stack);
            }
            return super.method_10135(source, stack);
        }
    }

    public static class TogglingDispenserBehaviour
    extends class_2347 {
        private static Set<class_2248> toggleable = Sets.newHashSet((Object[])new class_2248[]{class_2246.field_10494, class_2246.field_10278, class_2246.field_10417, class_2246.field_10493, class_2246.field_10553, class_2246.field_10057, class_2246.field_10066, class_2246.field_10450, class_2246.field_10377, class_2246.field_10363, class_2246.field_10429, class_2246.field_10080, class_2246.field_10223, class_2246.field_10179, class_2246.field_10091});

        protected class_1799 method_10135(class_2342 source, class_1799 stack) {
            class_1269 result;
            if (!CarpetExtraSettings.dispensersToggleThings) {
                return super.method_10135(source, stack);
            }
            class_3218 world = source.method_10207();
            class_2350 direction = (class_2350)source.method_10120().method_11654((class_2769)class_2315.field_10918);
            class_2338 pos = source.method_10122().method_10093(direction);
            class_2680 state = world.method_8320(pos);
            if (toggleable.contains(state.method_26204()) && (result = state.method_26174((class_1937)world, null, class_1268.field_5808, new class_3965(class_243.method_24954((class_2382)pos), direction, pos, false))).method_23665()) {
                return stack;
            }
            return super.method_10135(source, stack);
        }
    }

    public static class MinecartDispenserBehaviour
    extends class_2347 {
        private final class_1688.class_1689 minecartType;

        public MinecartDispenserBehaviour(class_1688.class_1689 minecartType) {
            this.minecartType = minecartType;
        }

        public class_1799 method_10135(class_2342 source, class_1799 stack) {
            if (!CarpetExtraSettings.dispensersFillMinecarts) {
                return this.defaultBehaviour(source, stack);
            }
            class_2338 pos = source.method_10122().method_10093((class_2350)source.method_10120().method_11654((class_2769)class_2315.field_10918));
            List list = source.method_10207().method_8390(class_1695.class, new class_238(pos), class_1301.field_6154);
            if (list.isEmpty()) {
                return this.defaultBehaviour(source, stack);
            }
            class_1695 minecart = (class_1695)list.get(0);
            minecart.method_5650();
            class_1688 minecartEntity = class_1688.method_7523((class_1937)minecart.field_6002, (double)minecart.method_23317(), (double)minecart.method_23318(), (double)minecart.method_23321(), (class_1688.class_1689)this.minecartType);
            minecartEntity.method_18799(minecart.method_18798());
            minecartEntity.field_5965 = minecart.field_5965;
            minecartEntity.field_6031 = minecart.field_6031;
            minecart.field_6002.method_8649((class_1297)minecartEntity);
            stack.method_7934(1);
            return stack;
        }

        private class_1799 defaultBehaviour(class_2342 source, class_1799 stack) {
            if (this.minecartType == class_1688.class_1689.field_7675) {
                class_3218 world = source.method_10207();
                class_2338 pos = source.method_10122().method_10093((class_2350)source.method_10120().method_11654((class_2769)class_2315.field_10918));
                class_1541 tntEntity = new class_1541((class_1937)world, (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, (class_1309)null);
                world.method_8649((class_1297)tntEntity);
                world.method_8465((class_1657)null, tntEntity.method_23317(), tntEntity.method_23318(), tntEntity.method_23321(), class_3417.field_15079, class_3419.field_15245, 1.0f, 1.0f);
                stack.method_7934(1);
                return stack;
            }
            if (stack.method_7909() instanceof class_1747 && PlaceBlockDispenserBehavior.canPlace(((class_1747)stack.method_7909()).method_7711())) {
                return PlaceBlockDispenserBehavior.getInstance().method_10135(source, stack);
            }
            return super.method_10135(source, stack);
        }

        protected void method_10136(class_2342 source) {
            source.method_10207().method_20290(1000, source.method_10122(), 0);
        }
    }

    public static class DispenserRecords
    extends class_2347 {
        protected class_1799 method_10135(class_2342 source, class_1799 stack) {
            class_2619 jukebox;
            if (!CarpetExtraSettings.dispensersPlayRecords) {
                return super.method_10135(source, stack);
            }
            class_2350 direction = (class_2350)source.method_10120().method_11654((class_2769)class_2315.field_10918);
            class_2338 pos = source.method_10122().method_10093(direction);
            class_3218 world = source.method_10207();
            class_2680 state = world.method_8320(pos);
            if (state.method_26204() == class_2246.field_10223 && (jukebox = (class_2619)world.method_8321(pos)) != null) {
                class_1799 itemStack = jukebox.method_11275();
                ((class_2387)state.method_26204()).method_10276((class_1936)world, pos, state, stack);
                world.method_20290(1010, pos, class_1792.method_7880((class_1792)stack.method_7909()));
                return itemStack;
            }
            return super.method_10135(source, stack);
        }
    }
}

