/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.phosphor.mixin.chunk.light;

import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Arrays;
import me.jellysquid.mods.phosphor.common.chunk.light.IReadonly;
import me.jellysquid.mods.phosphor.common.chunk.light.LevelPropagatorAccess;
import me.jellysquid.mods.phosphor.common.chunk.light.SkyLightStorageDataAccess;
import me.jellysquid.mods.phosphor.common.util.chunk.light.EmptyChunkNibbleArray;
import me.jellysquid.mods.phosphor.common.util.chunk.light.SkyLightChunkNibbleArray;
import me.jellysquid.mods.phosphor.common.util.math.ChunkSectionPosHelper;
import me.jellysquid.mods.phosphor.mixin.chunk.light.MixinLightStorage;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2804;
import net.minecraft.class_3558;
import net.minecraft.class_3569;
import net.minecraft.class_4076;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3569.class})
public abstract class MixinSkyLightStorage
extends MixinLightStorage<class_3569.class_3570> {
    @Unique
    private final LongSet preInitSkylightChunks = new LongOpenHashSet();
    @Unique
    private final LongSet initSkylightChunks = new LongOpenHashSet();
    @Shadow
    @Final
    private LongSet field_15817;
    @Shadow
    private volatile boolean field_15819;
    @Unique
    private static final class_2804 DIRECT_SKYLIGHT_MAP = MixinSkyLightStorage.createDirectSkyLightMap();
    @Unique
    private final Long2IntMap vanillaLightmapComplexities = new Long2IntOpenHashMap();
    @Unique
    private final LongSet removedLightmaps = new LongOpenHashSet();

    /*
     * Unable to fully structure code
     */
    @Overwrite
    public int method_15538(long pos) {
        posX = class_2338.method_10061((long)pos);
        posYOrig = class_2338.method_10071((long)pos);
        posZ = class_2338.method_10083((long)pos);
        chunkX = class_4076.method_18675((int)posX);
        chunkYOrig = class_4076.method_18675((int)posYOrig);
        chunkZ = class_4076.method_18675((int)posZ);
        chunkOrig = class_4076.method_18685((int)chunkX, (int)chunkYOrig, (int)chunkZ);
        lock = this.getStorageLock();
        do lbl-1000:
        // 4 sources

        {
            block2: {
                stamp = lock.tryOptimisticRead();
                posY = posYOrig;
                chunkY = chunkYOrig;
                chunk = chunkOrig;
                data = (class_3569.class_3570)this.getStorage();
                sdata = (SkyLightStorageDataAccess)data;
                height = sdata.getHeight(class_4076.method_18693((long)chunk));
                if (height != sdata.getDefaultHeight() && chunkY < height) break block2;
                if (!lock.validate(stamp)) ** GOTO lbl-1000
                return 15;
            }
            array = data.method_15501(chunk);
            while (array == null) {
                block3: {
                    if (++chunkY < height) break block3;
                    if (!lock.validate(stamp)) ** GOTO lbl-1000
                    return 15;
                }
                chunk = ChunkSectionPosHelper.updateYLong(chunk, chunkY);
                array = data.method_15501(chunk);
                posY = chunkY << 4;
            }
        } while (!lock.validate(stamp));
        return array.method_12139(class_4076.method_18684((int)posX), class_4076.method_18684((int)posY), class_4076.method_18684((int)posZ));
    }

    @Shadow
    protected abstract boolean method_15568(long var1);

    @Shadow
    protected abstract boolean method_15566(long var1);

    @Override
    public int getLightWithoutLightmap(long blockPos) {
        long sectionPos = class_4076.method_18691((long)blockPos);
        class_2804 lightmap = this.getLightmapAbove(sectionPos);
        if (lightmap == null) {
            return this.method_15566(sectionPos) ? 15 : 0;
        }
        return lightmap.method_12139(class_4076.method_18684((int)class_2338.method_10061((long)blockPos)), 0, class_4076.method_18684((int)class_2338.method_10083((long)blockPos)));
    }

    @Redirect(method={"createSection(J)Lnet/minecraft/world/chunk/ChunkNibbleArray;"}, at=@At(value="NEW", target="()Lnet/minecraft/world/chunk/ChunkNibbleArray;"))
    private class_2804 initializeLightmap(long pos) {
        class_2804 ret = new class_2804();
        if (this.method_15566(pos)) {
            Arrays.fill(ret.method_12137(), (byte)-1);
        }
        return ret;
    }

    @Inject(method={"enqueueRemoveSection(J)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void disable_enqueueRemoveSection(CallbackInfo ci) {
        ci.cancel();
    }

    @Inject(method={"enqueueAddSection(J)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void disable_enqueueAddSection(CallbackInfo ci) {
        ci.cancel();
    }

    @Override
    public void beforeChunkEnabled(long chunkPos) {
        if (!this.method_15566(chunkPos)) {
            this.preInitSkylightChunks.add(chunkPos);
            this.method_15478(Long.MAX_VALUE, class_4076.method_18685((int)class_4076.method_18686((long)chunkPos), (int)16, (int)class_4076.method_18690((long)chunkPos)), 1, true);
        }
    }

    @Override
    public void afterChunkDisabled(long chunkPos) {
        if (this.preInitSkylightChunks.remove(chunkPos)) {
            this.method_15478(Long.MAX_VALUE, class_4076.method_18685((int)class_4076.method_18686((long)chunkPos), (int)16, (int)class_4076.method_18690((long)chunkPos)), 2, false);
        }
    }

    @Override
    protected int method_18749(long id) {
        int ret = super.method_18749(id);
        if (ret >= 2 && class_4076.method_18689((long)id) == 16 && this.preInitSkylightChunks.contains(class_4076.method_18693((long)id))) {
            return 1;
        }
        return ret;
    }

    @Override
    @Overwrite
    public void method_15535(long chunkPos, boolean enabled) {
        if (enabled) {
            if (this.preInitSkylightChunks.contains(chunkPos)) {
                this.initSkylightChunks.add(chunkPos);
                this.method_15569();
            } else {
                this.field_15817.add(chunkPos);
            }
        } else {
            this.field_15817.remove(chunkPos);
            this.initSkylightChunks.remove(chunkPos);
            this.method_15569();
        }
    }

    @Unique
    private static void spreadSourceSkylight(LevelPropagatorAccess lightProvider, long src, class_2350 dir) {
        lightProvider.invokePropagateLevel(src, class_2338.method_10060((long)src, (class_2350)dir), 0, true);
    }

    @Override
    @Overwrite
    public void method_15527(class_3558<class_3569.class_3570, ?> lightProvider, boolean doSkylight, boolean skipEdgeLightPropagation) {
        super.method_15527(lightProvider, doSkylight, skipEdgeLightPropagation);
        if (!doSkylight || !this.field_15819) {
            return;
        }
        LongIterator it = this.initSkylightChunks.iterator();
        while (it.hasNext()) {
            long chunkPos = it.nextLong();
            LevelPropagatorAccess levelPropagator = (LevelPropagatorAccess)lightProvider;
            int minY = this.fillSkylightColumn(lightProvider, chunkPos);
            this.field_15817.add(chunkPos);
            this.preInitSkylightChunks.remove(chunkPos);
            this.method_15478(Long.MAX_VALUE, class_4076.method_18685((int)class_4076.method_18686((long)chunkPos), (int)16, (int)class_4076.method_18690((long)chunkPos)), 2, false);
            if (this.method_15524(class_4076.method_18685((int)class_4076.method_18686((long)chunkPos), (int)minY, (int)class_4076.method_18690((long)chunkPos)))) {
                long blockPos = class_2338.method_10064((int)class_4076.method_18688((int)class_4076.method_18686((long)chunkPos)), (int)class_4076.method_18688((int)minY), (int)class_4076.method_18688((int)class_4076.method_18690((long)chunkPos)));
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        MixinSkyLightStorage.spreadSourceSkylight(levelPropagator, class_2338.method_10096((long)blockPos, (int)x, (int)16, (int)z), class_2350.field_11033);
                    }
                }
            }
            for (class_2350 dir : class_2350.class_2353.field_11062) {
                boolean spread = !this.initSkylightChunks.contains(class_4076.method_18679((long)chunkPos, (class_2350)dir));
                for (int y = 16; y > minY; --y) {
                    long sectionPos = class_4076.method_18685((int)class_4076.method_18686((long)chunkPos), (int)y, (int)class_4076.method_18690((long)chunkPos));
                    long neighborSectionPos = class_4076.method_18679((long)sectionPos, (class_2350)dir);
                    if (!this.method_15524(neighborSectionPos)) continue;
                    if (!spread) {
                        if (!this.field_15808.contains(neighborSectionPos)) continue;
                        spread = true;
                    }
                    long blockPos = class_2338.method_10064((int)class_4076.method_18688((int)class_4076.method_18686((long)sectionPos)), (int)class_4076.method_18688((int)y), (int)class_4076.method_18688((int)class_4076.method_18690((long)sectionPos)));
                    int ox = 15 * Math.max(dir.method_10148(), 0);
                    int oz = 15 * Math.max(dir.method_10165(), 0);
                    int dx = Math.abs(dir.method_10165());
                    int dz = Math.abs(dir.method_10148());
                    for (int t = 0; t < 16; ++t) {
                        for (int dy = 0; dy < 16; ++dy) {
                            MixinSkyLightStorage.spreadSourceSkylight(levelPropagator, class_2338.method_10096((long)blockPos, (int)(ox + t * dx), (int)dy, (int)(oz + t * dz)), dir);
                        }
                    }
                }
            }
        }
        this.initSkylightChunks.clear();
        if (!this.removedLightmaps.isEmpty()) {
            LongOpenHashSet removedLightmaps = new LongOpenHashSet((LongCollection)this.removedLightmaps);
            LongIterator it2 = removedLightmaps.iterator();
            while (it2.hasNext()) {
                long sectionPos = it2.nextLong();
                if (!this.enabledChunks.contains(class_4076.method_18693((long)sectionPos)) || !this.removedLightmaps.contains(sectionPos)) continue;
                long sectionPosAbove = this.getSectionAbove(sectionPos);
                if (sectionPosAbove == Long.MAX_VALUE) {
                    this.updateVanillaLightmapsBelow(sectionPos, (class_2804)(this.method_15566(sectionPos) ? DIRECT_SKYLIGHT_MAP : null), true);
                    continue;
                }
                long removedLightmapPosAbove = sectionPos;
                long pos = sectionPos;
                while (pos != sectionPosAbove) {
                    if (this.removedLightmaps.remove(pos)) {
                        removedLightmapPosAbove = pos;
                    }
                    pos = class_4076.method_18679((long)pos, (class_2350)class_2350.field_11036);
                }
                this.updateVanillaLightmapsBelow(removedLightmapPosAbove, this.vanillaLightmapComplexities.get(sectionPosAbove) == 0 ? null : this.method_15522(sectionPosAbove, true), false);
            }
            this.removedLightmaps.clear();
        }
        this.field_15819 = false;
    }

    private int fillSkylightColumn(class_3558<class_3569.class_3570, ?> lightProvider, long chunkPos) {
        int y;
        long sectionPos;
        int minY = 16;
        class_2804 lightmapAbove = null;
        while (this.method_15567(minY) && !this.field_15808.contains(sectionPos = class_4076.method_18685((int)class_4076.method_18686((long)chunkPos), (int)minY, (int)class_4076.method_18690((long)chunkPos)))) {
            class_2804 lightmap;
            if (this.method_15524(sectionPos)) {
                this.method_15536(lightProvider, sectionPos);
            }
            if ((lightmap = this.getLightmap(sectionPos)) != null) {
                lightmapAbove = lightmap;
            }
            --minY;
        }
        long sectionPosBelow = class_4076.method_18685((int)class_4076.method_18686((long)chunkPos), (int)minY, (int)class_4076.method_18690((long)chunkPos));
        if (this.method_15524(sectionPosBelow)) {
            int x;
            int z;
            class_2804 lightmapBelow = this.getLightmap(sectionPosBelow);
            if (lightmapBelow == null) {
                int complexity = 3840;
                if (lightmapAbove != null) {
                    for (z = 0; z < 16; ++z) {
                        for (x = 0; x < 16; ++x) {
                            complexity -= lightmapAbove.method_12139(x, 0, z);
                        }
                    }
                }
                this.getOrAddLightmap(sectionPosBelow);
                this.setLightmapComplexity(sectionPosBelow, complexity);
            } else {
                int amount = 0;
                for (z = 0; z < 16; ++z) {
                    for (x = 0; x < 16; ++x) {
                        amount += MixinSkyLightStorage.getComplexityChange(lightmapBelow.method_12139(x, 15, z), lightmapAbove == null ? 0 : lightmapAbove.method_12139(x, 0, z), 15);
                    }
                }
                this.changeLightmapComplexity(sectionPosBelow, amount);
            }
        }
        int sections = 0;
        for (y = 16; y > minY; --y) {
            long sectionPos2 = class_4076.method_18685((int)class_4076.method_18686((long)chunkPos), (int)y, (int)class_4076.method_18690((long)chunkPos));
            if (!this.removeLightmap(sectionPos2)) continue;
            sections |= 1 << y + 1;
        }
        ((class_3569.class_3570)this.field_15796).method_15505();
        for (y = 16; y > minY; --y) {
            if ((sections & 1 << y + 1) == 0) continue;
            this.method_15534(class_4076.method_18685((int)class_4076.method_18686((long)chunkPos), (int)y, (int)class_4076.method_18690((long)chunkPos)));
        }
        for (y = 16; y > minY; --y) {
            long sectionPos3 = class_4076.method_18685((int)class_4076.method_18686((long)chunkPos), (int)y, (int)class_4076.method_18690((long)chunkPos));
            if (!this.nonOptimizableSections.contains(sectionPos3)) continue;
            ((class_3569.class_3570)this.field_15796).method_15499(sectionPos3, this.createTrivialVanillaLightmap(DIRECT_SKYLIGHT_MAP));
            this.field_15802.add(sectionPos3);
        }
        ((class_3569.class_3570)this.field_15796).method_15505();
        return minY;
    }

    @Overwrite
    private void method_15569() {
        this.field_15819 = !this.initSkylightChunks.isEmpty();
    }

    @Unique
    private static class_2804 createDirectSkyLightMap() {
        class_2804 lightmap = new class_2804();
        Arrays.fill(lightmap.method_12137(), (byte)-1);
        return lightmap;
    }

    @Override
    public boolean method_15524(long sectionPos) {
        return super.method_15524(sectionPos) && this.method_15522(sectionPos, true) != null;
    }

    @Redirect(method={"createSection(J)Lnet/minecraft/world/chunk/ChunkNibbleArray;"}, slice=@Slice(from=@At(value="FIELD", target="Lnet/minecraft/world/chunk/light/SkyLightStorage;queuedSections:Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", opcode=180)), at=@At(value="INVOKE", target="Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;get(J)Ljava/lang/Object;", ordinal=0, remap=false))
    private Object cancelLightmapLookupFromQueue(Long2ObjectMap<class_2804> lightmapArray, long pos) {
        return null;
    }

    @Unique
    private static int getComplexityChange(int val, int oldNeighborVal, int newNeighborVal) {
        return Math.abs(newNeighborVal - val) - Math.abs(oldNeighborVal - val);
    }

    @Override
    protected void beforeLightChange(long blockPos, int oldVal, int newVal, class_2804 lightmap) {
        long sectionPos = class_4076.method_18691((long)blockPos);
        if (class_4076.method_18684((int)class_2338.method_10071((long)blockPos)) == 0) {
            this.vanillaLightmapComplexities.put(sectionPos, this.vanillaLightmapComplexities.get(sectionPos) + newVal - oldVal);
            long sectionPosBelow = this.getSectionBelow(sectionPos);
            if (sectionPosBelow != Long.MAX_VALUE) {
                class_2804 lightmapBelow = this.getOrAddLightmap(sectionPosBelow);
                int x = class_4076.method_18684((int)class_2338.method_10061((long)blockPos));
                int z = class_4076.method_18684((int)class_2338.method_10083((long)blockPos));
                this.changeLightmapComplexity(sectionPosBelow, MixinSkyLightStorage.getComplexityChange(lightmapBelow.method_12139(x, 15, z), oldVal, newVal));
            }
        }
        if (this.field_15802.add(sectionPos)) {
            ((class_3569.class_3570)this.field_15796).method_15502(sectionPos);
            this.updateVanillaLightmapsBelow(sectionPos, this.method_15522(sectionPos, true), false);
        }
    }

    @Shadow
    protected abstract boolean method_15567(int var1);

    @Unique
    private long getSectionBelow(long sectionPos) {
        int y = class_4076.method_18689((long)sectionPos);
        while (this.method_15567(y)) {
            if (this.method_15524(sectionPos = class_4076.method_18679((long)sectionPos, (class_2350)class_2350.field_11033))) {
                return sectionPos;
            }
            --y;
        }
        return Long.MAX_VALUE;
    }

    @Override
    protected int getLightmapComplexityChange(long blockPos, int oldVal, int newVal, class_2804 lightmap) {
        class_2804 lightmapAbove;
        long sectionPos = class_4076.method_18691((long)blockPos);
        int x = class_4076.method_18684((int)class_2338.method_10061((long)blockPos));
        int y = class_4076.method_18684((int)class_2338.method_10071((long)blockPos));
        int z = class_4076.method_18684((int)class_2338.method_10083((long)blockPos));
        int valAbove = y < 15 ? lightmap.method_12139(x, y + 1, z) : ((lightmapAbove = this.getLightmapAbove(sectionPos)) == null ? this.getDirectSkylight(sectionPos) : lightmapAbove.method_12139(x, 0, z));
        int amount = MixinSkyLightStorage.getComplexityChange(valAbove, oldVal, newVal);
        if (y > 0) {
            amount += MixinSkyLightStorage.getComplexityChange(lightmap.method_12139(x, y - 1, z), oldVal, newVal);
        }
        return amount;
    }

    @Unique
    private class_2804 getLightmapAbove(long sectionPos) {
        long sectionPosAbove = this.getSectionAbove(sectionPos);
        return sectionPosAbove == Long.MAX_VALUE ? null : this.method_15522(sectionPosAbove, true);
    }

    @Unique
    private long getSectionAbove(long sectionPos) {
        if (this.method_15568(sectionPos = class_4076.method_18679((long)sectionPos, (class_2350)class_2350.field_11036))) {
            return Long.MAX_VALUE;
        }
        while (!this.hasLightmap(sectionPos)) {
            sectionPos = class_4076.method_18679((long)sectionPos, (class_2350)class_2350.field_11036);
        }
        return sectionPos;
    }

    @Unique
    private int getDirectSkylight(long sectionPos) {
        return this.method_15566(sectionPos) ? 15 : 0;
    }

    @Override
    protected void beforeLightmapChange(long sectionPos, class_2804 oldLightmap, class_2804 newLightmap) {
        long sectionPosBelow = this.getSectionBelow(sectionPos);
        if (sectionPosBelow != Long.MAX_VALUE) {
            class_2804 lightmapBelow = this.method_15522(sectionPosBelow, true);
            class_2804 lightmapAbove = oldLightmap == null ? this.getLightmapAbove(sectionPos) : oldLightmap;
            int skyLight = this.getDirectSkylight(sectionPos);
            if (lightmapBelow == null) {
                int complexity = 0;
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        complexity += Math.abs(newLightmap.method_12139(x, 0, z) - (lightmapAbove == null ? skyLight : lightmapAbove.method_12139(x, 0, z)));
                    }
                }
                if (complexity != 0) {
                    this.getOrAddLightmap(sectionPosBelow);
                    this.setLightmapComplexity(sectionPosBelow, complexity);
                }
            } else {
                int amount = 0;
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        amount += MixinSkyLightStorage.getComplexityChange(lightmapBelow.method_12139(x, 15, z), lightmapAbove == null ? skyLight : lightmapAbove.method_12139(x, 0, z), newLightmap.method_12139(x, 0, z));
                    }
                }
                this.changeLightmapComplexity(sectionPosBelow, amount);
            }
        }
        this.updateVanillaLightmapsOnLightmapCreation(sectionPos, newLightmap);
    }

    @Override
    protected int getInitialLightmapComplexity(long sectionPos, class_2804 lightmap) {
        int complexity = 0;
        for (int y = 0; y < 15; ++y) {
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    complexity += Math.abs(lightmap.method_12139(x, y + 1, z) - lightmap.method_12139(x, y, z));
                }
            }
        }
        class_2804 lightmapAbove = this.getLightmapAbove(sectionPos);
        int skyLight = this.getDirectSkylight(sectionPos);
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                complexity += Math.abs((lightmapAbove == null ? skyLight : lightmapAbove.method_12139(x, 0, z)) - lightmap.method_12139(x, 15, z));
            }
        }
        return complexity;
    }

    @Redirect(method={"onUnloadSection(J)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/chunk/light/SkyLightStorage;hasSection(J)Z"))
    private boolean hasActualLightmap(class_3569 lightStorage, long sectionPos) {
        return this.hasLightmap(sectionPos);
    }

    @Override
    public void method_15485(long id, int level) {
        int oldLevel = this.method_15480(id);
        if (oldLevel >= 2 && level < 2) {
            ((SkyLightStorageDataAccess)this.field_15796).updateMinHeight(class_4076.method_18689((long)id));
        }
        super.method_15485(id, level);
    }

    @Override
    protected class_2804 createInitialVanillaLightmap(long sectionPos) {
        if (!this.field_15808.contains(sectionPos) && !this.field_15808.contains(class_4076.method_18679((long)sectionPos, (class_2350)class_2350.field_11036))) {
            return this.createTrivialVanillaLightmap(sectionPos);
        }
        long sectionPosAbove = this.getSectionAbove(sectionPos);
        int complexity = sectionPosAbove == Long.MAX_VALUE ? (this.method_15566(sectionPos) ? 3840 : 0) : this.vanillaLightmapComplexities.get(sectionPosAbove);
        if (complexity == 0) {
            return this.createTrivialVanillaLightmap(null);
        }
        class_2804 lightmap = new class_2804(new byte[2048]);
        ((class_3569.class_3570)this.field_15796).method_15499(sectionPos, lightmap);
        ((class_3569.class_3570)this.field_15796).method_15505();
        this.method_15523(sectionPos);
        this.setLightmapComplexity(sectionPos, complexity);
        return lightmap;
    }

    @Override
    protected class_2804 createTrivialVanillaLightmap(long sectionPos) {
        long sectionPosAbove = this.getSectionAbove(sectionPos);
        if (sectionPosAbove == Long.MAX_VALUE) {
            return this.createTrivialVanillaLightmap((class_2804)(this.method_15566(sectionPos) ? DIRECT_SKYLIGHT_MAP : null));
        }
        return this.createTrivialVanillaLightmap(this.vanillaLightmapComplexities.get(sectionPosAbove) == 0 ? null : this.method_15522(sectionPosAbove, true));
    }

    @Unique
    private class_2804 createTrivialVanillaLightmap(class_2804 lightmapAbove) {
        return lightmapAbove == null ? new EmptyChunkNibbleArray() : new SkyLightChunkNibbleArray(lightmapAbove);
    }

    @Inject(method={"onLoadSection(J)V"}, at={@At(value="HEAD")})
    private void updateVanillaLightmapsOnLightmapCreation(long sectionPos, CallbackInfo ci) {
        this.updateVanillaLightmapsOnLightmapCreation(sectionPos, this.method_15522(sectionPos, true));
    }

    @Unique
    private void updateVanillaLightmapsOnLightmapCreation(long sectionPos, class_2804 lightmap) {
        int complexity = 0;
        for (int z = 0; z < 16; ++z) {
            for (int x = 0; x < 16; ++x) {
                complexity += lightmap.method_12139(x, 0, z);
            }
        }
        this.vanillaLightmapComplexities.put(sectionPos, complexity);
        this.removedLightmaps.remove(sectionPos);
        if (!this.enabledChunks.contains(class_4076.method_18693((long)sectionPos))) {
            return;
        }
        this.updateVanillaLightmapsBelow(sectionPos, complexity == 0 ? null : lightmap, false);
    }

    @Inject(method={"onUnloadSection(J)V"}, at={@At(value="HEAD")})
    private void updateVanillaLightmapsOnLightmapRemoval(long sectionPos, CallbackInfo ci) {
        this.vanillaLightmapComplexities.remove(sectionPos);
        if (!this.enabledChunks.contains(class_4076.method_18693((long)sectionPos))) {
            return;
        }
        this.removedLightmaps.add(sectionPos);
    }

    @Unique
    private void updateVanillaLightmapsBelow(long sectionPos, class_2804 lightmapAbove, boolean stopOnRemovedLightmap) {
        int y = class_4076.method_18689((long)sectionPos) - 1;
        while (this.method_15567(y)) {
            class_2804 lightmapBelow;
            long sectionPosBelow = class_4076.method_18685((int)class_4076.method_18686((long)sectionPos), (int)y, (int)class_4076.method_18690((long)sectionPos));
            if (stopOnRemovedLightmap) {
                if (this.removedLightmaps.contains(sectionPosBelow)) {
                    break;
                }
            } else {
                this.removedLightmaps.remove(sectionPosBelow);
            }
            if ((lightmapBelow = this.method_15522(sectionPosBelow, true)) != null) {
                if (!((IReadonly)lightmapBelow).isReadonly()) break;
                ((class_3569.class_3570)this.field_15796).method_15499(sectionPosBelow, this.createTrivialVanillaLightmap(lightmapAbove));
                this.field_15802.add(sectionPosBelow);
            }
            --y;
        }
        ((class_3569.class_3570)this.field_15796).method_15505();
    }
}

