/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client;

import com.irtimaled.bbor.client.Player;
import com.irtimaled.bbor.client.interop.ClientInterop;
import com.irtimaled.bbor.client.models.BoundingBoxBeacon;
import com.irtimaled.bbor.client.models.BoundingBoxBedrockCeiling;
import com.irtimaled.bbor.client.models.BoundingBoxBiomeBorder;
import com.irtimaled.bbor.client.models.BoundingBoxConduit;
import com.irtimaled.bbor.client.models.BoundingBoxFlowerForest;
import com.irtimaled.bbor.client.models.BoundingBoxLine;
import com.irtimaled.bbor.client.models.BoundingBoxMobSpawner;
import com.irtimaled.bbor.client.models.BoundingBoxSlimeChunk;
import com.irtimaled.bbor.client.models.BoundingBoxSpawnableBlocks;
import com.irtimaled.bbor.client.models.BoundingBoxSpawningSphere;
import com.irtimaled.bbor.client.models.BoundingBoxSphere;
import com.irtimaled.bbor.client.models.BoundingBoxWorldSpawn;
import com.irtimaled.bbor.client.models.Point;
import com.irtimaled.bbor.client.providers.BeaconProvider;
import com.irtimaled.bbor.client.providers.BedrockCeilingProvider;
import com.irtimaled.bbor.client.providers.BiomeBorderProvider;
import com.irtimaled.bbor.client.providers.ConduitProvider;
import com.irtimaled.bbor.client.providers.CustomBeaconProvider;
import com.irtimaled.bbor.client.providers.CustomBoxProvider;
import com.irtimaled.bbor.client.providers.CustomLineProvider;
import com.irtimaled.bbor.client.providers.CustomSphereProvider;
import com.irtimaled.bbor.client.providers.FlowerForestProvider;
import com.irtimaled.bbor.client.providers.IBoundingBoxProvider;
import com.irtimaled.bbor.client.providers.ICachingProvider;
import com.irtimaled.bbor.client.providers.MobSpawnerProvider;
import com.irtimaled.bbor.client.providers.SlimeChunkProvider;
import com.irtimaled.bbor.client.providers.SpawnableBlocksProvider;
import com.irtimaled.bbor.client.providers.SpawningSphereProvider;
import com.irtimaled.bbor.client.providers.WorldSpawnProvider;
import com.irtimaled.bbor.client.renderers.AbstractRenderer;
import com.irtimaled.bbor.client.renderers.BeaconRenderer;
import com.irtimaled.bbor.client.renderers.BiomeBorderRenderer;
import com.irtimaled.bbor.client.renderers.ConduitRenderer;
import com.irtimaled.bbor.client.renderers.CuboidRenderer;
import com.irtimaled.bbor.client.renderers.FlowerForestRenderer;
import com.irtimaled.bbor.client.renderers.LineRenderer;
import com.irtimaled.bbor.client.renderers.MobSpawnerRenderer;
import com.irtimaled.bbor.client.renderers.RenderHelper;
import com.irtimaled.bbor.client.renderers.RenderQueue;
import com.irtimaled.bbor.client.renderers.SlimeChunkRenderer;
import com.irtimaled.bbor.client.renderers.SpawnableBlocksRenderer;
import com.irtimaled.bbor.client.renderers.SpawningSphereRenderer;
import com.irtimaled.bbor.client.renderers.SphereRenderer;
import com.irtimaled.bbor.client.renderers.WorldSpawnRenderer;
import com.irtimaled.bbor.common.MathHelper;
import com.irtimaled.bbor.common.TypeHelper;
import com.irtimaled.bbor.common.models.AbstractBoundingBox;
import com.irtimaled.bbor.common.models.BoundingBoxCuboid;
import com.irtimaled.bbor.common.models.DimensionId;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_4587;

public class ClientRenderer {
    private static final int CHUNK_SIZE = 16;
    private static final Map<Class<? extends AbstractBoundingBox>, AbstractRenderer> boundingBoxRendererMap = new HashMap<Class<? extends AbstractBoundingBox>, AbstractRenderer>();
    private static boolean active;
    private static final Set<IBoundingBoxProvider> providers;

    public static boolean getActive() {
        return active;
    }

    public static void toggleActive() {
        boolean bl = active = !active;
        if (!active) {
            return;
        }
        Player.setActiveY();
    }

    static void deactivate() {
        active = false;
    }

    public static <T extends AbstractBoundingBox> void registerProvider(IBoundingBoxProvider<T> provider) {
        providers.add(provider);
    }

    public static <T extends AbstractBoundingBox> void registerRenderer(Class<? extends T> type, AbstractRenderer<T> renderer) {
        boundingBoxRendererMap.put(type, renderer);
    }

    private static boolean isWithinRenderDistance(AbstractBoundingBox boundingBox) {
        int renderDistanceBlocks = ClientInterop.getRenderDistanceChunks() * 16;
        int minX = MathHelper.floor(Player.getX() - (double)renderDistanceBlocks);
        int maxX = MathHelper.floor(Player.getX() + (double)renderDistanceBlocks);
        int minZ = MathHelper.floor(Player.getZ() - (double)renderDistanceBlocks);
        int maxZ = MathHelper.floor(Player.getZ() + (double)renderDistanceBlocks);
        return boundingBox.intersectsBounds(minX, minZ, maxX, maxZ);
    }

    public static void render(class_4587 matrixStack, DimensionId dimensionId) {
        if (!active) {
            return;
        }
        RenderHelper.beforeRender();
        ClientRenderer.getBoundingBoxes(dimensionId).forEach(key -> {
            AbstractRenderer renderer = boundingBoxRendererMap.get(key.getClass());
            if (renderer != null) {
                renderer.render(matrixStack, key);
            }
        });
        RenderHelper.afterRender();
    }

    public static void renderDeferred() {
        RenderHelper.beforeRender();
        RenderHelper.polygonModeFill();
        RenderHelper.enableBlend();
        RenderQueue.renderDeferred();
        RenderHelper.disableBlend();
        RenderHelper.enablePolygonOffsetLine();
        RenderHelper.polygonOffsetMinusOne();
        RenderHelper.afterRender();
    }

    public static Stream<AbstractBoundingBox> getBoundingBoxes(DimensionId dimensionId) {
        Stream.Builder<AbstractBoundingBox> boundingBoxes = Stream.builder();
        for (IBoundingBoxProvider provider : providers) {
            if (!provider.canProvide(dimensionId)) continue;
            for (AbstractBoundingBox boundingBox2 : provider.get(dimensionId)) {
                if (!ClientRenderer.isWithinRenderDistance(boundingBox2)) continue;
                boundingBoxes.accept(boundingBox2);
            }
        }
        Point point = Player.getPoint();
        return boundingBoxes.build().sorted(Comparator.comparingDouble(boundingBox -> boundingBox.getDistance(point.getX(), point.getY(), point.getZ())).reversed());
    }

    public static void clear() {
        for (IBoundingBoxProvider provider : providers) {
            TypeHelper.doIfType(provider, ICachingProvider.class, ICachingProvider::clearCache);
        }
    }

    static {
        providers = new HashSet<IBoundingBoxProvider>();
        ClientRenderer.registerRenderer(BoundingBoxSlimeChunk.class, new SlimeChunkRenderer());
        ClientRenderer.registerRenderer(BoundingBoxWorldSpawn.class, new WorldSpawnRenderer());
        ClientRenderer.registerRenderer(BoundingBoxCuboid.class, new CuboidRenderer());
        ClientRenderer.registerRenderer(BoundingBoxMobSpawner.class, new MobSpawnerRenderer());
        ClientRenderer.registerRenderer(BoundingBoxSpawningSphere.class, new SpawningSphereRenderer());
        ClientRenderer.registerRenderer(BoundingBoxBeacon.class, new BeaconRenderer());
        ClientRenderer.registerRenderer(BoundingBoxBiomeBorder.class, new BiomeBorderRenderer());
        ClientRenderer.registerRenderer(BoundingBoxConduit.class, new ConduitRenderer());
        ClientRenderer.registerRenderer(BoundingBoxSpawnableBlocks.class, new SpawnableBlocksRenderer());
        ClientRenderer.registerRenderer(BoundingBoxLine.class, new LineRenderer());
        ClientRenderer.registerRenderer(BoundingBoxSphere.class, new SphereRenderer());
        ClientRenderer.registerRenderer(BoundingBoxFlowerForest.class, new FlowerForestRenderer());
        ClientRenderer.registerRenderer(BoundingBoxBedrockCeiling.class, new CuboidRenderer());
        ClientRenderer.registerProvider(new SlimeChunkProvider());
        ClientRenderer.registerProvider(new WorldSpawnProvider());
        ClientRenderer.registerProvider(new SpawningSphereProvider());
        ClientRenderer.registerProvider(new BeaconProvider());
        ClientRenderer.registerProvider(new CustomBoxProvider());
        ClientRenderer.registerProvider(new CustomBeaconProvider());
        ClientRenderer.registerProvider(new BiomeBorderProvider());
        ClientRenderer.registerProvider(new MobSpawnerProvider());
        ClientRenderer.registerProvider(new ConduitProvider());
        ClientRenderer.registerProvider(new SpawnableBlocksProvider());
        ClientRenderer.registerProvider(new CustomLineProvider());
        ClientRenderer.registerProvider(new CustomSphereProvider());
        ClientRenderer.registerProvider(new FlowerForestProvider());
        ClientRenderer.registerProvider(new BedrockCeilingProvider());
    }
}

