/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.commands;

import com.irtimaled.bbor.client.commands.Arguments;
import com.irtimaled.bbor.client.commands.CommandHelper;
import com.irtimaled.bbor.client.providers.CustomBoxProvider;
import com.irtimaled.bbor.common.models.Coords;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

class BoxCommandBuilder {
    BoxCommandBuilder() {
    }

    static LiteralArgumentBuilder<class_2168> build(String command) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)command).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"from", (ArgumentType)Arguments.coords()).then(class_2170.method_9244((String)"to", (ArgumentType)Arguments.coords()).executes(BoxCommandBuilder::addBox))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").executes(context -> {
            CustomBoxProvider.clear();
            CommandHelper.feedback((CommandContext<class_2168>)context, "bbor.commands.box.cleared.all", new Object[0]);
            return 0;
        })).then(class_2170.method_9244((String)"from", (ArgumentType)Arguments.coords()).then(class_2170.method_9244((String)"to", (ArgumentType)Arguments.coords()).executes(context -> {
            Coords maxCoords;
            Coords to;
            Coords from = Arguments.getCoords((CommandContext<class_2168>)context, "from");
            Coords minCoords = BoxCommandBuilder.getMinCoords(from, to = Arguments.getCoords((CommandContext<class_2168>)context, "to"));
            boolean removed = CustomBoxProvider.remove(minCoords, maxCoords = BoxCommandBuilder.getMaxCoords(from, to));
            String format = removed ? "bbor.commands.box.cleared" : "bbor.commands.box.notFound";
            CommandHelper.feedback((CommandContext<class_2168>)context, format, from.getX(), from.getY(), from.getZ(), to.getX(), to.getY(), to.getZ());
            return 0;
        }))));
    }

    private static int addBox(CommandContext<class_2168> context) throws CommandSyntaxException {
        Coords from = Arguments.getCoords(context, "from");
        Coords to = Arguments.getCoords(context, "to");
        Coords minCoords = BoxCommandBuilder.getMinCoords(from, to);
        Coords maxCoords = BoxCommandBuilder.getMaxCoords(from, to);
        CustomBoxProvider.add(minCoords, maxCoords);
        CommandHelper.feedback(context, "bbor.commands.box.added", from.getX(), from.getY(), from.getZ(), to.getX(), to.getY(), to.getZ());
        return 0;
    }

    private static Coords getMaxCoords(Coords from, Coords to) {
        return new Coords(Math.max(from.getX(), to.getX()), Math.max(from.getY(), to.getY()), Math.max(from.getZ(), to.getZ()));
    }

    private static Coords getMinCoords(Coords from, Coords to) {
        return new Coords(Math.min(from.getX(), to.getX()), Math.min(from.getY(), to.getY()), Math.min(from.getZ(), to.getZ()));
    }
}

