/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.commands;

import com.irtimaled.bbor.client.commands.Arguments;
import com.irtimaled.bbor.client.commands.CommandHelper;
import com.irtimaled.bbor.client.config.ConfigManager;
import com.irtimaled.bbor.client.config.HexColor;
import com.irtimaled.bbor.client.config.Setting;
import com.irtimaled.bbor.client.gui.SettingsScreen;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.function.Function;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;

public class ConfigCommand {
    private static final String COMMAND = "bbor:config";
    private static final String GET = "get";
    private static final String SAVE = "save";
    private static final String SHOW_GUI = "showGui";
    private static final String VALUE = "value";
    private static final String RESET = "reset";

    public static void register(CommandDispatcher<class_2172> commandDispatcher) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)COMMAND).then(ConfigCommand.buildCommands(GET, ConfigCommand::getCommandForSetting))).then(ConfigCommand.buildCommands("set", ConfigCommand::setCommandForSetting))).then(ConfigCommand.buildCommands(RESET, ConfigCommand::resetCommandForSetting).executes(context1 -> {
            ConfigManager.getSettings().forEach(Setting::reset);
            ConfigManager.saveConfig();
            return 0;
        }))).then(class_2170.method_9247((String)SAVE).executes(context -> {
            ConfigManager.saveConfig();
            return 0;
        }))).then(class_2170.method_9247((String)SHOW_GUI).executes(context -> {
            SettingsScreen.show();
            return 0;
        }));
        commandDispatcher.register(command);
    }

    private static LiteralArgumentBuilder<class_2168> resetCommandForSetting(Setting<?> setting) {
        return (LiteralArgumentBuilder)class_2170.method_9247((String)setting.getName()).executes(context -> {
            setting.reset();
            ConfigManager.saveConfig();
            return 0;
        });
    }

    private static LiteralArgumentBuilder<class_2168> buildCommands(String commandName, CommandBuilder commandBuilder) {
        LiteralArgumentBuilder command = class_2170.method_9247((String)commandName);
        for (Setting<?> setting : ConfigManager.getSettings()) {
            command.then((ArgumentBuilder)commandBuilder.apply(setting));
        }
        return command;
    }

    private static LiteralArgumentBuilder<class_2168> getCommandForSetting(Setting<?> setting) {
        return (LiteralArgumentBuilder)class_2170.method_9247((String)setting.getName()).executes(context -> {
            CommandHelper.feedback((CommandContext<class_2168>)context, "%s: %s", setting.getName(), setting.get());
            return 0;
        });
    }

    private static LiteralArgumentBuilder<class_2168> setCommandForSetting(Setting<?> setting) {
        LiteralArgumentBuilder command = class_2170.method_9247((String)setting.getName());
        switch (setting.getType()) {
            case 'B': {
                ConfigCommand.buildSetSettingCommand((LiteralArgumentBuilder<class_2168>)command, setting, Arguments.bool(), Boolean.class);
                break;
            }
            case 'I': {
                ConfigCommand.buildSetSettingCommand((LiteralArgumentBuilder<class_2168>)command, setting, Arguments.integer(), Integer.class);
                break;
            }
            case 'S': {
                ConfigCommand.buildSetSettingCommand((LiteralArgumentBuilder<class_2168>)command, setting, Arguments.string(), String.class);
                break;
            }
            case 'H': {
                ConfigCommand.buildSetSettingCommand((LiteralArgumentBuilder<class_2168>)command, setting, Arguments.hexColor(), HexColor.class);
            }
        }
        return command;
    }

    private static <T> void buildSetSettingCommand(LiteralArgumentBuilder<class_2168> command, Setting<T> setting, ArgumentType<T> argument, Class<T> clazz) {
        Command setSettingCommand = context -> {
            setting.set(context.getArgument(VALUE, clazz));
            if (CommandHelper.lastNodeIsLiteral((CommandContext<class_2168>)context, SAVE)) {
                ConfigManager.saveConfig();
            }
            return 0;
        };
        command.then(((RequiredArgumentBuilder)class_2170.method_9244((String)VALUE, argument).executes(setSettingCommand)).then(class_2170.method_9247((String)SAVE).executes(setSettingCommand)));
    }

    private static interface CommandBuilder
    extends Function<Setting<?>, LiteralArgumentBuilder<class_2168>> {
    }
}

