/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.config;

import com.irtimaled.bbor.client.config.ColorHelper;
import com.irtimaled.bbor.client.config.ConfigManager;
import com.irtimaled.bbor.client.config.HexColor;
import com.irtimaled.bbor.client.config.Setting;
import com.irtimaled.bbor.common.BoundingBoxType;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class BoundingBoxTypeHelper {
    private static final Map<String, BoundingBoxTypeSettings> structureTypeMap = new HashMap<String, BoundingBoxTypeSettings>();

    private static void registerType(BoundingBoxType type, Setting<Boolean> shouldRender, Setting<HexColor> color) {
        structureTypeMap.put(type.getName(), new BoundingBoxTypeSettings(shouldRender, color));
    }

    public static Setting<Boolean> renderSetting(BoundingBoxType type) {
        return structureTypeMap.get(type.getName()).shouldRender;
    }

    public static boolean shouldRender(BoundingBoxType type) {
        BoundingBoxTypeSettings settings = structureTypeMap.get(type.getName());
        return settings != null ? (Boolean)settings.shouldRender.get() : false;
    }

    public static Color getColor(BoundingBoxType type) {
        BoundingBoxTypeSettings settings = structureTypeMap.get(type.getName());
        return settings != null ? ColorHelper.getColor(settings.color) : Color.WHITE;
    }

    static {
        BoundingBoxTypeHelper.registerType(BoundingBoxType.WorldSpawn, ConfigManager.drawWorldSpawn, ConfigManager.colorWorldSpawn);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.SpawnChunks, ConfigManager.drawWorldSpawn, ConfigManager.colorWorldSpawn);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.LazySpawnChunks, ConfigManager.drawLazySpawnChunks, ConfigManager.colorLazySpawnChunks);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.MobSpawner, ConfigManager.drawMobSpawners, ConfigManager.colorMobSpawners);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.SlimeChunks, ConfigManager.drawSlimeChunks, ConfigManager.colorSlimeChunks);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.AFKSphere, ConfigManager.drawAFKSpheres, ConfigManager.colorAFKSpheres);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.BiomeBorder, ConfigManager.drawBiomeBorders, ConfigManager.colorBiomeBorders);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.Beacon, ConfigManager.drawBeacons, ConfigManager.colorBeacons);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.Custom, ConfigManager.drawConduits, ConfigManager.colorCustom);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.Conduit, ConfigManager.drawConduits, ConfigManager.colorConduits);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.SpawnableBlocks, ConfigManager.drawSpawnableBlocks, ConfigManager.colorSpawnableBlocks);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.FlowerForest, ConfigManager.drawFlowerForests, null);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.BedrockCeiling, ConfigManager.drawBedrockCeilingBlocks, ConfigManager.colorBedrockCeilingBlocks);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.JungleTemple, ConfigManager.drawJungleTemples, ConfigManager.colorJungleTemples);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.DesertTemple, ConfigManager.drawDesertTemples, ConfigManager.colorDesertTemples);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.WitchHut, ConfigManager.drawWitchHuts, ConfigManager.colorWitchHuts);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.OceanMonument, ConfigManager.drawOceanMonuments, ConfigManager.colorOceanMonuments);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.Shipwreck, ConfigManager.drawShipwrecks, ConfigManager.colorShipwrecks);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.OceanRuin, ConfigManager.drawOceanRuins, ConfigManager.colorOceanRuins);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.BuriedTreasure, ConfigManager.drawBuriedTreasure, ConfigManager.colorBuriedTreasure);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.Stronghold, ConfigManager.drawStrongholds, ConfigManager.colorStrongholds);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.MineShaft, ConfigManager.drawMineShafts, ConfigManager.colorMineShafts);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.NetherFortress, ConfigManager.drawNetherFortresses, ConfigManager.colorNetherFortresses);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.EndCity, ConfigManager.drawEndCities, ConfigManager.colorEndCities);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.Mansion, ConfigManager.drawMansions, ConfigManager.colorMansions);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.Igloo, ConfigManager.drawIgloos, ConfigManager.colorIgloos);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.PillagerOutpost, ConfigManager.drawPillagerOutposts, ConfigManager.colorPillagerOutposts);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.Village, ConfigManager.drawVillages, ConfigManager.colorVillages);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.NetherFossil, ConfigManager.drawNetherFossils, ConfigManager.colorNetherFossils);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.BastionRemnant, ConfigManager.drawBastionRemnants, ConfigManager.colorBastionRemnants);
        BoundingBoxTypeHelper.registerType(BoundingBoxType.RuinedPortal, ConfigManager.drawRuinedPortals, ConfigManager.colorRuinedPortals);
    }

    private static class BoundingBoxTypeSettings {
        private final Setting<Boolean> shouldRender;
        private final Setting<HexColor> color;

        public BoundingBoxTypeSettings(Setting<Boolean> shouldRender, Setting<HexColor> color) {
            this.shouldRender = shouldRender;
            this.color = color;
        }
    }
}

