/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.config;

public class HexColor {
    private final String value;
    private final boolean hasAlpha;

    private HexColor(String value, boolean hasAlpha) {
        this.value = value;
        this.hasAlpha = hasAlpha;
    }

    public static HexColor from(String value) {
        String lowerValue = value.toLowerCase();
        if (lowerValue.length() == 7 && lowerValue.matches("#[0-9a-f]{6}")) {
            return new HexColor(lowerValue, false);
        }
        if (lowerValue.length() == 9 && lowerValue.matches("#[0-9a-f]{8}")) {
            return new HexColor(lowerValue, true);
        }
        return null;
    }

    public String getValue() {
        return this.value;
    }

    public boolean hasAlpha() {
        return this.hasAlpha;
    }

    public String toString() {
        return this.getValue();
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HexColor hexColor = (HexColor)obj;
        return this.value.equals(hexColor.value);
    }
}

