/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.gui;

import com.irtimaled.bbor.client.gui.ControlListEntry;
import com.irtimaled.bbor.client.gui.ControlListSection;
import com.irtimaled.bbor.client.gui.CreateControl;
import com.irtimaled.bbor.client.gui.IControl;
import com.irtimaled.bbor.client.gui.IControlSet;
import com.irtimaled.bbor.client.renderers.RenderHelper;
import com.irtimaled.bbor.client.renderers.Renderer;
import com.irtimaled.bbor.common.MathHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class ControlList
extends class_332
implements IControlSet {
    public static final int CONTROLS_WIDTH = 310;
    protected static final int PADDING = 8;
    protected final int listLeft;
    protected final List<ControlListEntry> entries = new ArrayList<ControlListEntry>();
    private final int scrollBarLeft;
    private final int listHeight;
    private final class_310 minecraft = class_310.method_1551();
    private final int width;
    private final int height;
    private final int top;
    private final int bottom;
    protected int contentHeight = 8;
    private double amountScrolled;
    private boolean clickedScrollbar;
    private boolean transparentBackground;
    private IControl focused;
    private boolean isDragging;

    ControlList(int width, int height, int top, int bottom) {
        this.width = width;
        this.scrollBarLeft = width - 6;
        this.height = height;
        this.top = top;
        this.bottom = bottom;
        this.listHeight = bottom - top;
        this.listLeft = width / 2 - 155;
    }

    void add(ControlListEntry entry) {
        entry.index = this.entries.size();
        this.addEntry(entry);
    }

    private void addEntry(ControlListEntry entry) {
        this.entries.add(entry);
        this.contentHeight += entry.getControlHeight();
    }

    public void filter(String lowerValue) {
        int height = 0;
        for (ControlListEntry entry : this.entries) {
            entry.filter(lowerValue);
            if (entry.method_1885()) {
                height += entry.getControlHeight();
                continue;
            }
            if (entry != this.focused) continue;
            this.focused = null;
        }
        this.contentHeight = height + 8;
    }

    void close() {
        this.entries.forEach(ControlListEntry::close);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.clickedScrollbar = button == 0 && mouseX >= (double)this.scrollBarLeft;
        return this.method_25405(mouseX, mouseY) && (IControlSet.super.method_25402(mouseX, mouseY, button) || this.clickedScrollbar);
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseY >= (double)this.top && mouseY <= (double)this.bottom;
    }

    @Override
    public boolean method_25407(boolean moveForward) {
        boolean newControlFocused = IControlSet.super.method_25407(moveForward);
        if (newControlFocused) {
            this.ensureVisible((ControlListEntry)this.getFocused());
        }
        return newControlFocused;
    }

    private void ensureVisible(ControlListEntry control) {
        int controlTop = control.getControlTop();
        int controlHeight = control.getControlHeight();
        int distanceAboveTop = this.top - controlTop;
        if (distanceAboveTop > 0) {
            this.amountScrolled -= (double)Math.max(controlHeight, distanceAboveTop + 8);
            return;
        }
        int distanceBelowBottom = controlTop + controlHeight - this.bottom;
        if (distanceBelowBottom > 0) {
            this.amountScrolled += (double)Math.max(controlHeight, distanceBelowBottom + 8);
        }
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        if (IControlSet.super.method_25403(mouseX, mouseY, button, p_mouseDragged_6_, p_mouseDragged_8_)) {
            return true;
        }
        if (button == 0 && this.clickedScrollbar) {
            if (mouseY < (double)this.top) {
                this.amountScrolled = 0.0;
            } else if (mouseY > (double)this.bottom) {
                this.amountScrolled = this.getMaxScroll();
            } else {
                double amountScrolled;
                double maxScroll = this.getMaxScroll();
                if (maxScroll < 1.0) {
                    maxScroll = 1.0;
                }
                if ((amountScrolled = maxScroll / (double)(this.listHeight - this.getScrollBarHeight())) < 1.0) {
                    amountScrolled = 1.0;
                }
                this.amountScrolled += p_mouseDragged_8_ * amountScrolled;
            }
            return true;
        }
        return false;
    }

    private int getMaxScroll() {
        return Math.max(0, this.contentHeight - (this.listHeight - 4));
    }

    private int getScrollBarHeight() {
        return MathHelper.clamp((int)((float)(this.listHeight * this.listHeight) / (float)this.contentHeight), 32, this.listHeight - 8);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scrollAmount) {
        this.amountScrolled -= scrollAmount * 10.0;
        return true;
    }

    public void render(class_4587 matrixStack, int mouseX, int mouseY) {
        this.amountScrolled = MathHelper.clamp(this.amountScrolled, 0.0, (double)this.getMaxScroll());
        RenderHelper.disableLighting();
        RenderHelper.disableFog();
        if (!this.transparentBackground) {
            this.drawListBackground();
        }
        int listTop = this.top + 8 - (int)this.amountScrolled;
        this.drawEntries(matrixStack, mouseX, mouseY, listTop);
        RenderHelper.enableDepthTest();
        RenderHelper.depthFuncAlways();
        this.overlayBackground(0, this.top);
        this.overlayBackground(this.bottom, this.height);
        RenderHelper.depthFuncLessEqual();
        RenderHelper.disableDepthTest();
        RenderHelper.enableBlend();
        RenderHelper.blendFuncGui();
        RenderHelper.disableAlphaTest();
        RenderHelper.shadeModelSmooth();
        RenderHelper.disableTexture();
        this.drawOverlayShadows();
        int maxScroll = this.getMaxScroll();
        if (maxScroll > 0) {
            this.drawScrollBar(maxScroll);
        }
        RenderHelper.enableTexture();
        RenderHelper.shadeModelFlat();
        RenderHelper.enableAlphaTest();
        RenderHelper.disableBlend();
    }

    private void drawListBackground() {
        this.minecraft.method_1531().method_22813(class_332.field_22735);
        Renderer.startTextured().setColor(32, 32, 32).setAlpha(255).addPoint(0.0, this.bottom, 0.0, 0.0, (float)(this.bottom + (int)this.amountScrolled) / 32.0f).addPoint(this.width, this.bottom, 0.0, (float)this.width / 32.0f, (float)(this.bottom + (int)this.amountScrolled) / 32.0f).addPoint(this.width, this.top, 0.0, (float)this.width / 32.0f, (float)(this.top + (int)this.amountScrolled) / 32.0f).addPoint(0.0, this.top, 0.0, 0.0, (float)(this.top + (int)this.amountScrolled) / 32.0f).render();
    }

    private void drawEntries(class_4587 matrixStack, int mouseX, int mouseY, int top) {
        for (ControlListEntry entry : this.entries) {
            if (!entry.method_1885()) continue;
            entry.setX(this.listLeft);
            entry.setY(top);
            int height = entry.getControlHeight();
            int bottom = top + height;
            if (top <= this.bottom && bottom >= this.top) {
                this.drawEntry(matrixStack, mouseX, mouseY, top, entry, height);
            }
            top = bottom;
        }
    }

    protected void drawEntry(class_4587 matrixStack, int mouseX, int mouseY, int top, ControlListEntry entry, int height) {
        entry.render(matrixStack, mouseX, mouseY);
    }

    private void overlayBackground(int top, int bottom) {
        this.minecraft.method_1531().method_22813(class_332.field_22735);
        Renderer.startTextured().setColor(64, 64, 64).setAlpha(255).addPoint(0.0, bottom, -100.0, 0.0, (float)bottom / 32.0f).addPoint(this.width, bottom, -100.0, (float)this.width / 32.0f, (float)bottom / 32.0f).addPoint(this.width, top, -100.0, (float)this.width / 32.0f, (float)top / 32.0f).addPoint(0.0, top, -100.0, 0.0, (float)top / 32.0f).render();
    }

    private void drawScrollBar(int maxScroll) {
        int scrollBarHeight = this.getScrollBarHeight();
        int scrollBarTop = (int)this.amountScrolled * (this.listHeight - scrollBarHeight) / maxScroll + this.top;
        if (scrollBarTop < this.top) {
            scrollBarTop = this.top;
        }
        Renderer.startTextured().setAlpha(255).addPoint(this.scrollBarLeft, this.bottom, 0.0, 0.0, 1.0).addPoint(this.width, this.bottom, 0.0, 1.0, 1.0).addPoint(this.width, this.top, 0.0, 1.0, 0.0).addPoint(this.scrollBarLeft, this.top, 0.0, 0.0, 0.0).render();
        Renderer.startTextured().setColor(128, 128, 128).setAlpha(255).addPoint(this.scrollBarLeft, scrollBarTop + scrollBarHeight, 0.0, 0.0, 1.0).addPoint(this.width, scrollBarTop + scrollBarHeight, 0.0, 1.0, 1.0).addPoint(this.width, scrollBarTop, 0.0, 1.0, 0.0).addPoint(this.scrollBarLeft, scrollBarTop, 0.0, 0.0, 0.0).render();
        Renderer.startTextured().setColor(192, 192, 192).setAlpha(255).addPoint(this.scrollBarLeft, scrollBarTop + scrollBarHeight - 1, 0.0, 0.0, 1.0).addPoint(this.width - 1, scrollBarTop + scrollBarHeight - 1, 0.0, 1.0, 1.0).addPoint(this.width - 1, scrollBarTop, 0.0, 1.0, 0.0).addPoint(this.scrollBarLeft, scrollBarTop, 0.0, 0.0, 0.0).render();
    }

    private void drawOverlayShadows() {
        Renderer.startTextured().addPoint(0.0, this.top + 4, 0.0, 0.0, 1.0).addPoint(this.width, this.top + 4, 0.0, 1.0, 1.0).setAlpha(255).addPoint(this.width, this.top, 0.0, 1.0, 0.0).addPoint(0.0, this.top, 0.0, 0.0, 0.0).render();
        Renderer.startTextured().addPoint(this.width, this.bottom - 4, 0.0, 1.0, 0.0).addPoint(0.0, this.bottom - 4, 0.0, 0.0, 0.0).setAlpha(255).addPoint(0.0, this.bottom, 0.0, 0.0, 1.0).addPoint(this.width, this.bottom, 0.0, 1.0, 1.0).render();
    }

    ControlList section(String title, CreateControl ... createControls) {
        this.add(new ControlListSection(title, createControls));
        return this;
    }

    void setTransparentBackground() {
        this.transparentBackground = true;
    }

    @Override
    public List<? extends IControl> controls() {
        return this.entries;
    }

    @Override
    public IControl getFocused() {
        return this.focused;
    }

    @Override
    public void setFocused(IControl control) {
        this.focused = control;
    }

    @Override
    public boolean isDragging() {
        return this.isDragging;
    }

    @Override
    public void setDragging(boolean dragging) {
        this.isDragging = dragging;
    }
}

