/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.gui;

import com.irtimaled.bbor.client.gui.AbstractControl;
import com.irtimaled.bbor.client.gui.ControlListEntry;
import com.irtimaled.bbor.client.gui.CreateControl;
import com.irtimaled.bbor.client.gui.IControl;
import com.irtimaled.bbor.client.gui.IControlSet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;

public class ControlListSection
extends ControlListEntry
implements IControlSet {
    private static final int TITLE_HEIGHT = 16;
    private final String title;
    private final List<AbstractControl> controls = new ArrayList<AbstractControl>();
    private final class_310 minecraft = class_310.method_1551();
    private final int titleHeight;
    private int height;
    private IControl focused;
    private boolean dragging;

    ControlListSection(String title, CreateControl ... createControls) {
        this.title = title;
        this.height = this.titleHeight = title != null ? 16 : 0;
        int columnCount = this.columnCount();
        int controlWidth = (310 - (columnCount - 1) * 4) / columnCount;
        int column = 0;
        for (CreateControl createControl : createControls) {
            AbstractControl control = createControl.create(controlWidth);
            if (control == null) continue;
            this.controls.add(control);
            if (column == 0) {
                this.height += control.getControlHeight();
            }
            column = (column + 1) % columnCount;
        }
    }

    private int columnCount() {
        switch (this.minecraft.method_1526().method_4669().getCode()) {
            case "en_au": 
            case "en_us": 
            case "en_gb": {
                return 3;
            }
        }
        return 2;
    }

    @Override
    public void render(class_4587 matrixStack, int mouseX, int mouseY) {
        int y;
        int x = this.getX();
        int top = y = this.getY();
        if (this.title != null) {
            class_327 class_3272 = this.minecraft.field_1772;
            float f = x + 4;
            float f2 = y;
            this.minecraft.field_1772.getClass();
            class_3272.method_1729(matrixStack, this.title, f, f2 + (float)(16 - 9) / 1.5f, 0xFFFFFF);
            top += this.titleHeight;
        }
        int left = 0;
        int height = 0;
        for (AbstractControl control : this.controls) {
            if (!control.method_1885()) continue;
            control.setX(left + x);
            control.setY(top);
            control.render(matrixStack, mouseX, mouseY);
            if (left == 0) {
                height = control.getControlHeight();
            }
            if ((left += control.getControlWidth()) < 310) continue;
            left = 0;
            top += height;
        }
    }

    @Override
    public void clearFocus() {
        IControlSet.super.clearFocus();
    }

    @Override
    public int getControlHeight() {
        return this.height;
    }

    public int getControlWidth() {
        return 310;
    }

    @Override
    public void filter(String lowerValue) {
        if (this.matchesTitle(lowerValue)) {
            lowerValue = "";
        }
        int height = 0;
        int left = 0;
        for (AbstractControl entry : this.controls) {
            entry.filter(lowerValue);
            if (entry.method_1885()) {
                if (left == 0) {
                    height += entry.getControlHeight();
                }
                if ((left += entry.getControlWidth()) < this.getControlWidth()) continue;
                left = 0;
                continue;
            }
            if (entry != this.focused) continue;
            entry.clearFocus();
            this.focused = null;
        }
        this.height = height + this.titleHeight;
        this.setVisible(height > 0);
    }

    private boolean matchesTitle(String lowerValue) {
        if (this.title == null) {
            return false;
        }
        String lowerString = this.title.toLowerCase();
        return lowerString.startsWith(lowerValue) || lowerString.contains(" " + lowerValue);
    }

    @Override
    public List<? extends IControl> controls() {
        return this.controls;
    }

    @Override
    public IControl getFocused() {
        return this.focused;
    }

    @Override
    public void setFocused(IControl focused) {
        this.focused = focused;
    }

    @Override
    public boolean isDragging() {
        return this.dragging;
    }

    @Override
    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }
}

