/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.interop;

import com.irtimaled.bbor.common.EventBus;
import com.irtimaled.bbor.common.ReflectionHelper;
import com.irtimaled.bbor.common.events.StructuresLoaded;
import com.irtimaled.bbor.common.models.DimensionId;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_26;
import net.minecraft.class_2794;
import net.minecraft.class_2867;
import net.minecraft.class_2874;
import net.minecraft.class_3037;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_3341;
import net.minecraft.class_3360;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_3485;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5455;

class NBTStructureLoader {
    private final DimensionId dimensionId;
    private final Set<String> loadedChunks = new HashSet<String>();
    private class_3360 legacyStructureDataUtil = null;
    private class_32.class_5143 saveHandler = null;
    private File chunkSaveLocation = null;
    private ChunkLoader chunkLoader;

    NBTStructureLoader(DimensionId dimensionId, class_32.class_5143 saveHandler, File worldDirectory) {
        this.dimensionId = dimensionId;
        this.configure(saveHandler, worldDirectory);
    }

    void clear() {
        this.legacyStructureDataUtil = null;
        this.chunkSaveLocation = null;
        this.loadedChunks.clear();
        this.close(new AutoCloseable[]{this.saveHandler, this.chunkLoader});
        this.saveHandler = null;
        this.chunkLoader = null;
    }

    private void close(AutoCloseable ... closeables) {
        for (AutoCloseable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    void configure(class_32.class_5143 saveHandler, File worldDirectory) {
        this.saveHandler = saveHandler;
        if (worldDirectory != null) {
            this.chunkSaveLocation = new File(class_2874.method_12488(this.dimensionId.getDimensionType(), (File)worldDirectory), "region");
            this.chunkLoader = new ChunkLoader(this.chunkSaveLocation);
        }
    }

    private class_3360 getLegacyStructureDataUtil() {
        if (this.legacyStructureDataUtil == null) {
            File dataFolder = new File(this.saveHandler.method_27424(class_1937.field_25179), "data");
            this.legacyStructureDataUtil = class_3360.method_14745(this.dimensionId.getDimensionType(), (class_26)new class_26(dataFolder, class_310.method_1551().method_1543()));
        }
        return this.legacyStructureDataUtil;
    }

    private class_2487 loadStructureStarts(int chunkX, int chunkZ) {
        try {
            int dataVersion;
            class_2487 compound = this.chunkLoader.readChunk(chunkX, chunkZ);
            if (compound == null) {
                return null;
            }
            int n = dataVersion = compound.method_10573("DataVersion", 99) ? compound.method_10550("DataVersion") : -1;
            if (dataVersion < 1493 && compound.method_10562("Level").method_10577("hasLegacyStructureData")) {
                compound = this.getLegacyStructureDataUtil().method_14735(compound);
            }
            return compound.method_10562("Level").method_10562("Structures").method_10562("Starts");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    void loadStructures(int chunkX, int chunkZ) {
        if (this.saveHandler == null) {
            return;
        }
        if (!this.loadedChunks.add(String.format("%s,%s", chunkX, chunkZ))) {
            return;
        }
        class_2487 structureStarts = this.loadStructureStarts(chunkX, chunkZ);
        if (structureStarts == null || structureStarts.method_10546() == 0) {
            return;
        }
        HashMap structureStartMap = new HashMap();
        for (String key : structureStarts.method_10541()) {
            class_2487 compound = structureStarts.method_10562(key);
            if (!compound.method_10545("BB")) continue;
            structureStartMap.put(key, new SimpleStructureStart(compound));
        }
        EventBus.publish(new StructuresLoaded(structureStartMap, this.dimensionId));
    }

    private static class ChunkLoader
    implements AutoCloseable {
        private static final BiFunction<File, Boolean, class_2867> creator = ReflectionHelper.getPrivateInstanceBuilder(class_2867.class, File.class, Boolean.TYPE);
        private final class_2867 regionFileCache;

        public ChunkLoader(File file) {
            this.regionFileCache = creator.apply(file, false);
        }

        public class_2487 readChunk(int chunkX, int chunkZ) throws IOException {
            if (this.regionFileCache == null) {
                return null;
            }
            return this.regionFileCache.method_17911(new class_1923(chunkX, chunkZ));
        }

        @Override
        public void close() throws IOException {
            if (this.regionFileCache == null) {
                return;
            }
            this.regionFileCache.close();
        }
    }

    private static class SimpleStructurePiece
    extends class_3443 {
        SimpleStructurePiece(class_2487 compound) {
            super(null, compound);
        }

        protected void method_14943(class_2487 compoundTag) {
        }

        public boolean method_14931(class_5281 structureWorldAccess, class_5138 structureAccessor, class_2794 chunkGenerator, Random random, class_3341 blockBox, class_1923 chunkPos, class_2338 blockPos) {
            return false;
        }
    }

    private static class SimpleStructureStart
    extends class_3449<class_3037> {
        SimpleStructureStart(class_2487 compound) {
            super(null, 0, 0, new class_3341(compound.method_10561("BB")), 0, 0L);
            class_2499 children = compound.method_10554("Children", 10);
            for (int index = 0; index < children.size(); ++index) {
                class_2487 child = children.method_10602(index);
                if (!child.method_10545("BB")) continue;
                this.field_15325.add(new SimpleStructurePiece(child));
            }
        }

        public void method_16655(class_5455 dynamicRegistryManager, class_2794 chunkGenerator, class_3485 structureManager, int i, int j, class_1959 biome, class_3037 featureConfig) {
        }
    }
}

