/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.interop;

import com.irtimaled.bbor.client.interop.BlockProcessor;
import com.irtimaled.bbor.common.models.Coords;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_638;

public class SpawnableBlocksHelper {
    private static final class_1299 entityType = class_1299.class_1300.method_5902((class_1311)class_1311.field_6302).method_17687(0.0f, 0.0f).method_5904().method_5905(null);

    public static void findSpawnableBlocks(Coords coords, int width, int height, BlockProcessor blockProcessor) {
        int blockX = coords.getX();
        int minX = blockX - width;
        int maxX = blockX + width + 1;
        int blockZ = coords.getZ();
        int minZ = blockZ - width;
        int maxZ = blockZ + width + 1;
        int blockY = coords.getY();
        int minY = Math.max(1, blockY - height);
        int maxY = Math.min(255, blockY + height);
        class_638 world = class_310.method_1551().field_1687;
        for (int x = minX; x < maxX; ++x) {
            for (int z = minZ; z < maxZ; ++z) {
                class_2680 upperBlockState = world.method_8320(new class_2338(x, minY - 1, z));
                for (int y = Math.max(1, minY); y < maxY; ++y) {
                    class_2338 pos = new class_2338(x, y, z);
                    class_2680 spawnBlockState = upperBlockState;
                    if (!SpawnableBlocksHelper.isSpawnable((class_1937)world, pos, spawnBlockState, upperBlockState = world.method_8320(pos))) continue;
                    blockProcessor.process(pos);
                }
            }
        }
    }

    static boolean isSpawnable(class_1937 world, class_2338 pos, class_2680 spawnBlockState, class_2680 upperBlockState) {
        boolean isNether;
        class_265 collisionShape = upperBlockState.method_26220((class_1922)world, pos);
        class_1959 biome = world.method_23753(pos);
        boolean bl = isNether = biome.method_8688() == class_1959.class_1961.field_9366;
        return biome.method_8688() != class_1959.class_1961.field_9365 && spawnBlockState.method_26170((class_1922)world, pos.method_10074(), isNether ? class_1299.field_6050 : entityType) && !class_2248.method_9501((class_265)collisionShape, (class_2350)class_2350.field_11036) && !upperBlockState.method_26219() && !upperBlockState.method_26164((class_3494)class_3481.field_15463) && collisionShape.method_1105(class_2350.class_2351.field_11052) <= 0.0 && upperBlockState.method_26227().method_15769() && (isNether || world.method_8314(class_1944.field_9282, pos) <= 7);
    }
}

