/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.models;

import com.irtimaled.bbor.common.BoundingBoxType;
import com.irtimaled.bbor.common.models.AbstractBoundingBox;
import com.irtimaled.bbor.common.models.Coords;

public class BoundingBoxBiomeBorder
extends AbstractBoundingBox {
    private final Coords coords;
    private final boolean north;
    private final boolean east;
    private final boolean south;
    private final boolean west;

    public BoundingBoxBiomeBorder(Coords coords, boolean north, boolean east, boolean south, boolean west) {
        super(BoundingBoxType.BiomeBorder);
        this.coords = coords;
        this.north = north;
        this.east = east;
        this.south = south;
        this.west = west;
    }

    @Override
    public Boolean intersectsBounds(int minX, int minZ, int maxX, int maxZ) {
        return this.coords.getX() >= minX && this.coords.getZ() >= minZ && this.coords.getX() <= maxX && this.coords.getZ() <= maxZ;
    }

    @Override
    protected double getDistanceX(double x) {
        return x - (double)this.coords.getX();
    }

    @Override
    protected double getDistanceY(double y) {
        return y - (double)this.coords.getY();
    }

    @Override
    protected double getDistanceZ(double z) {
        return z - (double)this.coords.getZ();
    }

    public Coords getCoords() {
        return this.coords;
    }

    public boolean renderNorth() {
        return this.north;
    }

    public boolean renderEast() {
        return this.east;
    }

    public boolean renderSouth() {
        return this.south;
    }

    public boolean renderWest() {
        return this.west;
    }
}

