/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.models;

import com.irtimaled.bbor.client.models.BoundingBoxSphere;
import com.irtimaled.bbor.client.models.Point;
import com.irtimaled.bbor.common.BoundingBoxType;
import com.irtimaled.bbor.common.TypeHelper;
import com.irtimaled.bbor.common.models.Coords;

public class BoundingBoxConduit
extends BoundingBoxSphere {
    private final int level;

    private BoundingBoxConduit(Coords coords, int level, int radius) {
        super(new Point(coords).offset(0.5, 0.5, 0.5), radius, BoundingBoxType.Conduit);
        this.level = level;
    }

    public BoundingBoxConduit(Coords coords, int level) {
        this(coords, level, 16 * level);
    }

    public int hashCode() {
        return TypeHelper.combineHashCodes(this.getType().hashCode(), this.getPoint().hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BoundingBoxConduit other = (BoundingBoxConduit)obj;
        return this.getPoint().equals(other.getPoint());
    }

    public int getLevel() {
        return this.level;
    }
}

