/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.models;

import com.irtimaled.bbor.client.models.Point;
import com.irtimaled.bbor.common.BoundingBoxType;
import com.irtimaled.bbor.common.models.AbstractBoundingBox;
import com.irtimaled.bbor.common.models.Coords;

public class BoundingBoxSphere
extends AbstractBoundingBox {
    private final double radius;
    private final double minX;
    private final double minZ;
    private final double maxX;
    private final double maxZ;
    private final Point point;

    public BoundingBoxSphere(Point point, double radius, BoundingBoxType type) {
        super(type);
        this.radius = radius;
        this.point = point;
        Coords center = point.getCoords();
        this.minX = (double)center.getX() - radius;
        this.minZ = (double)center.getZ() - radius;
        this.maxX = (double)center.getX() + radius;
        this.maxZ = (double)center.getZ() + radius;
    }

    @Override
    public Boolean intersectsBounds(int minX, int minZ, int maxX, int maxZ) {
        return this.maxX >= (double)minX && this.maxZ >= (double)minZ && this.minX <= (double)maxX && this.minZ <= (double)maxZ;
    }

    @Override
    protected double getDistanceX(double x) {
        return x - this.point.getX();
    }

    @Override
    protected double getDistanceY(double y) {
        return y - this.point.getY();
    }

    @Override
    protected double getDistanceZ(double z) {
        return z - this.point.getZ();
    }

    public double getRadius() {
        return this.radius;
    }

    public Point getPoint() {
        return this.point;
    }
}

