/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.providers;

import com.irtimaled.bbor.client.Player;
import com.irtimaled.bbor.client.config.BoundingBoxTypeHelper;
import com.irtimaled.bbor.client.interop.BedrockCeilingHelper;
import com.irtimaled.bbor.client.interop.ClientInterop;
import com.irtimaled.bbor.client.models.BoundingBoxBedrockCeiling;
import com.irtimaled.bbor.client.providers.IBoundingBoxProvider;
import com.irtimaled.bbor.client.providers.ICachingProvider;
import com.irtimaled.bbor.common.BoundingBoxType;
import com.irtimaled.bbor.common.MathHelper;
import com.irtimaled.bbor.common.models.Coords;
import com.irtimaled.bbor.common.models.DimensionId;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class BedrockCeilingProvider
implements IBoundingBoxProvider<BoundingBoxBedrockCeiling>,
ICachingProvider {
    private static final double CHUNK_SIZE = 16.0;
    private static Long lastGameTime = null;
    private static final Map<String, BedrockChunk> chunks = new HashMap<String, BedrockChunk>();

    @Override
    public void clearCache() {
        chunks.values().forEach(BedrockChunk::clear);
        chunks.clear();
    }

    @Override
    public Iterable<BoundingBoxBedrockCeiling> get(DimensionId dimensionId) {
        boolean shouldRecalculate = this.shouldRecalculate();
        int renderDistanceChunks = ClientInterop.getRenderDistanceChunks() / 2;
        int playerChunkX = MathHelper.floor(Player.getX() / 16.0);
        int playerChunkZ = MathHelper.floor(Player.getZ() / 16.0);
        HashSet<BoundingBoxBedrockCeiling> boxes = new HashSet<BoundingBoxBedrockCeiling>();
        for (int chunkX = playerChunkX - renderDistanceChunks; chunkX <= playerChunkX + renderDistanceChunks; ++chunkX) {
            for (int chunkZ = playerChunkZ - renderDistanceChunks; chunkZ <= playerChunkZ + renderDistanceChunks; ++chunkZ) {
                String key = String.format("%d,%d", chunkX, chunkZ);
                if (shouldRecalculate || !chunks.containsKey(key)) {
                    chunks.put(key, new BedrockChunk(chunkX, chunkZ));
                }
                BedrockChunk chunk = chunks.get(key);
                boxes.addAll(chunk.getBlocks());
            }
        }
        return boxes;
    }

    public boolean shouldRecalculate() {
        long gameTime = ClientInterop.getGameTime();
        if (!Long.valueOf(gameTime).equals(lastGameTime) && gameTime % 2L == 0L) {
            lastGameTime = gameTime;
            return true;
        }
        return false;
    }

    @Override
    public boolean canProvide(DimensionId dimensionId) {
        return dimensionId == DimensionId.NETHER && BoundingBoxTypeHelper.shouldRender(BoundingBoxType.BedrockCeiling) && Player.getY() > 110.0;
    }

    private static class BedrockChunk {
        private final Set<BoundingBoxBedrockCeiling> boxes = new HashSet<BoundingBoxBedrockCeiling>();

        public BedrockChunk(int chunkX, int chunkZ) {
            int chunkStartX = chunkX << 4;
            int chunkStartZ = chunkZ << 4;
            if (BedrockCeilingHelper.chunkLoaded(chunkX, chunkZ)) {
                this.findBoxesFromBlockState(chunkStartX, chunkStartZ);
            } else {
                this.findBoxesFromRNG(chunkX, chunkZ, chunkStartX, chunkStartZ);
            }
        }

        private void findBoxesFromBlockState(int chunkStartX, int chunkStartZ) {
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    Coords coords = this.getCoordsFromBlockState(chunkStartX + x, chunkStartZ + z);
                    if (coords == null) continue;
                    this.boxes.add(new BoundingBoxBedrockCeiling(coords));
                }
            }
        }

        private Coords getCoordsFromBlockState(int x, int z) {
            Coords coords = null;
            for (int y = 127; y >= 123; --y) {
                if (!BedrockCeilingHelper.isBedrock(x, y, z)) continue;
                if (coords == null) {
                    coords = new Coords(x, y, z);
                    continue;
                }
                return null;
            }
            return coords;
        }

        private void findBoxesFromRNG(int chunkX, int chunkZ, int chunkStartX, int chunkStartZ) {
            Random random = BedrockCeilingHelper.getRandomForChunk(chunkX, chunkZ);
            for (int dummy = 0; dummy < 768; ++dummy) {
                random.nextDouble();
            }
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    Coords coords = this.getBlocksFromRNG(random, chunkStartX + x, chunkStartZ + z);
                    if (coords == null) continue;
                    this.boxes.add(new BoundingBoxBedrockCeiling(coords));
                }
            }
        }

        private Coords getBlocksFromRNG(Random random, int x, int z) {
            int y;
            int count = 0;
            for (y = 127; y >= 123; --y) {
                if (y < 127 - random.nextInt(5)) continue;
                ++count;
            }
            for (y = 4; y >= 0; --y) {
                random.nextInt(5);
            }
            return count == 1 ? new Coords(x, 127, z) : null;
        }

        public Collection<? extends BoundingBoxBedrockCeiling> getBlocks() {
            return this.boxes;
        }

        public void clear() {
            this.boxes.clear();
        }
    }
}

