/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.providers;

import com.irtimaled.bbor.client.Player;
import com.irtimaled.bbor.client.config.BoundingBoxTypeHelper;
import com.irtimaled.bbor.client.config.ConfigManager;
import com.irtimaled.bbor.client.interop.BiomeBorderHelper;
import com.irtimaled.bbor.client.models.BoundingBoxBiomeBorder;
import com.irtimaled.bbor.client.providers.IBoundingBoxProvider;
import com.irtimaled.bbor.client.providers.ICachingProvider;
import com.irtimaled.bbor.common.BoundingBoxType;
import com.irtimaled.bbor.common.MathHelper;
import com.irtimaled.bbor.common.models.Coords;
import com.irtimaled.bbor.common.models.DimensionId;
import java.util.HashMap;
import java.util.Map;

public class BiomeBorderProvider
implements IBoundingBoxProvider<BoundingBoxBiomeBorder>,
ICachingProvider {
    private static Coords lastPlayerCoords = null;
    private static Boolean lastRenderAllTransitions = null;
    private static Integer lastRenderDistance = null;
    private static Integer lastMaxY = null;
    private static Map<Coords, BoundingBoxBiomeBorder> lastBorders = new HashMap<Coords, BoundingBoxBiomeBorder>();

    @Override
    public boolean canProvide(DimensionId dimensionId) {
        return BoundingBoxTypeHelper.shouldRender(BoundingBoxType.BiomeBorder);
    }

    @Override
    public Iterable<BoundingBoxBiomeBorder> get(DimensionId dimensionId) {
        Coords playerCoords = Player.getCoords();
        Integer renderDistance = ConfigManager.biomeBordersRenderDistance.get();
        Boolean renderAllTransitions = ConfigManager.renderOnlyCurrentBiome.get() == false;
        Integer maxY = (int)Player.getMaxY(ConfigManager.biomeBordersMaxY.get().intValue());
        if (!(playerCoords.equals(lastPlayerCoords) && renderDistance.equals(lastRenderDistance) && renderAllTransitions == lastRenderAllTransitions && maxY.equals(lastMaxY))) {
            lastPlayerCoords = playerCoords;
            lastRenderDistance = renderDistance;
            lastRenderAllTransitions = renderAllTransitions;
            lastMaxY = maxY;
            lastBorders = this.getBiomeBorders();
        }
        return lastBorders.values();
    }

    @Override
    public void clearCache() {
        lastBorders = new HashMap<Coords, BoundingBoxBiomeBorder>();
        lastPlayerCoords = null;
    }

    private Map<Coords, BoundingBoxBiomeBorder> getBiomeBorders() {
        int matchZ;
        int renderDistance = lastRenderDistance;
        Coords playerCoords = lastPlayerCoords;
        boolean renderAllTransitions = lastRenderAllTransitions;
        int maxY = lastMaxY;
        int width = MathHelper.floor(Math.pow(2.0, 3 + renderDistance));
        int blockX = playerCoords.getX();
        int minX = blockX - width;
        int maxX = blockX + width;
        int blockZ = playerCoords.getZ();
        int minZ = blockZ - width;
        int maxZ = blockZ + width;
        int size = width * 2 + 1;
        int[][] biomeIds = new int[size][size];
        for (int x = minX; x <= maxX; ++x) {
            int matchX = x - minX;
            for (int z = minZ; z <= maxZ; ++z) {
                matchZ = z - minZ;
                biomeIds[matchX][matchZ] = BiomeBorderHelper.getBiomeId(x, maxY, z);
            }
        }
        int playerBiomeId = BiomeBorderHelper.getBiomeId(playerCoords);
        HashMap<Coords, BoundingBoxBiomeBorder> borders = new HashMap<Coords, BoundingBoxBiomeBorder>();
        for (int matchX = 1; matchX < size - 2; ++matchX) {
            for (matchZ = 1; matchZ < size - 2; ++matchZ) {
                boolean west;
                int x = matchX + minX;
                int z = matchZ + minZ;
                int biomeId = biomeIds[matchX][matchZ];
                if (!renderAllTransitions && biomeId != playerBiomeId) continue;
                Coords coords = new Coords(x, maxY, z);
                if (lastBorders.containsKey(coords)) {
                    borders.put(coords, lastBorders.get(coords));
                    continue;
                }
                boolean north = biomeIds[matchX][matchZ - 1] != biomeId;
                boolean east = biomeIds[matchX + 1][matchZ] != biomeId;
                boolean south = biomeIds[matchX][matchZ + 1] != biomeId;
                boolean bl = west = biomeIds[matchX - 1][matchZ] != biomeId;
                if (!north && !east && !south && !west) continue;
                borders.put(coords, new BoundingBoxBiomeBorder(coords, north, east, south, west));
            }
        }
        return borders;
    }
}

