/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.providers;

import com.irtimaled.bbor.client.GetCache;
import com.irtimaled.bbor.client.Player;
import com.irtimaled.bbor.client.config.BoundingBoxTypeHelper;
import com.irtimaled.bbor.client.config.ConfigManager;
import com.irtimaled.bbor.client.interop.ClientInterop;
import com.irtimaled.bbor.client.providers.IBoundingBoxProvider;
import com.irtimaled.bbor.common.BoundingBoxCache;
import com.irtimaled.bbor.common.MathHelper;
import com.irtimaled.bbor.common.models.AbstractBoundingBox;
import com.irtimaled.bbor.common.models.DimensionId;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CacheProvider
implements IBoundingBoxProvider<AbstractBoundingBox> {
    private static final int CHUNK_SIZE = 16;
    private final GetCache getCache;

    public CacheProvider(GetCache getCache) {
        this.getCache = getCache;
    }

    private static boolean isWithinRenderDistance(AbstractBoundingBox boundingBox) {
        int renderDistanceBlocks = ClientInterop.getRenderDistanceChunks() * 16;
        int minX = MathHelper.floor(Player.getX() - (double)renderDistanceBlocks);
        int maxX = MathHelper.floor(Player.getX() + (double)renderDistanceBlocks);
        int minZ = MathHelper.floor(Player.getZ() - (double)renderDistanceBlocks);
        int maxZ = MathHelper.floor(Player.getZ() + (double)renderDistanceBlocks);
        return boundingBox.intersectsBounds(minX, minZ, maxX, maxZ);
    }

    @Override
    public Iterable<AbstractBoundingBox> get(DimensionId dimensionId) {
        Boolean outerBoxesOnly = ConfigManager.outerBoxesOnly.get();
        HashSet<AbstractBoundingBox> boundingBoxes = new HashSet<AbstractBoundingBox>();
        BoundingBoxCache cache = (BoundingBoxCache)this.getCache.apply(dimensionId);
        if (cache != null) {
            for (Map.Entry<AbstractBoundingBox, Set<AbstractBoundingBox>> entry : cache.getBoundingBoxes().entrySet()) {
                Set<AbstractBoundingBox> children;
                AbstractBoundingBox key = entry.getKey();
                if (!BoundingBoxTypeHelper.shouldRender(key.getType()) || !CacheProvider.isWithinRenderDistance(key)) continue;
                if (!outerBoxesOnly.booleanValue() && (children = entry.getValue()) != null && children.size() > 0) {
                    boundingBoxes.addAll(children);
                    continue;
                }
                boundingBoxes.add(key);
            }
        }
        return boundingBoxes;
    }
}

