/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.providers;

import com.irtimaled.bbor.client.config.BoundingBoxTypeHelper;
import com.irtimaled.bbor.client.interop.TileEntitiesHelper;
import com.irtimaled.bbor.client.models.BoundingBoxConduit;
import com.irtimaled.bbor.client.providers.IBoundingBoxProvider;
import com.irtimaled.bbor.common.BoundingBoxType;
import com.irtimaled.bbor.common.ReflectionHelper;
import com.irtimaled.bbor.common.models.Coords;
import com.irtimaled.bbor.common.models.DimensionId;
import java.lang.reflect.Type;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2597;

public class ConduitProvider
implements IBoundingBoxProvider<BoundingBoxConduit> {
    private static final Function<class_2597, List<class_2338>> blocksFetcher = ReflectionHelper.getPrivateFieldGetter(class_2597.class, List.class, new Type[]{class_2338.class});

    @Override
    public boolean canProvide(DimensionId dimensionId) {
        return BoundingBoxTypeHelper.shouldRender(BoundingBoxType.Conduit);
    }

    @Override
    public Iterable<BoundingBoxConduit> get(DimensionId dimensionId) {
        return TileEntitiesHelper.map(class_2597.class, conduit -> {
            List<class_2338> blocks = blocksFetcher.apply((class_2597)conduit);
            if (blocks == null) {
                return null;
            }
            Coords coords = new Coords((class_2382)conduit.method_11016());
            int level = conduit.method_11065() ? blocks.size() / 7 : 0;
            return new BoundingBoxConduit(coords, level);
        });
    }
}

