/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.providers;

import com.irtimaled.bbor.client.Player;
import com.irtimaled.bbor.client.models.BoundingBoxLine;
import com.irtimaled.bbor.client.models.Point;
import com.irtimaled.bbor.client.providers.IBoundingBoxProvider;
import com.irtimaled.bbor.client.providers.ICachingProvider;
import com.irtimaled.bbor.common.BoundingBoxType;
import com.irtimaled.bbor.common.models.DimensionId;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CustomLineProvider
implements IBoundingBoxProvider<BoundingBoxLine>,
ICachingProvider {
    private static final Map<DimensionId, Map<Integer, BoundingBoxLine>> dimensionCache = new HashMap<DimensionId, Map<Integer, BoundingBoxLine>>();

    private static int getHashKey(Point minPoint, Point maxPoint) {
        return (31 + minPoint.hashCode()) * 31 + maxPoint.hashCode();
    }

    private static Map<Integer, BoundingBoxLine> getCache(DimensionId dimensionId) {
        return dimensionCache.computeIfAbsent(dimensionId, i -> new ConcurrentHashMap());
    }

    public static void add(Point minPoint, Point maxPoint, Double width) {
        DimensionId dimensionId = Player.getDimensionId();
        int cacheKey = CustomLineProvider.getHashKey(minPoint, maxPoint);
        BoundingBoxLine line = BoundingBoxLine.from(minPoint, maxPoint, width, BoundingBoxType.Custom);
        CustomLineProvider.getCache(dimensionId).put(cacheKey, line);
    }

    public static boolean remove(Point min, Point max) {
        DimensionId dimensionId = Player.getDimensionId();
        int cacheKey = CustomLineProvider.getHashKey(min, max);
        return CustomLineProvider.getCache(dimensionId).remove(cacheKey) != null;
    }

    public static void clear() {
        dimensionCache.values().forEach(Map::clear);
    }

    @Override
    public void clearCache() {
        CustomLineProvider.clear();
    }

    @Override
    public Iterable<BoundingBoxLine> get(DimensionId dimensionId) {
        return CustomLineProvider.getCache(dimensionId).values();
    }
}

