/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.providers;

import com.irtimaled.bbor.client.Player;
import com.irtimaled.bbor.client.models.BoundingBoxSphere;
import com.irtimaled.bbor.client.models.Point;
import com.irtimaled.bbor.client.providers.IBoundingBoxProvider;
import com.irtimaled.bbor.client.providers.ICachingProvider;
import com.irtimaled.bbor.common.BoundingBoxType;
import com.irtimaled.bbor.common.models.DimensionId;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CustomSphereProvider
implements IBoundingBoxProvider<BoundingBoxSphere>,
ICachingProvider {
    private static final Map<DimensionId, Map<Integer, BoundingBoxSphere>> dimensionCache = new HashMap<DimensionId, Map<Integer, BoundingBoxSphere>>();

    private static Map<Integer, BoundingBoxSphere> getCache(DimensionId dimensionId) {
        return dimensionCache.computeIfAbsent(dimensionId, i -> new ConcurrentHashMap());
    }

    public static void add(Point center, double radius) {
        DimensionId dimensionId = Player.getDimensionId();
        int cacheKey = center.hashCode();
        BoundingBoxSphere sphere = new BoundingBoxSphere(center, radius, BoundingBoxType.Custom);
        CustomSphereProvider.getCache(dimensionId).put(cacheKey, sphere);
    }

    public static boolean remove(Point center) {
        DimensionId dimensionId = Player.getDimensionId();
        int cacheKey = center.hashCode();
        return CustomSphereProvider.getCache(dimensionId).remove(cacheKey) != null;
    }

    public static void clear() {
        dimensionCache.values().forEach(Map::clear);
    }

    @Override
    public void clearCache() {
        CustomSphereProvider.clear();
    }

    @Override
    public Iterable<BoundingBoxSphere> get(DimensionId dimensionId) {
        return CustomSphereProvider.getCache(dimensionId).values();
    }
}

