/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.providers;

import com.irtimaled.bbor.client.Player;
import com.irtimaled.bbor.client.config.BoundingBoxTypeHelper;
import com.irtimaled.bbor.client.interop.ClientInterop;
import com.irtimaled.bbor.client.models.BoundingBoxSlimeChunk;
import com.irtimaled.bbor.client.providers.IBoundingBoxProvider;
import com.irtimaled.bbor.client.providers.ICachingProvider;
import com.irtimaled.bbor.common.BoundingBoxType;
import com.irtimaled.bbor.common.MathHelper;
import com.irtimaled.bbor.common.models.Coords;
import com.irtimaled.bbor.common.models.DimensionId;
import java.util.HashSet;
import net.minecraft.class_2919;

public class SlimeChunkProvider
implements IBoundingBoxProvider<BoundingBoxSlimeChunk>,
ICachingProvider {
    private static final double CHUNK_SIZE = 16.0;
    private static Long seed;

    public static void setSeed(long seed) {
        SlimeChunkProvider.seed = seed;
    }

    private static boolean isSlimeChunk(int chunkX, int chunkZ) {
        return class_2919.method_12662((int)chunkX, (int)chunkZ, (long)seed, (long)987234911L).nextInt(10) == 0;
    }

    @Override
    public void clearCache() {
        seed = null;
    }

    @Override
    public boolean canProvide(DimensionId dimensionId) {
        return dimensionId == DimensionId.OVERWORLD && seed != null && BoundingBoxTypeHelper.shouldRender(BoundingBoxType.SlimeChunks);
    }

    @Override
    public Iterable<BoundingBoxSlimeChunk> get(DimensionId dimensionId) {
        HashSet<BoundingBoxSlimeChunk> slimeChunks = new HashSet<BoundingBoxSlimeChunk>();
        int renderDistanceChunks = ClientInterop.getRenderDistanceChunks();
        int playerChunkX = MathHelper.floor(Player.getX() / 16.0);
        int playerChunkZ = MathHelper.floor(Player.getZ() / 16.0);
        for (int chunkX = playerChunkX - renderDistanceChunks; chunkX <= playerChunkX + renderDistanceChunks; ++chunkX) {
            for (int chunkZ = playerChunkZ - renderDistanceChunks; chunkZ <= playerChunkZ + renderDistanceChunks; ++chunkZ) {
                if (!SlimeChunkProvider.isSlimeChunk(chunkX, chunkZ)) continue;
                int chunkXStart = chunkX << 4;
                int chunkZStart = chunkZ << 4;
                Coords minCoords = new Coords(chunkXStart, 1, chunkZStart);
                Coords maxCoords = new Coords(chunkXStart + 15, 38, chunkZStart + 15);
                slimeChunks.add(new BoundingBoxSlimeChunk(minCoords, maxCoords));
            }
        }
        return slimeChunks;
    }
}

