/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.providers;

import com.irtimaled.bbor.client.Player;
import com.irtimaled.bbor.client.config.BoundingBoxTypeHelper;
import com.irtimaled.bbor.client.config.ConfigManager;
import com.irtimaled.bbor.client.interop.SpawnableBlocksHelper;
import com.irtimaled.bbor.client.models.BoundingBoxSpawnableBlocks;
import com.irtimaled.bbor.client.providers.IBoundingBoxProvider;
import com.irtimaled.bbor.client.providers.ICachingProvider;
import com.irtimaled.bbor.client.providers.SpawningSphereProvider;
import com.irtimaled.bbor.common.BoundingBoxType;
import com.irtimaled.bbor.common.MathHelper;
import com.irtimaled.bbor.common.models.DimensionId;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_310;

public class SpawnableBlocksProvider
implements IBoundingBoxProvider<BoundingBoxSpawnableBlocks>,
ICachingProvider {
    public static final class_310 minecraft = class_310.method_1551();
    private static Long lastGameTime = null;
    private static Set<BoundingBoxSpawnableBlocks> lastBoundingBox = null;

    @Override
    public void clearCache() {
        lastGameTime = null;
        lastBoundingBox = null;
    }

    private boolean isWithinActiveSpawningSphere() {
        return BoundingBoxTypeHelper.shouldRender(BoundingBoxType.AFKSphere) && ConfigManager.renderAFKSpawnableBlocks.get() != false && SpawningSphereProvider.playerInsideSphere();
    }

    @Override
    public boolean canProvide(DimensionId dimensionId) {
        return BoundingBoxTypeHelper.shouldRender(BoundingBoxType.SpawnableBlocks) && !this.isWithinActiveSpawningSphere();
    }

    @Override
    public Iterable<BoundingBoxSpawnableBlocks> get(DimensionId dimensionId) {
        long gameTime = SpawnableBlocksProvider.minecraft.field_1687.method_8510();
        if (lastBoundingBox == null || !Long.valueOf(gameTime).equals(lastGameTime) && gameTime % 2L == 0L) {
            lastGameTime = gameTime;
            lastBoundingBox = this.getSpawnableBlocks();
        }
        return lastBoundingBox;
    }

    private Set<BoundingBoxSpawnableBlocks> getSpawnableBlocks() {
        BoundingBoxSpawnableBlocks boundingBox = new BoundingBoxSpawnableBlocks();
        int width = MathHelper.floor(Math.pow(2.0, 1 + ConfigManager.spawnableBlocksRenderWidth.get()));
        int height = MathHelper.floor(Math.pow(2.0, ConfigManager.spawnableBlocksRenderHeight.get().intValue()));
        SpawnableBlocksHelper.findSpawnableBlocks(Player.getCoords(), width, height, boundingBox.getBlocks()::add);
        HashSet<BoundingBoxSpawnableBlocks> boundingBoxes = new HashSet<BoundingBoxSpawnableBlocks>();
        boundingBoxes.add(boundingBox);
        return boundingBoxes;
    }
}

