/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.renderers;

import com.irtimaled.bbor.client.config.ConfigManager;
import com.irtimaled.bbor.client.models.Point;
import com.irtimaled.bbor.client.renderers.OffsetBox;
import com.irtimaled.bbor.client.renderers.OffsetPoint;
import com.irtimaled.bbor.client.renderers.RenderHelper;
import com.irtimaled.bbor.client.renderers.RenderQueue;
import com.irtimaled.bbor.client.renderers.Renderer;
import com.irtimaled.bbor.common.MathHelper;
import com.irtimaled.bbor.common.models.AbstractBoundingBox;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;

public abstract class AbstractRenderer<T extends AbstractBoundingBox> {
    private static final double TAU = Math.PI * 2;
    public static final double PHI_SEGMENT = 0.06981317007977318;
    private static final double PI = Math.PI;
    public static final double THETA_SEGMENT = Math.PI / 90;

    public abstract void render(class_4587 var1, T var2);

    void renderCuboid(OffsetBox bb, Color color) {
        OffsetBox nudge = bb.nudge();
        this.renderOutlinedCuboid(nudge, color);
        this.renderFilledFaces(nudge.getMin(), nudge.getMax(), color);
    }

    void renderOutlinedCuboid(OffsetBox bb, Color color) {
        RenderHelper.polygonModeLine();
        OffsetPoint min = bb.getMin();
        OffsetPoint max = bb.getMax();
        this.renderFaces(min, max, color, 255, min.getY() == max.getY() ? Renderer::startLineLoop : Renderer::startLines);
    }

    private void renderFaces(OffsetPoint min, OffsetPoint max, Color color, int alpha, Supplier<Renderer> rendererSupplier) {
        double minX = min.getX();
        double minY = min.getY();
        double minZ = min.getZ();
        double maxX = max.getX();
        double maxY = max.getY();
        double maxZ = max.getZ();
        if (ConfigManager.invertBoxColorPlayerInside.get().booleanValue() && this.playerInsideBoundingBox(minX, minY, minZ, maxX, maxY, maxZ)) {
            color = new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue());
        }
        Renderer renderer = rendererSupplier.get().setColor(color).setAlpha(alpha);
        if (minX != maxX && minZ != maxZ) {
            renderer.addPoint(minX, minY, minZ).addPoint(maxX, minY, minZ).addPoint(maxX, minY, maxZ).addPoint(minX, minY, maxZ);
            if (minY != maxY) {
                renderer.addPoint(minX, maxY, minZ).addPoint(maxX, maxY, minZ).addPoint(maxX, maxY, maxZ).addPoint(minX, maxY, maxZ);
            }
        }
        if (minX != maxX && minY != maxY) {
            renderer.addPoint(minX, minY, maxZ).addPoint(minX, maxY, maxZ).addPoint(maxX, maxY, maxZ).addPoint(maxX, minY, maxZ);
            if (minZ != maxZ) {
                renderer.addPoint(minX, minY, minZ).addPoint(minX, maxY, minZ).addPoint(maxX, maxY, minZ).addPoint(maxX, minY, minZ);
            }
        }
        if (minY != maxY && minZ != maxZ) {
            renderer.addPoint(minX, minY, minZ).addPoint(minX, minY, maxZ).addPoint(minX, maxY, maxZ).addPoint(minX, maxY, minZ);
            if (minX != maxX) {
                renderer.addPoint(maxX, minY, minZ).addPoint(maxX, minY, maxZ).addPoint(maxX, maxY, maxZ).addPoint(maxX, maxY, minZ);
            }
        }
        renderer.render();
    }

    private boolean playerInsideBoundingBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return minX < 0.0 && maxX > 0.0 && minY < 0.0 && maxY > 0.0 && minZ < 0.0 && maxZ > 0.0;
    }

    void renderLine(OffsetPoint startPoint, OffsetPoint endPoint, Color color) {
        RenderHelper.polygonModeLine();
        Renderer.startLines().setColor(color).addPoint(startPoint).addPoint(endPoint).render();
    }

    void renderFilledFaces(OffsetPoint min, OffsetPoint max, Color color) {
        this.renderFilledFaces(min, max, color, 30);
    }

    void renderFilledFaces(OffsetPoint min, OffsetPoint max, Color color, int alpha) {
        if (!ConfigManager.fill.get().booleanValue()) {
            return;
        }
        RenderQueue.deferRendering(() -> this.renderFaces(min, max, color, alpha, Renderer::startQuads));
    }

    void renderText(OffsetPoint offsetPoint, String ... texts) {
        class_327 fontRenderer = class_310.method_1551().field_1772;
        RenderHelper.beforeRenderFont(offsetPoint);
        fontRenderer.getClass();
        float top = (float)(-(9 * texts.length)) / 2.0f;
        for (String text : texts) {
            float left = (float)fontRenderer.method_1727(text) / 2.0f;
            fontRenderer.method_1729(new class_4587(), text, -left, top, -1);
            fontRenderer.getClass();
            top += 9.0f;
        }
        RenderHelper.afterRenderFont();
    }

    void renderSphere(Point center, double radius, Color color) {
        if (ConfigManager.renderSphereAsDots.get().booleanValue()) {
            this.renderDotSphere(center, radius, color);
        } else {
            this.renderLineSphere(center, radius, color);
        }
    }

    private void renderLineSphere(Point center, double radius, Color color) {
        RenderHelper.lineWidth2();
        double offset = radius - (double)((int)radius) == 0.0 ? center.getY() - (double)((int)center.getY()) : 0.0;
        int dyStep = radius < 64.0 ? 1 : MathHelper.floor(radius / 32.0);
        for (double dy = offset - radius; dy <= radius + 1.0; dy += (double)dyStep) {
            double circleRadius = Math.sqrt(radius * radius - dy * dy);
            if (circleRadius == 0.0) {
                circleRadius = Math.sqrt(2.0) / 2.0;
            }
            this.renderCircle(center, circleRadius, color, dy + (double)0.001f);
        }
    }

    private void renderCircle(Point center, double radius, Color color, double dy) {
        Renderer renderer = Renderer.startLineLoop().setColor(color);
        for (double phi = 0.0; phi < Math.PI * 2; phi += 0.06981317007977318) {
            renderer.addPoint(new OffsetPoint(center.offset(Math.cos(phi) * radius, dy, Math.sin(phi) * radius)));
        }
        renderer.render();
    }

    private void renderDotSphere(Point center, double radius, Color color) {
        RenderHelper.enablePointSmooth();
        RenderHelper.pointSize5();
        Renderer renderer = Renderer.startPoints().setColor(color);
        for (double phi = 0.0; phi < Math.PI * 2; phi += 0.06981317007977318) {
            double dy = radius * Math.cos(phi);
            double radiusBySinPhi = radius * Math.sin(phi);
            for (double theta = 0.0; theta < Math.PI; theta += Math.PI / 90) {
                double dx = radiusBySinPhi * Math.cos(theta);
                double dz = radiusBySinPhi * Math.sin(theta);
                renderer.addPoint(new OffsetPoint(center.offset(dx, dy, dz)));
            }
        }
        renderer.render();
    }
}

