/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.renderers;

import com.irtimaled.bbor.client.config.BoundingBoxTypeHelper;
import com.irtimaled.bbor.client.config.ConfigManager;
import com.irtimaled.bbor.client.models.BoundingBoxBiomeBorder;
import com.irtimaled.bbor.client.renderers.AbstractRenderer;
import com.irtimaled.bbor.client.renderers.OffsetPoint;
import com.irtimaled.bbor.common.models.Coords;
import java.awt.Color;
import net.minecraft.class_4587;

public class BiomeBorderRenderer
extends AbstractRenderer<BoundingBoxBiomeBorder> {
    @Override
    public void render(class_4587 matrixStack, BoundingBoxBiomeBorder boundingBox) {
        Coords coords = boundingBox.getCoords();
        OffsetPoint northWest = new OffsetPoint(coords).offset(0.0, 0.001f, 0.0);
        OffsetPoint northEast = northWest.offset(1.0, 0.0, 0.0);
        OffsetPoint southWest = northWest.offset(0.0, 0.0, 1.0);
        Color color = BoundingBoxTypeHelper.getColor(boundingBox.getType());
        if (boundingBox.renderNorth()) {
            this.render(northWest, northEast, color);
        }
        if (boundingBox.renderWest()) {
            this.render(northWest, southWest, color);
        }
        if (ConfigManager.renderOnlyCurrentBiome.get().booleanValue()) {
            OffsetPoint southEast = southWest.offset(1.0, 0.0, 0.0);
            if (boundingBox.renderSouth()) {
                this.render(southWest, southEast, color);
            }
            if (boundingBox.renderEast()) {
                this.render(northEast, southEast, color);
            }
        }
    }

    private void render(OffsetPoint topCorner1, OffsetPoint topCorner2, Color color) {
        double xOffset = 0.0;
        double zOffset = 0.0;
        if (topCorner1.getX() == topCorner2.getX()) {
            xOffset = this.getOffset(topCorner1.getX());
        } else {
            zOffset = this.getOffset(topCorner1.getZ());
        }
        topCorner1 = topCorner1.offset(xOffset, 0.0, zOffset);
        topCorner2 = topCorner2.offset(xOffset, 0.0, zOffset);
        this.renderLine(topCorner1, topCorner2, color);
        OffsetPoint bottomCorner2 = topCorner2.offset(0.0, 1.0, 0.0);
        this.renderFilledFaces(topCorner1, bottomCorner2, color);
        OffsetPoint bottomCorner1 = topCorner1.offset(0.0, 1.0, 0.0);
        this.renderLine(bottomCorner1, bottomCorner2, color);
    }

    private double getOffset(double value) {
        return value > 0.0 ? (double)-0.001f : (double)0.001f;
    }
}

