/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.renderers;

import com.irtimaled.bbor.client.Player;
import com.irtimaled.bbor.client.config.BoundingBoxTypeHelper;
import com.irtimaled.bbor.client.config.ColorHelper;
import com.irtimaled.bbor.client.config.ConfigManager;
import com.irtimaled.bbor.client.models.BoundingBoxMobSpawner;
import com.irtimaled.bbor.client.renderers.AbstractRenderer;
import com.irtimaled.bbor.client.renderers.OffsetBox;
import com.irtimaled.bbor.client.renderers.OffsetPoint;
import com.irtimaled.bbor.common.models.Coords;
import java.awt.Color;
import net.minecraft.class_4587;

public class MobSpawnerRenderer
extends AbstractRenderer<BoundingBoxMobSpawner> {
    @Override
    public void render(class_4587 matrixStack, BoundingBoxMobSpawner boundingBox) {
        Coords coords = boundingBox.getCoords();
        Color color = BoundingBoxTypeHelper.getColor(boundingBox.getType());
        this.renderCuboid(new OffsetBox(coords, coords), color);
        if (ConfigManager.renderMobSpawnerActivationLines.get().booleanValue()) {
            this.renderActivationLine(new OffsetPoint(coords).offset(0.5, 0.5, 0.5));
        }
        if (ConfigManager.renderMobSpawnerSpawnArea.get().booleanValue()) {
            OffsetBox bb = new OffsetBox(boundingBox.getMinCoords(), boundingBox.getMaxCoords());
            this.renderCuboid(bb, color);
        }
    }

    private void renderActivationLine(OffsetPoint centerPoint) {
        OffsetPoint playerPos = new OffsetPoint(Player.getPoint());
        double distance = centerPoint.getDistance(playerPos);
        if (distance <= 20.0) {
            OffsetPoint playerPoint = playerPos.offset(0.0, 0.1, 0.0);
            this.renderLine(centerPoint, playerPoint, this.getColor(distance));
        }
    }

    private Color getColor(double distance) {
        if (distance > 18.0) {
            return ColorHelper.getColor(ConfigManager.colorMobSpawnersLineFarAway);
        }
        if (distance > 16.0) {
            return ColorHelper.getColor(ConfigManager.colorMobSpawnersLineNearby);
        }
        return ColorHelper.getColor(ConfigManager.colorMobSpawnersLineActive);
    }
}

