/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.renderers;

import com.irtimaled.bbor.client.renderers.OffsetPoint;
import com.irtimaled.bbor.common.models.Coords;

class OffsetBox {
    private final OffsetPoint min;
    private final OffsetPoint max;

    OffsetBox(Coords minCoords, Coords maxCoords) {
        this.min = new OffsetPoint(minCoords);
        this.max = new OffsetPoint(maxCoords).offset(1.0, 1.0, 1.0);
    }

    OffsetBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.min = new OffsetPoint(minX, minY, minZ);
        this.max = new OffsetPoint(maxX, maxY, maxZ);
    }

    OffsetBox(OffsetPoint min, OffsetPoint max) {
        this.min = min;
        this.max = max;
    }

    OffsetBox grow(double x, double y, double z) {
        return new OffsetBox(this.min.offset(-x, -y, -z), this.max.offset(x, y, z));
    }

    OffsetBox nudge() {
        double growXZ = 0.001f;
        if (this.min.getY() == this.max.getY()) {
            return new OffsetBox(this.min.offset(-growXZ, growXZ, -growXZ), this.max.offset(growXZ, growXZ, growXZ));
        }
        return this.grow(growXZ, growXZ, growXZ);
    }

    OffsetPoint getMin() {
        return this.min;
    }

    OffsetPoint getMax() {
        return this.max;
    }
}

