/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.renderers;

import com.irtimaled.bbor.client.Camera;
import com.irtimaled.bbor.client.renderers.OffsetPoint;
import java.awt.Color;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;

public class Renderer {
    private final int glMode;
    private static final class_289 tessellator = new class_289(0x200000);
    private static final class_287 bufferBuilder = tessellator.method_1349();
    private int red;
    private int green;
    private int blue;
    private int alpha;

    static Renderer startLines() {
        return new Renderer(1, class_290.field_1576);
    }

    static Renderer startLineLoop() {
        return new Renderer(2, class_290.field_1576);
    }

    static Renderer startQuads() {
        return new Renderer(7, class_290.field_1576);
    }

    static Renderer startPoints() {
        return new Renderer(0, class_290.field_1576);
    }

    public static Renderer startTextured() {
        return new Renderer(7, class_290.field_1575);
    }

    private Renderer(int glMode, class_293 vertexFormat) {
        bufferBuilder.method_1328(glMode, vertexFormat);
        this.glMode = glMode;
    }

    public Renderer setColor(Color color) {
        return this.setColor(color.getRed(), color.getGreen(), color.getBlue()).setAlpha(color.getAlpha());
    }

    public Renderer setColor(int red, int green, int blue) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        return this;
    }

    public Renderer setAlpha(int alpha) {
        this.alpha = alpha;
        return this;
    }

    Renderer addPoint(OffsetPoint point) {
        return this.addPoint(point.getX(), point.getY(), point.getZ());
    }

    public Renderer addPoints(OffsetPoint[] points) {
        Renderer renderer = this;
        for (OffsetPoint point : points) {
            renderer = renderer.addPoint(point);
        }
        return renderer;
    }

    Renderer addPoint(double x, double y, double z) {
        this.pos(x, y, z);
        this.color();
        this.end();
        return this;
    }

    public Renderer addPoint(double x, double y, double z, double u, double v) {
        this.pos(x, y, z);
        this.tex(u, v);
        this.color();
        this.end();
        return this;
    }

    public void render() {
        if (this.glMode == 7) {
            bufferBuilder.method_1341((float)Camera.getX(), (float)Camera.getY(), (float)Camera.getZ());
        }
        tessellator.method_1350();
    }

    private void pos(double x, double y, double z) {
        bufferBuilder.method_22912(x, y, z);
    }

    private void tex(double u, double v) {
        bufferBuilder.method_22913((float)u, (float)v);
    }

    private void color() {
        bufferBuilder.method_1336(this.red, this.green, this.blue, this.alpha);
    }

    private void end() {
        bufferBuilder.method_1344();
    }
}

