/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.client.renderers;

import com.irtimaled.bbor.client.Player;
import com.irtimaled.bbor.client.config.BoundingBoxTypeHelper;
import com.irtimaled.bbor.client.config.ColorHelper;
import com.irtimaled.bbor.client.config.ConfigManager;
import com.irtimaled.bbor.client.models.BoundingBoxSpawningSphere;
import com.irtimaled.bbor.client.models.Point;
import com.irtimaled.bbor.client.renderers.AbstractRenderer;
import com.irtimaled.bbor.client.renderers.OffsetBox;
import com.irtimaled.bbor.client.renderers.OffsetPoint;
import com.irtimaled.bbor.common.BoundingBoxType;
import java.awt.Color;
import net.minecraft.class_1074;
import net.minecraft.class_4587;

public class SpawningSphereRenderer
extends AbstractRenderer<BoundingBoxSpawningSphere> {
    @Override
    public void render(class_4587 matrixStack, BoundingBoxSpawningSphere boundingBox) {
        Point point = boundingBox.getPoint();
        OffsetPoint sphereCenter = new OffsetPoint(point);
        Color safeAreaColor = ColorHelper.getColor(ConfigManager.colorAFKSpheresSafeArea);
        this.renderSphere(point, 24.0, safeAreaColor);
        this.renderOuterSphere(boundingBox, point);
        OffsetBox offsetBox = new OffsetBox(sphereCenter, sphereCenter).grow(0.5, 0.0, 0.5);
        this.renderCuboid(offsetBox, safeAreaColor);
        Integer spawnableSpacesCount = boundingBox.getSpawnableSpacesCount();
        if (spawnableSpacesCount != null) {
            this.renderText(sphereCenter, class_1074.method_4662((String)"bbor.renderer.spawningSphere.spawnable", (Object[])new Object[0]), spawnableSpacesCount == 0 ? class_1074.method_4662((String)"bbor.renderer.spawningSphere.none", (Object[])new Object[0]) : String.format("%,d", spawnableSpacesCount));
        }
        this.renderSphere(point, 24.0, safeAreaColor);
        if (ConfigManager.renderAFKSpawnableBlocks.get().booleanValue() && boundingBox.isWithinSphere(Player.getPoint())) {
            this.renderSpawnableSpaces(boundingBox);
        }
    }

    private void renderOuterSphere(BoundingBoxSpawningSphere boundingBox, Point point) {
        Color color = BoundingBoxTypeHelper.getColor(boundingBox.getType());
        this.renderSphere(point, 128.0, color);
    }

    private void renderSpawnableSpaces(BoundingBoxSpawningSphere boundingBox) {
        Color color = BoundingBoxTypeHelper.getColor(BoundingBoxType.SpawnableBlocks);
        boundingBox.getBlocks().forEach(c -> {
            int x = c.method_10263();
            int y = c.method_10264();
            int z = c.method_10260();
            OffsetBox offsetBox = new OffsetBox(x, y, z, x + 1, y, z + 1);
            this.renderCuboid(offsetBox, color);
        });
    }
}

