/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.common;

import com.irtimaled.bbor.common.StructureProcessor;
import java.util.HashMap;
import java.util.Map;

public class BoundingBoxType {
    private static final Map<Integer, BoundingBoxType> structureTypeMap = new HashMap<Integer, BoundingBoxType>();
    public static final BoundingBoxType WorldSpawn = BoundingBoxType.register("World_Spawn");
    public static final BoundingBoxType SpawnChunks = BoundingBoxType.register("Spawn_Chunks");
    public static final BoundingBoxType LazySpawnChunks = BoundingBoxType.register("Lazy_Chunks");
    public static final BoundingBoxType MobSpawner = BoundingBoxType.register("Mob_Spawner");
    public static final BoundingBoxType SlimeChunks = BoundingBoxType.register("Slime_Chunks");
    public static final BoundingBoxType AFKSphere = BoundingBoxType.register("AFK Sphere");
    public static final BoundingBoxType BiomeBorder = BoundingBoxType.register("Biome Border");
    public static final BoundingBoxType Custom = BoundingBoxType.register("Custom");
    public static final BoundingBoxType Beacon = BoundingBoxType.register("Beacon");
    public static final BoundingBoxType Conduit = BoundingBoxType.register("Conduit");
    public static final BoundingBoxType SpawnableBlocks = BoundingBoxType.register("Spawnable Blocks");
    public static final BoundingBoxType FlowerForest = BoundingBoxType.register("Flower Forest");
    public static final BoundingBoxType BedrockCeiling = BoundingBoxType.register("Bedrock Ceiling");
    public static final BoundingBoxType JungleTemple = BoundingBoxType.register("jungle_pyramid");
    public static final BoundingBoxType DesertTemple = BoundingBoxType.register("desert_pyramid");
    public static final BoundingBoxType WitchHut = BoundingBoxType.register("swamp_hut");
    public static final BoundingBoxType OceanMonument = BoundingBoxType.register("monument");
    public static final BoundingBoxType Shipwreck = BoundingBoxType.register("shipwreck");
    public static final BoundingBoxType OceanRuin = BoundingBoxType.register("ocean_ruin");
    public static final BoundingBoxType BuriedTreasure = BoundingBoxType.register("buried_treasure");
    public static final BoundingBoxType Stronghold = BoundingBoxType.register("stronghold");
    public static final BoundingBoxType MineShaft = BoundingBoxType.register("mineshaft");
    public static final BoundingBoxType NetherFortress = BoundingBoxType.register("fortress");
    public static final BoundingBoxType EndCity = BoundingBoxType.register("endcity");
    public static final BoundingBoxType Mansion = BoundingBoxType.register("mansion");
    public static final BoundingBoxType Igloo = BoundingBoxType.register("igloo");
    public static final BoundingBoxType PillagerOutpost = BoundingBoxType.register("pillager_outpost");
    public static final BoundingBoxType Village = BoundingBoxType.register("village");
    public static final BoundingBoxType NetherFossil = BoundingBoxType.register("nether_fossil");
    public static final BoundingBoxType BastionRemnant = BoundingBoxType.register("bastion_remnant");
    public static final BoundingBoxType RuinedPortal = BoundingBoxType.register("ruined_portal");
    private final String name;

    private static BoundingBoxType register(String name) {
        return structureTypeMap.computeIfAbsent(name.hashCode(), k -> new BoundingBoxType(name));
    }

    public static void registerTypes() {
        structureTypeMap.values().forEach(StructureProcessor::registerSupportedStructure);
    }

    public static BoundingBoxType getByNameHash(Integer nameHash) {
        return structureTypeMap.get(nameHash);
    }

    private BoundingBoxType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BoundingBoxType other = (BoundingBoxType)obj;
        return this.name.equals(other.name);
    }
}

