/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.common;

import com.irtimaled.bbor.Logger;
import com.irtimaled.bbor.common.BoundingBoxCache;
import com.irtimaled.bbor.common.BoundingBoxType;
import com.irtimaled.bbor.common.EventBus;
import com.irtimaled.bbor.common.StructureProcessor;
import com.irtimaled.bbor.common.events.PlayerLoggedIn;
import com.irtimaled.bbor.common.events.PlayerLoggedOut;
import com.irtimaled.bbor.common.events.PlayerSubscribed;
import com.irtimaled.bbor.common.events.ServerTick;
import com.irtimaled.bbor.common.events.StructuresLoaded;
import com.irtimaled.bbor.common.events.WorldLoaded;
import com.irtimaled.bbor.common.messages.AddBoundingBox;
import com.irtimaled.bbor.common.messages.InitializeClient;
import com.irtimaled.bbor.common.messages.PayloadBuilder;
import com.irtimaled.bbor.common.models.AbstractBoundingBox;
import com.irtimaled.bbor.common.models.DimensionId;
import com.irtimaled.bbor.common.models.ServerPlayer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CommonProxy {
    private final Map<Integer, ServerPlayer> players = new ConcurrentHashMap<Integer, ServerPlayer>();
    private final Map<Integer, Set<AbstractBoundingBox>> playerBoundingBoxesCache = new HashMap<Integer, Set<AbstractBoundingBox>>();
    private final Map<DimensionId, StructureProcessor> structureProcessors = new HashMap<DimensionId, StructureProcessor>();
    private final Map<DimensionId, BoundingBoxCache> dimensionCache = new ConcurrentHashMap<DimensionId, BoundingBoxCache>();
    private Long seed = null;
    private Integer spawnX = null;
    private Integer spawnZ = null;

    public void init() {
        BoundingBoxType.registerTypes();
        EventBus.subscribe(WorldLoaded.class, this::worldLoaded);
        EventBus.subscribe(StructuresLoaded.class, this::structuresLoaded);
        EventBus.subscribe(PlayerLoggedIn.class, this::playerLoggedIn);
        EventBus.subscribe(PlayerLoggedOut.class, this::playerLoggedOut);
        EventBus.subscribe(PlayerSubscribed.class, this::onPlayerSubscribed);
        EventBus.subscribe(ServerTick.class, e -> this.serverTick());
    }

    protected void setSeed(long seed) {
        this.seed = seed;
    }

    protected void setWorldSpawn(int spawnX, int spawnZ) {
        this.spawnX = spawnX;
        this.spawnZ = spawnZ;
    }

    private void worldLoaded(WorldLoaded event) {
        DimensionId dimensionId = event.getDimensionId();
        long seed = event.getSeed();
        if (dimensionId == DimensionId.OVERWORLD) {
            this.setSeed(seed);
            this.setWorldSpawn(event.getSpawnX(), event.getSpawnZ());
        }
        Logger.info("create world dimension: %s (seed: %d)", dimensionId, seed);
    }

    private void structuresLoaded(StructuresLoaded event) {
        DimensionId dimensionId = event.getDimensionId();
        StructureProcessor structureProcessor = this.getStructureProcessor(dimensionId);
        structureProcessor.process(event.getStructures());
    }

    private StructureProcessor getStructureProcessor(DimensionId dimensionId) {
        StructureProcessor structureProcessor = this.structureProcessors.get(dimensionId);
        if (structureProcessor == null) {
            structureProcessor = new StructureProcessor(this.getOrCreateCache(dimensionId));
            this.structureProcessors.put(dimensionId, structureProcessor);
        }
        return structureProcessor;
    }

    private void playerLoggedIn(PlayerLoggedIn event) {
        if (this.seed == null || this.spawnX == null || this.spawnZ == null) {
            return;
        }
        ServerPlayer player = event.getPlayer();
        player.sendPacket(InitializeClient.getPayload(this.seed, this.spawnX, this.spawnZ));
    }

    private void playerLoggedOut(PlayerLoggedOut event) {
        int playerId = event.getPlayerId();
        this.players.remove(playerId);
        this.playerBoundingBoxesCache.remove(playerId);
    }

    private void onPlayerSubscribed(PlayerSubscribed event) {
        int playerId = event.getPlayerId();
        ServerPlayer player = event.getPlayer();
        this.players.put(playerId, player);
        this.sendToPlayer(playerId, player);
    }

    private void sendToPlayer(int playerId, ServerPlayer player) {
        for (Map.Entry<DimensionId, BoundingBoxCache> entry : this.dimensionCache.entrySet()) {
            DimensionId dimensionId = entry.getKey();
            BoundingBoxCache boundingBoxCache = entry.getValue();
            if (boundingBoxCache == null) {
                return;
            }
            Set playerBoundingBoxes = this.playerBoundingBoxesCache.computeIfAbsent(playerId, k -> new HashSet());
            Map<AbstractBoundingBox, Set<AbstractBoundingBox>> boundingBoxMap = boundingBoxCache.getBoundingBoxes();
            for (AbstractBoundingBox key : boundingBoxMap.keySet()) {
                if (playerBoundingBoxes.contains(key)) continue;
                Set<AbstractBoundingBox> boundingBoxes = boundingBoxMap.get(key);
                PayloadBuilder payload = AddBoundingBox.getPayload(dimensionId, key, boundingBoxes);
                if (payload != null) {
                    player.sendPacket(payload);
                }
                playerBoundingBoxes.add(key);
            }
        }
    }

    private void serverTick() {
        for (Map.Entry<Integer, ServerPlayer> playerEntry : this.players.entrySet()) {
            int playerId = playerEntry.getKey();
            ServerPlayer player = playerEntry.getValue();
            this.sendToPlayer(playerId, player);
        }
    }

    protected BoundingBoxCache getCache(DimensionId dimensionId) {
        return this.dimensionCache.get(dimensionId);
    }

    protected BoundingBoxCache getOrCreateCache(DimensionId dimensionId) {
        return this.dimensionCache.computeIfAbsent(dimensionId, dt -> new BoundingBoxCache());
    }

    protected void clearCaches() {
        this.structureProcessors.clear();
        for (BoundingBoxCache cache : this.dimensionCache.values()) {
            cache.clear();
        }
        this.dimensionCache.clear();
    }
}

