/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.common;

import com.irtimaled.bbor.common.BoundingBoxCache;
import com.irtimaled.bbor.common.BoundingBoxType;
import com.irtimaled.bbor.common.models.AbstractBoundingBox;
import com.irtimaled.bbor.common.models.BoundingBoxCuboid;
import com.irtimaled.bbor.common.models.Coords;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3449;

class StructureProcessor {
    private static final Set<BoundingBoxType> supportedStructures = new HashSet<BoundingBoxType>();
    private final BoundingBoxCache boundingBoxCache;

    static void registerSupportedStructure(BoundingBoxType type) {
        supportedStructures.add(type);
    }

    StructureProcessor(BoundingBoxCache boundingBoxCache) {
        this.boundingBoxCache = boundingBoxCache;
    }

    private void addStructures(BoundingBoxType type, class_3449<?> structureStart) {
        if (structureStart == null) {
            return;
        }
        class_3341 bb = structureStart.method_14968();
        if (bb == null) {
            return;
        }
        AbstractBoundingBox boundingBox = this.buildStructure(bb, type);
        if (this.boundingBoxCache.isCached(boundingBox)) {
            return;
        }
        HashSet<AbstractBoundingBox> structureBoundingBoxes = new HashSet<AbstractBoundingBox>();
        for (class_3443 structureComponent : structureStart.method_14963()) {
            structureBoundingBoxes.add(this.buildStructure(structureComponent.method_14935(), type));
        }
        this.boundingBoxCache.addBoundingBoxes(boundingBox, structureBoundingBoxes);
    }

    private AbstractBoundingBox buildStructure(class_3341 bb, BoundingBoxType type) {
        Coords min = new Coords(bb.field_14381, bb.field_14380, bb.field_14379);
        Coords max = new Coords(bb.field_14378, bb.field_14377, bb.field_14376);
        return BoundingBoxCuboid.from(min, max, type);
    }

    void process(Map<String, class_3449<?>> structures) {
        if (structures.size() > 0) {
            supportedStructures.forEach(type -> this.addStructures((BoundingBoxType)type, (class_3449<?>)((class_3449)structures.get(type.getName()))));
        }
    }
}

