/*
 * Decompiled with CFR 0.152.
 */
package com.irtimaled.bbor.common.messages;

import com.irtimaled.bbor.common.models.Coords;
import com.irtimaled.bbor.common.models.DimensionId;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_2817;
import net.minecraft.class_2960;

public class PayloadBuilder {
    private static final Map<String, class_2960> packetNames = new HashMap<String, class_2960>();
    private final class_2960 name;
    private final BiFunction<class_2960, class_2540, class_2596<?>> packetBuilder;
    private final class_2540 buffer;
    private class_2596<?> packet;

    static PayloadBuilder clientBound(String name) {
        return new PayloadBuilder(packetNames.computeIfAbsent(name, class_2960::new), class_2658::new);
    }

    static PayloadBuilder serverBound(String name) {
        return new PayloadBuilder(packetNames.computeIfAbsent(name, class_2960::new), class_2817::new);
    }

    private PayloadBuilder(class_2960 name, BiFunction<class_2960, class_2540, class_2596<?>> packetBuilder) {
        this.name = name;
        this.buffer = new class_2540(Unpooled.buffer());
        this.packetBuilder = packetBuilder;
    }

    public class_2596<?> build() {
        if (this.packet == null) {
            this.packet = this.packetBuilder.apply(this.name, this.buffer);
        }
        return this.packet;
    }

    PayloadBuilder writeLong(long value) {
        this.buffer.writeLong(value);
        this.packet = null;
        return this;
    }

    PayloadBuilder writeInt(int value) {
        this.buffer.writeInt(value);
        this.packet = null;
        return this;
    }

    PayloadBuilder writeVarInt(int value) {
        this.buffer.method_10804(value);
        this.packet = null;
        return this;
    }

    PayloadBuilder writeChar(char value) {
        this.buffer.writeChar((int)value);
        this.packet = null;
        return this;
    }

    PayloadBuilder writeCoords(Coords coords) {
        return this.writeVarInt(coords.getX()).writeVarInt(coords.getY()).writeVarInt(coords.getZ());
    }

    public PayloadBuilder writeDimensionId(DimensionId dimensionId) {
        this.buffer.method_10812(dimensionId.getValue());
        this.packet = null;
        return this;
    }
}

