/*
 * Decompiled with CFR 0.152.
 */
package juuxel.tagboard.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import juuxel.tagboard.impl.SourcedCriterion;
import juuxel.tagboard.impl.Tagboard;
import net.fabricmc.fabric.api.resource.ResourceReloadListenerKeys;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2378;
import net.minecraft.class_274;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3445;
import net.minecraft.class_3448;
import net.minecraft.class_3494;
import net.minecraft.class_5414;

public enum TagCriterionManager implements SimpleSynchronousResourceReloadListener
{
    INSTANCE;

    private static final class_2960 ID;
    private static final Set<class_2960> DEPENDENCIES;
    private static final Map<class_3448<?>, StatTypeEntry<?>> statTypes;
    private static final Map<class_3448<?>, SetMultimap<class_2960, class_274>> criteriaByStat;
    static final Set<class_274> criteria;

    public class_2960 getFabricId() {
        return ID;
    }

    public Collection<class_2960> getFabricDependencies() {
        return DEPENDENCIES;
    }

    public static <T> Set<class_274> getTagCriteria(class_3445<T> stat) {
        if (!criteriaByStat.containsKey(stat.method_14949())) {
            return Collections.emptySet();
        }
        class_2960 valueId = stat.method_14949().method_14959().method_10221(stat.method_14951());
        return criteriaByStat.get(stat.method_14949()).get((Object)valueId);
    }

    public void method_14491(class_3300 manager) {
        criteria.clear();
        criteriaByStat.clear();
        for (class_3448 statType : class_2378.field_11152) {
            StatTypeEntry<?> entry = statTypes.get(statType);
            if (entry == null) continue;
            class_2960 statId = class_2378.field_11152.method_10221((Object)statType);
            SetMultimap criterionMap = MultimapBuilder.hashKeys().hashSetValues().build();
            for (Map.Entry tagEntry : entry.groupSupplier.get().method_30204().entrySet()) {
                class_2960 tagId = (class_2960)tagEntry.getKey();
                class_3494 tag = (class_3494)tagEntry.getValue();
                class_274 criterion = TagCriterionManager.getCriterion(statId, tagId, SourcedCriterion.Source.TAG);
                criteria.add(criterion);
                for (Object value : tag.method_15138()) {
                    class_2960 id = entry.idGetter.apply(value);
                    criterionMap.put((Object)id, (Object)criterion);
                }
            }
            criteriaByStat.put(statType, (SetMultimap<class_2960, class_274>)ImmutableSetMultimap.copyOf((Multimap)criterionMap));
        }
    }

    private static class_274 getCriterion(class_2960 statId, class_2960 tagId, SourcedCriterion.Source source) {
        return TagCriterionManager.getCriterion(TagCriterionManager.idToString(statId) + ":#" + TagCriterionManager.idToString(tagId), source);
    }

    public static class_274 getCriterion(String name, SourcedCriterion.Source source) {
        return class_274.field_1455.containsKey(name) ? (class_274)class_274.field_1455.get(name) : new SourcedCriterion(name, source);
    }

    private static String idToString(class_2960 id) {
        return id.toString().replace(':', '.');
    }

    public static <T> void addStat(class_3448<T> statType, class_2378<T> registry, Supplier<class_5414<T>> groupSupplier) {
        statTypes.put(statType, new StatTypeEntry<Object>(arg_0 -> registry.method_10221(arg_0), groupSupplier));
    }

    static {
        ID = Tagboard.id("tag_criterion_manager");
        DEPENDENCIES = ImmutableSet.of((Object)ResourceReloadListenerKeys.TAGS);
        statTypes = new HashMap();
        criteriaByStat = new HashMap();
        criteria = new HashSet<class_274>();
    }

    private static final class StatTypeEntry<T> {
        final Function<T, class_2960> idGetter;
        final Supplier<class_5414<T>> groupSupplier;

        StatTypeEntry(Function<T, class_2960> idGetter, Supplier<class_5414<T>> groupSupplier) {
            this.idGetter = idGetter;
            this.groupSupplier = groupSupplier;
        }
    }
}

