/*
 * Decompiled with CFR 0.152.
 */
package one.oktw;

import com.google.common.net.InetAddresses;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.net.InetAddress;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import one.oktw.FabricProxy;

public class VelocityLib {
    public static final class_2960 PLAYER_INFO_CHANNEL = new class_2960("velocity", "player_info");
    private static final int SUPPORTED_FORWARDING_VERSION = 1;

    public static boolean checkIntegrity(class_2540 buf) {
        byte[] signature = new byte[32];
        buf.readBytes(signature);
        byte[] data = new byte[buf.readableBytes()];
        buf.getBytes(buf.readerIndex(), data);
        try {
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(new SecretKeySpec(FabricProxy.config.getSecret().getBytes(), "HmacSHA256"));
            byte[] mySignature = mac.doFinal(data);
            if (!MessageDigest.isEqual(signature, mySignature)) {
                return false;
            }
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
        int version = buf.method_10816();
        if (version != 1) {
            throw new IllegalStateException("Unsupported forwarding version " + version + ", wanted " + 1);
        }
        return true;
    }

    public static InetAddress readAddress(class_2540 buf) {
        return InetAddresses.forString((String)buf.method_10800(Short.MAX_VALUE));
    }

    public static GameProfile createProfile(class_2540 buf) {
        GameProfile profile = new GameProfile(buf.method_10790(), buf.method_10800(16));
        VelocityLib.readProperties(buf, profile);
        return profile;
    }

    private static void readProperties(class_2540 buf, GameProfile profile) {
        int properties = buf.method_10816();
        for (int i1 = 0; i1 < properties; ++i1) {
            String name = buf.method_10800(Short.MAX_VALUE);
            String value = buf.method_10800(Short.MAX_VALUE);
            String signature = buf.readBoolean() ? buf.method_10800(Short.MAX_VALUE) : null;
            profile.getProperties().put((Object)name, (Object)new Property(name, value, signature));
        }
    }
}

