/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.roles;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Dynamic;
import dev.gegy.roles.RolesInitializer;
import dev.gegy.roles.api.HasRoles;
import dev.gegy.roles.override.RoleChangeListener;
import dev.gegy.roles.override.RoleOverrideType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public final class Role
implements Comparable<Role> {
    public static final String EVERYONE = "everyone";
    private final String name;
    private int level;
    private final Map<RoleOverrideType<?>, Object> overrides = new HashMap();

    Role(String name) {
        this.name = name;
    }

    public static Role empty(String name) {
        return new Role(name);
    }

    public static <T> Role parse(String name, Dynamic<T> root) {
        Role role = new Role(name);
        role.level = root.get("level").asInt(0);
        Map overrides = (Map)root.get("overrides").orElseEmptyMap().getMapValues().result().orElse(ImmutableMap.of());
        for (Map.Entry entry : overrides.entrySet()) {
            Optional key = ((Dynamic)entry.getKey()).asString().result();
            Optional<RoleOverrideType> overrideTypeOpt = key.map(RoleOverrideType::byKey);
            if (overrideTypeOpt.isPresent()) {
                RoleOverrideType overrideType = overrideTypeOpt.get();
                Dynamic element = (Dynamic)entry.getValue();
                role.overrides.put(overrideType, overrideType.parse(element));
                continue;
            }
            RolesInitializer.LOGGER.warn("Encountered invalid override type: '{}'", entry.getKey());
        }
        return role;
    }

    public void notifyChange(HasRoles owner) {
        for (Object override : this.overrides.values()) {
            if (!(override instanceof RoleChangeListener)) continue;
            ((RoleChangeListener)override).notifyChange(owner);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getLevel() {
        return this.level;
    }

    @Nullable
    public <T> T getOverride(RoleOverrideType<T> type) {
        return (T)this.overrides.get(type);
    }

    public Set<RoleOverrideType<?>> getOverrides() {
        return this.overrides.keySet();
    }

    @Override
    public int compareTo(Role role) {
        return Integer.compare(role.level, this.level);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Role) {
            Role role = (Role)obj;
            return role.name.equalsIgnoreCase(this.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "\"" + this.name + "\" (" + this.level + ")";
    }
}

