/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.roles;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.gegy.roles.Role;
import dev.gegy.roles.RolesInitializer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class RoleConfiguration {
    private static final JsonParser JSON = new JsonParser();
    private static RoleConfiguration instance = new RoleConfiguration((ImmutableMap<String, Role>)ImmutableMap.of(), Role.empty("everyone"));
    private final ImmutableMap<String, Role> roles;
    private final Role everyone;

    private RoleConfiguration(ImmutableMap<String, Role> roles, Role everyone) {
        this.roles = roles;
        this.everyone = everyone;
    }

    public static RoleConfiguration get() {
        return instance;
    }

    public static void setup() {
        Path path = Paths.get("config/roles.json", new String[0]);
        if (!Files.exists(path, new LinkOption[0]) && !RoleConfiguration.createDefaultConfig(path)) {
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            JsonElement root = JSON.parse((Reader)reader);
            instance = RoleConfiguration.parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)root));
        }
        catch (IOException e) {
            RolesInitializer.LOGGER.warn("Failed to load roles.json configuration", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean createDefaultConfig(Path path) {
        try {
            Path legacyPath;
            if (!Files.exists(path.getParent(), new LinkOption[0])) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            if (Files.exists(legacyPath = Paths.get("roles.json", new String[0]), new LinkOption[0])) {
                Files.move(legacyPath, path, new CopyOption[0]);
                return true;
            }
            try (InputStream input = RolesInitializer.class.getResourceAsStream("/data/player-roles/default_roles.json");){
                Files.copy(input, path, new CopyOption[0]);
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            RolesInitializer.LOGGER.warn("Failed to load default roles.json configuration", (Throwable)e);
            return false;
        }
    }

    private static <T> RoleConfiguration parse(Dynamic<T> root) {
        ImmutableMap.Builder roles = ImmutableMap.builder();
        Role everyone = Role.empty("everyone");
        Map map = (Map)root.getMapValues().result().orElse(ImmutableMap.of());
        for (Map.Entry entry : map.entrySet()) {
            String name = ((Dynamic)entry.getKey()).asString("everyone").toLowerCase(Locale.ROOT);
            Dynamic roleRoot = (Dynamic)entry.getValue();
            Role role = Role.parse(name, roleRoot);
            if (!name.equalsIgnoreCase("everyone")) {
                roles.put((Object)name, (Object)role);
                continue;
            }
            everyone = role;
        }
        if (everyone.getLevel() != 0) {
            throw new JsonSyntaxException("'everyone' role level must = 0");
        }
        return new RoleConfiguration((ImmutableMap<String, Role>)roles.build(), everyone);
    }

    @Nullable
    public Role get(String name) {
        return (Role)this.roles.get((Object)name);
    }

    @NotNull
    public Role everyone() {
        return this.everyone;
    }

    public Stream<Role> stream() {
        return this.roles.values().stream();
    }
}

