/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.roles;

import dev.gegy.roles.Role;
import dev.gegy.roles.RoleConfiguration;
import dev.gegy.roles.RolesInitializer;
import dev.gegy.roles.api.HasRoles;
import dev.gegy.roles.api.RoleWriter;
import dev.gegy.roles.override.RoleOverrideType;
import dev.gegy.roles.override.command.PermissionResult;
import it.unimi.dsi.fastutil.objects.ObjectRBTreeSet;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import org.jetbrains.annotations.Nullable;

public final class RoleStorage
implements RoleWriter {
    private final HasRoles owner;
    private final ObjectRBTreeSet<String> roleIds = new ObjectRBTreeSet((n1, n2) -> {
        RoleConfiguration config = RoleConfiguration.get();
        Role r1 = config.get((String)n1);
        Role r2 = config.get((String)n2);
        if (r1 == null || r2 == null) {
            return 0;
        }
        return r1.compareTo(r2);
    });
    private final Map<RoleOverrideType<?>, Collection<Object>> overrideCache = new Reference2ObjectOpenHashMap();

    public RoleStorage(HasRoles owner) {
        this.owner = owner;
    }

    public void notifyReload() {
        this.removeInvalidRoles();
        this.rebuildOverrideCache();
        this.stream().forEach(role -> role.notifyChange(this.owner));
    }

    private void rebuildOverrideCache() {
        this.overrideCache.clear();
        this.stream().forEach(role -> {
            for (RoleOverrideType<?> type : role.getOverrides()) {
                Collection overrides = this.overrideCache.computeIfAbsent(type, t -> new ArrayList());
                overrides.add(role.getOverride(type));
            }
        });
    }

    @Override
    public boolean add(Role role) {
        if (this.roleIds.add((Object)role.getName())) {
            this.rebuildOverrideCache();
            role.notifyChange(this.owner);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Role role) {
        if (this.roleIds.remove((Object)role.getName())) {
            this.rebuildOverrideCache();
            role.notifyChange(this.owner);
            return true;
        }
        return false;
    }

    @Override
    public Stream<Role> stream() {
        RoleConfiguration roleConfig = RoleConfiguration.get();
        return Stream.concat(this.roleIds.stream().map(roleConfig::get).filter(Objects::nonNull), Stream.of(roleConfig.everyone()));
    }

    @Override
    public boolean hasRole(String name) {
        return name.equals("everyone") || this.roleIds.contains((Object)name);
    }

    @Override
    public <T> Stream<T> overrides(RoleOverrideType<T> type) {
        Collection<T> overrides = this.getOverridesOrNull(type);
        return overrides != null ? overrides.stream() : Stream.empty();
    }

    @Nullable
    private <T> Collection<T> getOverridesOrNull(RoleOverrideType<T> type) {
        return this.overrideCache.get(type);
    }

    @Override
    public <T> PermissionResult test(RoleOverrideType<T> type, Function<T, PermissionResult> function) {
        Collection<T> overrides = this.getOverridesOrNull(type);
        if (overrides == null) {
            return PermissionResult.PASS;
        }
        for (T override : overrides) {
            PermissionResult result = function.apply(override);
            if (!result.isDefinitive()) continue;
            return result;
        }
        return PermissionResult.PASS;
    }

    @Override
    public boolean test(RoleOverrideType<Boolean> type) {
        Iterator<Boolean> iterator;
        Collection<Boolean> overrides = this.getOverridesOrNull(type);
        if (overrides != null && (iterator = overrides.iterator()).hasNext()) {
            Boolean override = iterator.next();
            return override;
        }
        return false;
    }

    @Override
    @Nullable
    public <T> T select(RoleOverrideType<T> type) {
        Iterator<T> iterator;
        Collection<T> overrides = this.getOverridesOrNull(type);
        if (overrides != null && (iterator = overrides.iterator()).hasNext()) {
            T override = iterator.next();
            return override;
        }
        return null;
    }

    public class_2499 serialize() {
        class_2499 list = new class_2499();
        for (String role : this.roleIds) {
            list.add((Object)class_2519.method_23256((String)role));
        }
        return list;
    }

    public void deserialize(class_2499 list) {
        this.roleIds.clear();
        for (int i = 0; i < list.size(); ++i) {
            this.roleIds.add((Object)list.method_10608(i));
        }
        this.removeInvalidRoles();
        this.rebuildOverrideCache();
    }

    private void removeInvalidRoles() {
        this.roleIds.removeIf(name -> {
            Role role = RoleConfiguration.get().get((String)name);
            if (role == null || role.getName().equalsIgnoreCase("everyone")) {
                RolesInitializer.LOGGER.warn("Encountered invalid role '{}'", name);
                return true;
            }
            return false;
        });
    }

    public void copyFrom(RoleStorage old) {
        this.deserialize(old.serialize());
    }
}

