/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.roles;

import com.mojang.brigadier.CommandDispatcher;
import dev.gegy.roles.RoleConfiguration;
import dev.gegy.roles.command.RoleCommand;
import dev.gegy.roles.override.command.CommandPermissionEvaluator;
import dev.gegy.roles.override.command.CommandRequirementHooks;
import dev.gegy.roles.override.command.CommandTestContext;
import dev.gegy.roles.override.command.MatchableCommand;
import dev.gegy.roles.override.command.PermissionResult;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_2168;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RolesInitializer
implements ModInitializer {
    public static final String ID = "player-roles";
    public static final Logger LOGGER = LogManager.getLogger((String)"player-roles");
    private static boolean registered;

    public void onInitialize() {
        RoleConfiguration.setup();
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> RoleCommand.register((CommandDispatcher<class_2168>)dispatcher));
        ServerLifecycleEvents.SERVER_STARTING.register(s -> {
            if (registered) {
                return;
            }
            registered = true;
            ServerLifecycleEvents.SERVER_STARTED.register(server -> this.hookCommands((CommandDispatcher<class_2168>)server.method_3734().method_9235()));
        });
    }

    private void hookCommands(CommandDispatcher<class_2168> dispatcher) {
        try {
            CommandRequirementHooks<class_2168> hooks = CommandRequirementHooks.tryCreate((nodes, existing) -> {
                MatchableCommand command = MatchableCommand.compile(nodes);
                return source -> {
                    PermissionResult result = CommandPermissionEvaluator.canUseCommand(source, command);
                    if (result == PermissionResult.ALLOW) {
                        return true;
                    }
                    if (result == PermissionResult.DENY) {
                        return false;
                    }
                    if (result == PermissionResult.HIDDEN) {
                        return !CommandTestContext.isSuggesting();
                    }
                    return existing.test(source);
                };
            });
            hooks.hookAll(dispatcher);
        }
        catch (ReflectiveOperationException e) {
            LOGGER.error("Failed to hook command requirements", (Throwable)e);
        }
    }
}

