/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.roles.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.gegy.roles.Role;
import dev.gegy.roles.RoleConfiguration;
import dev.gegy.roles.RoleStorage;
import dev.gegy.roles.api.HasRoles;
import dev.gegy.roles.override.command.CommandPermissionEvaluator;
import java.util.Collection;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public final class RoleCommand {
    public static final DynamicCommandExceptionType ROLE_NOT_FOUND = new DynamicCommandExceptionType(arg -> new class_2588("Role with name '%s' was not found!", new Object[]{arg}));
    public static final SimpleCommandExceptionType ROLE_POWER_TOO_LOW = new SimpleCommandExceptionType((Message)new class_2585("You do not have sufficient power to manage this role"));

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"role").requires(s -> s.method_9259(4))).then(class_2170.method_9247((String)"assign").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"role", (ArgumentType)StringArgumentType.word()).suggests(RoleCommand.roleSuggestions()).executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            Collection targets = class_2186.method_9312((CommandContext)ctx, (String)"targets");
            String roleName = StringArgumentType.getString((CommandContext)ctx, (String)"role");
            return RoleCommand.updateRoles(source, targets, roleName, RoleStorage::add, "'%s' assigned to %s players");
        }))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"targets", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"role", (ArgumentType)StringArgumentType.word()).suggests(RoleCommand.roleSuggestions()).executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            Collection targets = class_2186.method_9312((CommandContext)ctx, (String)"targets");
            String roleName = StringArgumentType.getString((CommandContext)ctx, (String)"role");
            return RoleCommand.updateRoles(source, targets, roleName, RoleStorage::remove, "'%s' removed from %s players");
        }))))).then(class_2170.method_9247((String)"list").then(class_2170.method_9244((String)"target", (ArgumentType)class_2186.method_9305()).executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            class_3222 target = class_2186.method_9315((CommandContext)ctx, (String)"target");
            return RoleCommand.listRoles(source, target);
        })))).then(class_2170.method_9247((String)"reload").executes(ctx -> RoleCommand.reloadRoles((class_2168)ctx.getSource()))));
    }

    private static int updateRoles(class_2168 source, Collection<class_3222> players, String roleName, BiPredicate<RoleStorage, Role> apply, String success) throws CommandSyntaxException {
        Role role = RoleCommand.getRole(roleName);
        RoleCommand.assertHasPower(source, role);
        int count = 0;
        for (class_3222 player : players) {
            RoleStorage roles;
            if (!(player instanceof HasRoles) || !apply.test(roles = ((HasRoles)player).getRoles(), role)) continue;
            ++count;
        }
        source.method_9226((class_2561)new class_2588(success, new Object[]{roleName, count}), true);
        return 1;
    }

    private static int listRoles(class_2168 source, class_3222 player) {
        if (player instanceof HasRoles) {
            Collection roles = ((HasRoles)player).getRoles().stream().collect(Collectors.toList());
            class_5250 rolesComponent = class_2564.method_10884((Collection)roles, role -> new class_2585(role.getName()).method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));
            source.method_9226((class_2561)new class_2588("Found %s roles on player: %s", new Object[]{roles.size(), rolesComponent}), false);
        }
        return 1;
    }

    private static int reloadRoles(class_2168 source) {
        MinecraftServer server = source.method_9211();
        server.execute(() -> {
            RoleConfiguration.setup();
            List players = server.method_3760().method_14571();
            for (class_3222 entity : players) {
                if (!(entity instanceof HasRoles)) continue;
                RoleStorage roles = ((HasRoles)entity).getRoles();
                roles.notifyReload();
            }
            source.method_9226((class_2561)new class_2588("Role configuration successfully reloaded"), false);
        });
        return 1;
    }

    private static void assertHasPower(class_2168 source, Role role) throws CommandSyntaxException {
        if (CommandPermissionEvaluator.doesBypassPermissions(source)) {
            return;
        }
        int highestPower = RoleCommand.getHighestPowerLevel(source);
        if (highestPower <= role.getLevel()) {
            throw ROLE_POWER_TOO_LOW.create();
        }
    }

    private static Role getRole(String roleName) throws CommandSyntaxException {
        Role role = RoleConfiguration.get().get(roleName);
        if (role == null) {
            throw ROLE_NOT_FOUND.create((Object)roleName);
        }
        return role;
    }

    private static SuggestionProvider<class_2168> roleSuggestions() {
        return (ctx, builder) -> {
            int highestPowerLevel = RoleCommand.getHighestPowerLevel((class_2168)ctx.getSource());
            return class_2172.method_9264(RoleConfiguration.get().stream().filter(role -> role.getLevel() < highestPowerLevel).map(Role::getName), (SuggestionsBuilder)builder);
        };
    }

    private static int getHighestPowerLevel(class_2168 source) {
        class_1297 entity = source.method_9228();
        if (entity == null || CommandPermissionEvaluator.doesBypassPermissions(source)) {
            return Integer.MAX_VALUE;
        }
        if (entity instanceof HasRoles) {
            RoleStorage roles = ((HasRoles)entity).getRoles();
            IntStream levels = roles.stream().mapToInt(Role::getLevel);
            return levels.max().orElse(0);
        }
        return 0;
    }
}

