/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.roles.override;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Dynamic;
import dev.gegy.roles.override.ChatFormatOverride;
import dev.gegy.roles.override.NameStyleOverride;
import dev.gegy.roles.override.command.CommandPermissionOverride;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_3532;
import org.jetbrains.annotations.Nullable;

public final class RoleOverrideType<T> {
    private static final Map<String, RoleOverrideType<?>> REGISTRY = new HashMap();
    public static final RoleOverrideType<CommandPermissionOverride> COMMANDS = RoleOverrideType.builder().key("commands").parse(CommandPermissionOverride::parse).register();
    public static final RoleOverrideType<ChatFormatOverride> CHAT_STYLE = RoleOverrideType.builder().key("chat_format").parse((Dynamic<?> element) -> new ChatFormatOverride(element.asString(""))).register();
    public static final RoleOverrideType<NameStyleOverride> NAME_FORMAT = RoleOverrideType.builder().key("name_style").parse(NameStyleOverride::parse).register();
    public static final RoleOverrideType<Boolean> COMMAND_FEEDBACK = RoleOverrideType.builder().key("command_feedback").parse((Dynamic<?> element) -> element.asBoolean(false)).register();
    public static final RoleOverrideType<Boolean> MUTE = RoleOverrideType.builder().key("mute").parse((Dynamic<?> element) -> element.asBoolean(false)).register();
    public static final RoleOverrideType<Integer> PERMISSION_LEVEL = RoleOverrideType.builder().key("permission_level").parse((Dynamic<?> element) -> class_3532.method_15340((int)element.asInt(0), (int)0, (int)4)).register();
    private final String key;
    private final Function<Dynamic<?>, T> parse;

    private RoleOverrideType(String key, Function<Dynamic<?>, T> parse) {
        this.key = key;
        this.parse = parse;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public String getKey() {
        return this.key;
    }

    public <U> T parse(Dynamic<U> root) {
        return this.parse.apply(root);
    }

    @Nullable
    public static RoleOverrideType<?> byKey(String key) {
        return REGISTRY.get(key);
    }

    public static class Builder<T> {
        private String key;
        private Function<Dynamic<?>, T> parse;

        private Builder() {
        }

        public Builder<T> key(String key) {
            this.key = key;
            return this;
        }

        public Builder<T> parse(Function<Dynamic<?>, T> deserialize) {
            this.parse = deserialize;
            return this;
        }

        public RoleOverrideType<T> register() {
            Preconditions.checkNotNull((Object)this.key, (Object)"key not set");
            Preconditions.checkNotNull(this.parse, (Object)"parser not set");
            Preconditions.checkState((!REGISTRY.containsKey(this.key) ? 1 : 0) != 0, (Object)"override with key already exists");
            RoleOverrideType overrideType = new RoleOverrideType(this.key, this.parse);
            REGISTRY.put(this.key, overrideType);
            return overrideType;
        }
    }
}

