/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.roles.override.command;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Dynamic;
import dev.gegy.roles.api.HasRoles;
import dev.gegy.roles.override.RoleChangeListener;
import dev.gegy.roles.override.command.CommandPermissionRules;
import dev.gegy.roles.override.command.MatchableCommand;
import dev.gegy.roles.override.command.PermissionResult;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public final class CommandPermissionOverride
implements RoleChangeListener {
    private final CommandPermissionRules rules;

    public CommandPermissionOverride(CommandPermissionRules rules) {
        this.rules = rules;
    }

    public PermissionResult test(MatchableCommand command) {
        return this.rules.test(command);
    }

    public static <T> CommandPermissionOverride parse(Dynamic<T> root) {
        CommandPermissionRules.Builder rules = CommandPermissionRules.builder();
        Map map = (Map)root.getMapValues().result().orElse(ImmutableMap.of());
        for (Map.Entry entry : map.entrySet()) {
            String[] patternStrings = ((Dynamic)entry.getKey()).asString("").split(" ");
            String ruleName = ((Dynamic)entry.getValue()).asString("pass");
            Pattern[] patterns = (Pattern[])Arrays.stream(patternStrings).map(Pattern::compile).toArray(Pattern[]::new);
            PermissionResult result = PermissionResult.byName(ruleName);
            rules.add(patterns, result);
        }
        return new CommandPermissionOverride(rules.build());
    }

    @Override
    public void notifyChange(HasRoles entity) {
        class_3222 player;
        MinecraftServer server;
        if (entity instanceof class_3222 && (server = (player = (class_3222)entity).method_5682()) != null) {
            server.method_3734().method_9241(player);
        }
    }

    public String toString() {
        return "CommandPermissionOverride[" + this.rules.toString() + "]";
    }
}

