/*
 * Decompiled with CFR 0.152.
 */
package dev.gegy.roles.override.command;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import dev.gegy.roles.RolesInitializer;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Predicate;

public final class CommandRequirementHooks<S> {
    private static final int MAX_CHAIN_LENGTH = 12;
    private final RequirementOverride<S> override;
    private final Field requirementField;

    private CommandRequirementHooks(RequirementOverride<S> override, Field requirementField) {
        this.override = override;
        this.requirementField = requirementField;
    }

    public static <S> CommandRequirementHooks<S> tryCreate(RequirementOverride<S> override) throws ReflectiveOperationException {
        Field requirementField = CommandNode.class.getDeclaredField("requirement");
        requirementField.setAccessible(true);
        return new CommandRequirementHooks<S>(override, requirementField);
    }

    public void hookAll(CommandDispatcher<S> dispatcher) {
        Collection nodes = dispatcher.getRoot().getChildren();
        HashMultimap overrides = HashMultimap.create();
        BiConsumer<CommandNode<S>, Predicate<S>> override = (arg_0, arg_1) -> ((Multimap)overrides).put(arg_0, arg_1);
        for (CommandNode node : nodes) {
            this.collectRecursive(new CommandNode[]{node}, override);
        }
        for (CommandNode node : overrides.keySet()) {
            Collection requirements = overrides.get((Object)node);
            Predicate<S> requirement = this.anyRequirement(requirements.toArray(new Predicate[0]));
            this.setRequirement(node, requirement);
        }
    }

    private void collectRecursive(CommandNode<S>[] nodes, BiConsumer<CommandNode<S>, Predicate<S>> override) {
        if (nodes.length >= 12) {
            StringBuilder chain = new StringBuilder();
            for (CommandNode<S> node : nodes) {
                chain.append(node.getName()).append(" ");
            }
            RolesInitializer.LOGGER.warn("Aborting hooking long command chain with {} nodes: {}", (Object)12, (Object)chain.toString());
            return;
        }
        CommandNode<S> tail = nodes[nodes.length - 1];
        Collection children = tail.getChildren();
        Predicate<S> requirement = this.createRequirementFor(nodes);
        override.accept(tail, requirement);
        CommandNode redirect = tail.getRedirect();
        if (redirect != null && children.isEmpty() && this.canRedirectTo(nodes, redirect)) {
            CommandNode<S>[] redirectNodes = Arrays.copyOf(nodes, nodes.length);
            redirectNodes[redirectNodes.length - 1] = redirect;
            Predicate<S> redirectRequirement = this.createRequirementFor(redirectNodes);
            override.accept(tail, redirectRequirement);
            override.accept(redirect, requirement);
            children = redirect.getChildren();
        }
        for (CommandNode child : children) {
            if (this.isChildRecursive(nodes, child)) continue;
            CommandNode<S>[] childNodes = Arrays.copyOf(nodes, nodes.length + 1);
            childNodes[childNodes.length - 1] = child;
            this.collectRecursive(childNodes, override);
        }
    }

    private boolean canRedirectTo(CommandNode<S>[] nodes, CommandNode<S> node) {
        if (node instanceof RootCommandNode) {
            return false;
        }
        return !this.isChildRecursive(nodes, node);
    }

    private boolean isChildRecursive(CommandNode<S>[] nodes, CommandNode<S> child) {
        for (CommandNode<S> node : nodes) {
            if (node != child) continue;
            return true;
        }
        return false;
    }

    private Predicate<S> createRequirementFor(CommandNode<S>[] nodes) {
        Predicate<S> chainRequirements = this.requirementForChain(nodes);
        return this.override.apply(nodes, chainRequirements);
    }

    private Predicate<S> requirementForChain(CommandNode<S>[] nodes) {
        Predicate[] requirementTree = new Predicate[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            CommandNode<S> node = nodes[i];
            requirementTree[i] = node.getRequirement();
        }
        return this.allRequirements(requirementTree);
    }

    private Predicate<S> anyRequirement(Predicate<S>[] requirements) {
        if (requirements.length == 0) {
            return s -> false;
        }
        if (requirements.length == 1) {
            return requirements[0];
        }
        return s -> {
            for (Predicate requirement : requirements) {
                if (!requirement.test(s)) continue;
                return true;
            }
            return false;
        };
    }

    private Predicate<S> allRequirements(Predicate<S>[] requirements) {
        if (requirements.length == 0) {
            return s -> true;
        }
        if (requirements.length == 1) {
            return requirements[0];
        }
        return s -> {
            for (Predicate requirement : requirements) {
                if (requirement.test(s)) continue;
                return false;
            }
            return true;
        };
    }

    private void setRequirement(CommandNode<S> node, Predicate<S> requirement) {
        try {
            this.requirementField.set(node, requirement);
        }
        catch (IllegalAccessException e) {
            RolesInitializer.LOGGER.error("Failed to hook command node {}", node, (Object)e);
        }
    }

    public static interface RequirementOverride<S> {
        public Predicate<S> apply(CommandNode<S>[] var1, Predicate<S> var2);
    }
}

