/*
 * Decompiled with CFR 0.152.
 */
package carpet.helpers;

import carpet.fakes.ServerPlayerEntityInterface;
import carpet.helpers.Tracer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1496;
import net.minecraft.class_1533;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1690;
import net.minecraft.class_1695;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2846;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;

public class EntityPlayerActionPack {
    private final class_3222 player;
    private final Map<ActionType, Action> actions = new TreeMap<ActionType, Action>();
    private class_2338 currentBlock;
    private int blockHitDelay;
    private boolean isHittingBlock;
    private float curBlockDamageMP;
    private boolean sneaking;
    private boolean sprinting;
    private float forward;
    private float strafing;
    private int itemUseCooldown;

    public EntityPlayerActionPack(class_3222 playerIn) {
        this.player = playerIn;
        this.stopAll();
    }

    public void copyFrom(EntityPlayerActionPack other) {
        this.actions.putAll(other.actions);
        this.currentBlock = other.currentBlock;
        this.blockHitDelay = other.blockHitDelay;
        this.isHittingBlock = other.isHittingBlock;
        this.curBlockDamageMP = other.curBlockDamageMP;
        this.sneaking = other.sneaking;
        this.sprinting = other.sprinting;
        this.forward = other.forward;
        this.strafing = other.strafing;
        this.itemUseCooldown = other.itemUseCooldown;
    }

    public EntityPlayerActionPack start(ActionType type, Action action) {
        Action previous = this.actions.remove((Object)type);
        if (previous != null) {
            type.stop(this.player, previous);
        }
        if (action != null) {
            this.actions.put(type, action);
            type.start(this.player, action);
        }
        return this;
    }

    public EntityPlayerActionPack setSneaking(boolean doSneak) {
        this.sneaking = doSneak;
        this.player.method_5660(doSneak);
        if (this.sprinting && this.sneaking) {
            this.setSprinting(false);
        }
        return this;
    }

    public EntityPlayerActionPack setSprinting(boolean doSprint) {
        this.sprinting = doSprint;
        this.player.method_5728(doSprint);
        if (this.sneaking && this.sprinting) {
            this.setSneaking(false);
        }
        return this;
    }

    public EntityPlayerActionPack setForward(float value) {
        this.forward = value;
        return this;
    }

    public EntityPlayerActionPack setStrafing(float value) {
        this.strafing = value;
        return this;
    }

    public EntityPlayerActionPack look(class_2350 direction) {
        switch (direction) {
            case field_11043: {
                return this.look(180.0f, 0.0f);
            }
            case field_11035: {
                return this.look(0.0f, 0.0f);
            }
            case field_11034: {
                return this.look(-90.0f, 0.0f);
            }
            case field_11039: {
                return this.look(90.0f, 0.0f);
            }
            case field_11036: {
                return this.look(this.player.field_6031, -90.0f);
            }
            case field_11033: {
                return this.look(this.player.field_6031, 90.0f);
            }
        }
        return this;
    }

    public EntityPlayerActionPack look(class_241 rotation) {
        return this.look(rotation.field_1343, rotation.field_1342);
    }

    public EntityPlayerActionPack look(float yaw, float pitch) {
        this.player.field_6031 = yaw % 360.0f;
        this.player.field_5965 = class_3532.method_15363((float)pitch, (float)-90.0f, (float)90.0f);
        return this;
    }

    public EntityPlayerActionPack lookAt(class_243 position) {
        this.player.method_5702(class_2183.class_2184.field_9851, position);
        return this;
    }

    public EntityPlayerActionPack turn(float yaw, float pitch) {
        return this.look(this.player.field_6031 + yaw, this.player.field_5965 + pitch);
    }

    public EntityPlayerActionPack turn(class_241 rotation) {
        return this.turn(rotation.field_1343, rotation.field_1342);
    }

    public EntityPlayerActionPack stopMovement() {
        this.setSneaking(false);
        this.setSprinting(false);
        this.forward = 0.0f;
        this.strafing = 0.0f;
        return this;
    }

    public EntityPlayerActionPack stopAll() {
        for (ActionType type : this.actions.keySet()) {
            type.stop(this.player, this.actions.get((Object)type));
        }
        this.actions.clear();
        return this.stopMovement();
    }

    public EntityPlayerActionPack mount(boolean onlyRideables) {
        List entities = onlyRideables ? this.player.field_6002.method_8333((class_1297)this.player, this.player.method_5829().method_1009(3.0, 1.0, 3.0), e -> e instanceof class_1695 || e instanceof class_1690 || e instanceof class_1496) : this.player.field_6002.method_8335((class_1297)this.player, this.player.method_5829().method_1009(3.0, 1.0, 3.0));
        if (entities.size() == 0) {
            return this;
        }
        class_1297 closest = null;
        double distance = Double.POSITIVE_INFINITY;
        class_1297 currentVehicle = this.player.method_5854();
        for (class_1297 e2 : entities) {
            double dd;
            if (e2 == this.player || currentVehicle == e2 || !((dd = this.player.method_5858(e2)) < distance)) continue;
            distance = dd;
            closest = e2;
        }
        if (closest == null) {
            return this;
        }
        if (closest instanceof class_1496 && onlyRideables) {
            ((class_1496)closest).method_5992((class_1657)this.player, class_1268.field_5808);
        } else {
            this.player.method_5873(closest, true);
        }
        return this;
    }

    public EntityPlayerActionPack dismount() {
        this.player.method_5848();
        return this;
    }

    public void onUpdate() {
        HashMap<ActionType, Boolean> actionAttempts = new HashMap<ActionType, Boolean>();
        this.actions.entrySet().removeIf(e -> ((Action)e.getValue()).done);
        for (Map.Entry<ActionType, Action> e2 : this.actions.entrySet()) {
            Action using;
            Boolean actionStatus;
            Action action = e2.getValue();
            if (!(actionAttempts.getOrDefault((Object)ActionType.USE, false).booleanValue() && e2.getKey() == ActionType.ATTACK || (actionStatus = action.tick(this, e2.getKey())) == null)) {
                actionAttempts.put(e2.getKey(), actionStatus);
            }
            if (e2.getKey() != ActionType.ATTACK || !actionAttempts.getOrDefault((Object)ActionType.ATTACK, false).booleanValue() || actionAttempts.getOrDefault((Object)ActionType.USE, true).booleanValue() || (using = this.actions.get((Object)ActionType.USE)) == null) continue;
            using.retry(this, ActionType.USE);
        }
        if (this.forward != 0.0f) {
            this.player.field_6250 = this.forward * (this.sneaking ? 0.3f : 1.0f);
        }
        if (this.strafing != 0.0f) {
            this.player.field_6212 = this.strafing * (this.sneaking ? 0.3f : 1.0f);
        }
    }

    static class_239 getTarget(class_3222 player) {
        double reach = player.field_13974.method_14268() ? 5.0 : 4.5;
        return Tracer.rayTrace((class_1297)player, 1.0f, reach, false);
    }

    private void dropItemFromSlot(int slot, boolean dropAll) {
        class_1661 inv = this.player.field_7514;
        if (!inv.method_5438(slot).method_7960()) {
            this.player.method_7329(inv.method_5434(slot, dropAll ? inv.method_5438(slot).method_7947() : 1), false, true);
        }
    }

    public void drop(int selectedSlot, boolean dropAll) {
        class_1661 inv = this.player.field_7514;
        if (selectedSlot == -2) {
            for (int i = inv.method_5439(); i >= 0; --i) {
                this.dropItemFromSlot(i, dropAll);
            }
        } else {
            if (selectedSlot == -1) {
                selectedSlot = inv.field_7545;
            }
            this.dropItemFromSlot(selectedSlot, dropAll);
        }
    }

    public static class Action {
        public boolean done = false;
        public final int limit;
        public final int interval;
        public final int offset;
        private int count;
        private int next;
        private final boolean isContinuous;

        private Action(int limit, int interval, int offset, boolean continuous) {
            this.limit = limit;
            this.interval = interval;
            this.offset = offset;
            this.next = interval + offset;
            this.isContinuous = continuous;
        }

        public static Action once() {
            return new Action(1, 1, 0, false);
        }

        public static Action continuous() {
            return new Action(-1, 1, 0, true);
        }

        public static Action interval(int interval) {
            return new Action(-1, interval, 0, false);
        }

        public static Action interval(int interval, int offset) {
            return new Action(-1, interval, offset, false);
        }

        Boolean tick(EntityPlayerActionPack actionPack, ActionType type) {
            --this.next;
            Boolean cancel = null;
            if (this.next <= 0) {
                if (!(this.interval != 1 || this.isContinuous || type.preventSpectator && actionPack.player.method_7325())) {
                    type.inactiveTick(actionPack.player, this);
                }
                if (!type.preventSpectator || !actionPack.player.method_7325()) {
                    cancel = type.execute(actionPack.player, this);
                }
                ++this.count;
                if (this.count == this.limit) {
                    type.stop(actionPack.player, null);
                    this.done = true;
                    return cancel;
                }
                this.next = this.interval;
            } else if (!type.preventSpectator || !actionPack.player.method_7325()) {
                type.inactiveTick(actionPack.player, this);
            }
            return cancel;
        }

        void retry(EntityPlayerActionPack actionPack, ActionType type) {
            if (!type.preventSpectator || !actionPack.player.method_7325()) {
                type.execute(actionPack.player, this);
            }
            ++this.count;
            if (this.count == this.limit) {
                type.stop(actionPack.player, null);
                this.done = true;
            }
        }
    }

    public static enum ActionType {
        USE(true){

            @Override
            boolean execute(class_3222 player, Action action) {
                EntityPlayerActionPack ap = ((ServerPlayerEntityInterface)player).getActionPack();
                if (ap.itemUseCooldown > 0) {
                    ap.itemUseCooldown--;
                    return true;
                }
                if (player.method_6115()) {
                    return true;
                }
                class_239 hit = EntityPlayerActionPack.getTarget(player);
                for (class_1268 hand : class_1268.values()) {
                    switch (hit.method_17783()) {
                        case field_1332: {
                            class_1269 result;
                            player.method_14234();
                            class_3218 world = player.method_14220();
                            class_3965 blockHit = (class_3965)hit;
                            class_2338 pos = blockHit.method_17777();
                            class_2350 side = blockHit.method_17780();
                            if (pos.method_10264() >= player.field_13995.method_3833() - (side == class_2350.field_11036 ? 1 : 0) || !world.method_8505((class_1657)player, pos) || !(result = player.field_13974.method_14262(player, (class_1937)world, player.method_5998(hand), hand, blockHit)).method_23665()) break;
                            if (result.method_23666()) {
                                player.method_6104(hand);
                            }
                            ap.itemUseCooldown = 3;
                            return true;
                        }
                        case field_1331: {
                            player.method_14234();
                            class_3966 entityHit = (class_3966)hit;
                            class_1297 entity = entityHit.method_17782();
                            boolean handWasEmpty = player.method_5998(hand).method_7960();
                            boolean itemFrameEmpty = entity instanceof class_1533 && ((class_1533)entity).method_6940().method_7960();
                            class_243 relativeHitPos = entityHit.method_17784().method_1023(entity.method_23317(), entity.method_23318(), entity.method_23321());
                            if (entity.method_5664((class_1657)player, relativeHitPos, hand).method_23665()) {
                                ap.itemUseCooldown = 3;
                                return true;
                            }
                            if (!player.method_7287(entity, hand).method_23665() || handWasEmpty && itemFrameEmpty) break;
                            ap.itemUseCooldown = 3;
                            return true;
                        }
                    }
                    class_1799 handItem = player.method_5998(hand);
                    if (!player.field_13974.method_14256(player, (class_1937)player.method_14220(), handItem, hand).method_23665()) continue;
                    ap.itemUseCooldown = 3;
                    return true;
                }
                return false;
            }

            @Override
            void inactiveTick(class_3222 player, Action action) {
                EntityPlayerActionPack ap = ((ServerPlayerEntityInterface)player).getActionPack();
                ap.itemUseCooldown = 0;
                player.method_6075();
            }
        }
        ,
        ATTACK(true){

            @Override
            boolean execute(class_3222 player, Action action) {
                class_239 hit = EntityPlayerActionPack.getTarget(player);
                switch (hit.method_17783()) {
                    case field_1331: {
                        class_3966 entityHit = (class_3966)hit;
                        if (!action.isContinuous) {
                            player.method_7324(entityHit.method_17782());
                            player.method_6104(class_1268.field_5808);
                        }
                        player.method_7350();
                        player.method_14234();
                        return true;
                    }
                    case field_1332: {
                        EntityPlayerActionPack ap = ((ServerPlayerEntityInterface)player).getActionPack();
                        if (ap.blockHitDelay > 0) {
                            ap.blockHitDelay--;
                            return false;
                        }
                        class_3965 blockHit = (class_3965)hit;
                        class_2338 pos = blockHit.method_17777();
                        class_2350 side = blockHit.method_17780();
                        if (player.method_21701(player.field_6002, pos, player.field_13974.method_14257())) {
                            return false;
                        }
                        if (ap.currentBlock != null && player.field_6002.method_8320(ap.currentBlock).method_26215()) {
                            ap.currentBlock = null;
                            return false;
                        }
                        class_2680 state = player.field_6002.method_8320(pos);
                        boolean blockBroken = false;
                        if (player.field_13974.method_14257().method_8386()) {
                            player.field_13974.method_14263(pos, class_2846.class_2847.field_12968, side, player.field_13995.method_3833());
                            ap.blockHitDelay = 5;
                            blockBroken = true;
                        } else if (ap.currentBlock == null || !ap.currentBlock.equals((Object)pos)) {
                            boolean notAir;
                            if (ap.currentBlock != null) {
                                player.field_13974.method_14263(ap.currentBlock, class_2846.class_2847.field_12971, side, player.field_13995.method_3833());
                            }
                            player.field_13974.method_14263(pos, class_2846.class_2847.field_12968, side, player.field_13995.method_3833());
                            boolean bl = notAir = !state.method_26215();
                            if (notAir && ap.curBlockDamageMP == 0.0f) {
                                state.method_26179(player.field_6002, pos, (class_1657)player);
                            }
                            if (notAir && state.method_26165((class_1657)player, (class_1922)player.field_6002, pos) >= 1.0f) {
                                ap.currentBlock = null;
                                blockBroken = true;
                            } else {
                                ap.currentBlock = pos;
                                ap.curBlockDamageMP = 0.0f;
                            }
                        } else {
                            EntityPlayerActionPack entityPlayerActionPack = ap;
                            entityPlayerActionPack.curBlockDamageMP = entityPlayerActionPack.curBlockDamageMP + state.method_26165((class_1657)player, (class_1922)player.field_6002, pos);
                            if (ap.curBlockDamageMP >= 1.0f) {
                                player.field_13974.method_14263(pos, class_2846.class_2847.field_12973, side, player.field_13995.method_3833());
                                ap.currentBlock = null;
                                ap.blockHitDelay = 5;
                                blockBroken = true;
                            }
                            player.field_6002.method_8517(-1, pos, (int)(ap.curBlockDamageMP * 10.0f));
                        }
                        player.method_14234();
                        player.method_6104(class_1268.field_5808);
                        return blockBroken;
                    }
                }
                return false;
            }

            @Override
            void inactiveTick(class_3222 player, Action action) {
                EntityPlayerActionPack ap = ((ServerPlayerEntityInterface)player).getActionPack();
                if (ap.currentBlock == null) {
                    return;
                }
                player.field_6002.method_8517(-1, ap.currentBlock, -1);
                player.field_13974.method_14263(ap.currentBlock, class_2846.class_2847.field_12971, class_2350.field_11033, player.field_13995.method_3833());
                ap.currentBlock = null;
            }
        }
        ,
        JUMP(true){

            @Override
            boolean execute(class_3222 player, Action action) {
                if (action.limit == 1) {
                    if (player.method_24828()) {
                        player.method_6043();
                    }
                } else {
                    player.method_6100(true);
                }
                return false;
            }

            @Override
            void inactiveTick(class_3222 player, Action action) {
                player.method_6100(false);
            }
        }
        ,
        DROP_ITEM(true){

            @Override
            boolean execute(class_3222 player, Action action) {
                player.method_14234();
                player.method_7290(false);
                return false;
            }
        }
        ,
        DROP_STACK(true){

            @Override
            boolean execute(class_3222 player, Action action) {
                player.method_14234();
                player.method_7290(true);
                return false;
            }
        }
        ,
        SWAP_HANDS(true){

            @Override
            boolean execute(class_3222 player, Action action) {
                player.method_14234();
                class_1799 itemStack_1 = player.method_5998(class_1268.field_5810);
                player.method_6122(class_1268.field_5810, player.method_5998(class_1268.field_5808));
                player.method_6122(class_1268.field_5808, itemStack_1);
                return false;
            }
        };

        public final boolean preventSpectator;

        private ActionType(boolean preventSpectator) {
            this.preventSpectator = preventSpectator;
        }

        void start(class_3222 player, Action action) {
        }

        abstract boolean execute(class_3222 var1, Action var2);

        void inactiveTick(class_3222 player, Action action) {
        }

        void stop(class_3222 player, Action action) {
            this.inactiveTick(player, action);
        }
    }
}

