/*
 * Decompiled with CFR 0.152.
 */
package carpet.script;

import carpet.CarpetServer;
import carpet.CarpetSettings;
import carpet.script.CarpetContext;
import carpet.script.CarpetEventServer;
import carpet.script.CarpetExpression;
import carpet.script.CarpetScriptServer;
import carpet.script.Context;
import carpet.script.LazyValue;
import carpet.script.ScriptHost;
import carpet.script.Tokenizer;
import carpet.script.argument.FunctionArgument;
import carpet.script.bundled.Module;
import carpet.script.command.CommandArgument;
import carpet.script.command.CommandToken;
import carpet.script.exception.CarpetExpressionException;
import carpet.script.exception.ExpressionException;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.InvalidCallbackException;
import carpet.script.value.FunctionValue;
import carpet.script.value.MapValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.utils.Messenger;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2520;
import net.minecraft.class_2585;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.apache.commons.lang3.tuple.Pair;

public class CarpetScriptHost
extends ScriptHost {
    private final CarpetScriptServer scriptServer;
    class_2168 responsibleSource;
    private class_2520 globalState;
    private int saveTimeout = 0;
    public boolean persistenceRequired;
    public Map<Value, Value> appConfig;
    public Map<String, CommandArgument> appArgTypes;
    Function<class_2168, Boolean> commandValidator;
    boolean isRuleApp;

    private CarpetScriptHost(CarpetScriptServer server, Module code, boolean perUser, ScriptHost parent, Map<Value, Value> config, Map<String, CommandArgument> argTypes, Function<class_2168, Boolean> commandValidator, boolean isRuleApp) {
        super(code, perUser, parent);
        this.scriptServer = server;
        this.persistenceRequired = true;
        if (parent == null && code != null) {
            this.persistenceRequired = false;
            this.globalState = this.loadState();
        } else if (parent != null) {
            this.persistenceRequired = ((CarpetScriptHost)parent).persistenceRequired;
        }
        this.appConfig = config;
        this.appArgTypes = argTypes;
        this.commandValidator = commandValidator;
        this.isRuleApp = isRuleApp;
    }

    public static CarpetScriptHost create(CarpetScriptServer scriptServer, Module module, boolean perPlayer, class_2168 source, Function<class_2168, Boolean> commandValidator, boolean isRuleApp) {
        CarpetScriptHost host = new CarpetScriptHost(scriptServer, module, perPlayer, null, Collections.emptyMap(), new HashMap<String, CommandArgument>(), commandValidator, isRuleApp);
        if (module != null) {
            try {
                String code = module.getCode();
                if (code == null) {
                    Messenger.m(source, "r Unable to load " + module.getName() + " app - code not found");
                    return null;
                }
                host.setChatErrorSnooper(source);
                CarpetExpression ex = new CarpetExpression(host.main, code, source, new class_2338(0, 0, 0));
                ex.getExpr().asATextSource();
                ex.scriptRunCommand(host, new class_2338(source.method_9222()));
            }
            catch (CarpetExpressionException e) {
                host.handleErrorWithStack("Error while evaluating expression", e);
                host.resetErrorSnooper();
                return null;
            }
            catch (ArithmeticException ae) {
                host.handleErrorWithStack("Math doesn't compute", ae);
                return null;
            }
        }
        return host;
    }

    private static int execute(CommandContext<class_2168> ctx, String hostName, FunctionArgument<Value> funcSpec, List<String> paramNames) throws CommandSyntaxException {
        CarpetScriptHost cHost = CarpetServer.scriptServer.modules.get(hostName).retrieveOwnForExecution((class_2168)ctx.getSource());
        List<String> argNames = funcSpec.function.getArguments();
        if (argNames.size() - funcSpec.args.size() != paramNames.size()) {
            throw new SimpleCommandExceptionType((Message)new class_2585("Target function " + funcSpec.function.getPrettyString() + " as wrong number of arguments, required " + paramNames.size() + ", found " + argNames.size() + " with " + funcSpec.args.size() + " provided")).create();
        }
        ArrayList<Value> args = new ArrayList<Value>(argNames.size());
        for (String s : paramNames) {
            args.add(CommandArgument.getValue(ctx, s, cHost));
        }
        args.addAll(funcSpec.args);
        Value response = cHost.handleCommand((class_2168)ctx.getSource(), funcSpec.function, args);
        return (int)response.readInteger();
    }

    public LiteralArgumentBuilder<class_2168> addPathToCommand(LiteralArgumentBuilder<class_2168> command, List<CommandToken> path, FunctionArgument<Value> functionSpec) throws CommandSyntaxException {
        String hostName = this.main.getName();
        List commandArgs = path.stream().filter(t -> t.isArgument).map(t -> t.surface).collect(Collectors.toList());
        if (commandArgs.size() != functionSpec.function.getNumParams() - functionSpec.args.size()) {
            throw CommandArgument.error("Number of parameters in function " + functionSpec.function.fullName() + " doesn't match parameters for a command");
        }
        if (path.isEmpty()) {
            return (LiteralArgumentBuilder)command.executes(c -> CarpetScriptHost.execute((CommandContext<class_2168>)c, hostName, functionSpec, Collections.emptyList()));
        }
        ArrayList<CommandToken> reversedPath = new ArrayList<CommandToken>(path);
        Collections.reverse(reversedPath);
        ArgumentBuilder argChain = ((CommandToken)reversedPath.get(0)).getCommandNode(this).executes(c -> CarpetScriptHost.execute((CommandContext<class_2168>)c, hostName, functionSpec, commandArgs));
        for (int i = 1; i < reversedPath.size(); ++i) {
            argChain = ((CommandToken)reversedPath.get(i)).getCommandNode(this).then(argChain);
        }
        return (LiteralArgumentBuilder)command.then(argChain);
    }

    public LiteralArgumentBuilder<class_2168> getNewCommandTree(List<Pair<List<CommandToken>, FunctionArgument<Value>>> entries, Function<class_2168, Boolean> useValidator) throws CommandSyntaxException {
        String hostName = this.main.getName();
        LiteralArgumentBuilder<class_2168> command = (LiteralArgumentBuilder<class_2168>)class_2170.method_9247((String)hostName).requires(player -> CarpetServer.scriptServer.modules.containsKey(hostName) && (Boolean)useValidator.apply((class_2168)player) != false);
        for (Pair<List<CommandToken>, FunctionArgument<Value>> commandData : entries) {
            command = this.addPathToCommand(command, (List)commandData.getKey(), (FunctionArgument)commandData.getValue());
        }
        return command;
    }

    @Override
    protected ScriptHost duplicate() {
        return new CarpetScriptHost(this.scriptServer, this.main, false, this, this.appConfig, this.appArgTypes, this.commandValidator, this.isRuleApp);
    }

    @Override
    protected void transferToChild(ScriptHost host) {
        super.transferToChild(host);
        CarpetEventServer.Event.transferAllHostEventsToChild((CarpetScriptHost)host);
    }

    @Override
    public void addUserDefinedFunction(Context ctx, Module module, String funName, FunctionValue function) {
        super.addUserDefinedFunction(ctx, module, funName, function);
        if (ctx.host.main != module) {
            return;
        }
        if (funName.startsWith("__")) {
            if (funName.startsWith("__on_")) {
                String event = funName.replaceFirst("__on_", "");
                if (CarpetEventServer.Event.byName.containsKey(event)) {
                    this.scriptServer.events.addBuiltInEvent(event, this, function, null);
                }
            } else if (funName.equals("__config") && !this.readConfig()) {
                throw new InternalExpressionException("Invalid app config (via '__config()' function)");
            }
        }
    }

    private boolean readConfig() {
        try {
            Value ret = this.callUDF(class_2338.field_10980, this.scriptServer.server.method_3739(), this.getFunction("__config"), Collections.emptyList());
            if (!(ret instanceof MapValue)) {
                return false;
            }
            Map<Value, Value> config = ((MapValue)ret).getMap();
            this.setPerPlayer(config.getOrDefault(new StringValue("scope"), new StringValue("player")).getString().equalsIgnoreCase("player"));
            this.persistenceRequired = config.getOrDefault(new StringValue("stay_loaded"), Value.FALSE).getBoolean();
            Value arguments = config.get(StringValue.of("arguments"));
            if (arguments != null) {
                if (!(arguments instanceof MapValue)) {
                    throw new InternalExpressionException("'arguments' element in config should be a map");
                }
                for (Map.Entry<Value, Value> typeData : ((MapValue)arguments).getMap().entrySet()) {
                    String argument = typeData.getKey().getString();
                    Value spec = typeData.getValue();
                    if (!(spec instanceof MapValue)) {
                        throw new InternalExpressionException("Spec for '" + argument + "' should be a map");
                    }
                    Map<String, Value> specData = ((MapValue)spec).getMap().entrySet().stream().collect(Collectors.toMap(e -> ((Value)e.getKey()).getString(), Map.Entry::getValue));
                    this.appArgTypes.put(argument, CommandArgument.buildFromConfig(argument, specData, this));
                }
            }
            this.appConfig = config;
        }
        catch (InvalidCallbackException | NullPointerException ignored) {
            return false;
        }
        return true;
    }

    public LiteralArgumentBuilder<class_2168> readCommands(Function<class_2168, Boolean> useValidator) throws CommandSyntaxException {
        Value commands = this.appConfig.get(StringValue.of("commands"));
        if (commands == null) {
            return null;
        }
        if (!(commands instanceof MapValue)) {
            throw CommandArgument.error("'commands' element in config should be a map");
        }
        ArrayList<Pair<List<CommandToken>, FunctionArgument<Value>>> commandEntries = new ArrayList<Pair<List<CommandToken>, FunctionArgument<Value>>>();
        for (Map.Entry commandsData : ((MapValue)commands).getMap().entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList())) {
            List<CommandToken> elements = CommandToken.parseSpec(((Value)commandsData.getKey()).getString(), this);
            FunctionArgument<Value> funSpec = FunctionArgument.fromCommandSpec(this, (Value)commandsData.getValue());
            commandEntries.add((Pair<List<CommandToken>, FunctionArgument<Value>>)Pair.of(elements, funSpec));
        }
        commandEntries.sort(new ListComparator());
        if (!this.appConfig.getOrDefault(StringValue.of("allow_command_conflicts"), Value.FALSE).getBoolean()) {
            block1: for (int i = 0; i < commandEntries.size() - 1; ++i) {
                List first = (List)((Pair)commandEntries.get(i)).getKey();
                List other = (List)((Pair)commandEntries.get(i + 1)).getKey();
                int checkSize = Math.min(first.size(), other.size());
                for (int t = 0; t < checkSize; ++t) {
                    CommandToken tik = (CommandToken)first.get(t);
                    CommandToken tok = (CommandToken)other.get(t);
                    if (tik.isArgument && tok.isArgument && !tik.surface.equals(tok.surface)) {
                        throw CommandArgument.error("Conflicting commands: \n - [" + first.stream().map(tt -> tt.surface).collect(Collectors.joining(" ")) + "] at " + tik.surface + "\n - [" + other.stream().map(tt -> tt.surface).collect(Collectors.joining(" ")) + "] at " + tok.surface + "\n");
                    }
                    if (!tik.equals(tok)) continue block1;
                }
            }
        }
        return this.getNewCommandTree(commandEntries, useValidator);
    }

    @Override
    protected Module getModuleOrLibraryByName(String name) {
        Module module = this.scriptServer.getModule(name, true);
        if (module == null || module.getCode() == null) {
            throw new InternalExpressionException("Unable to locate package: " + name);
        }
        return module;
    }

    @Override
    protected void runModuleCode(Context c, Module module) {
        CarpetContext cc = (CarpetContext)c;
        CarpetExpression ex = new CarpetExpression(module, module.getCode(), cc.s, cc.origin);
        ex.getExpr().asATextSource();
        ex.scriptRunCommand(this, cc.origin);
    }

    @Override
    public void delFunction(Module module, String funName) {
        super.delFunction(module, funName);
        if (funName.startsWith("__on_")) {
            String event = funName.replaceFirst("__on_", "");
            this.scriptServer.events.removeBuiltInEvent(event, this, funName);
        }
    }

    public List<CarpetScriptHost> retrieveForExecution(class_2168 source, String optionalTarget) {
        ArrayList<CarpetScriptHost> targets = new ArrayList<CarpetScriptHost>();
        if (this.perUser) {
            if (optionalTarget == null) {
                for (class_3222 player : source.method_9211().method_3760().method_14571()) {
                    CarpetScriptHost host = (CarpetScriptHost)this.retrieveForExecution(player.method_5820());
                    targets.add(host);
                    if (host.errorSnooper != null) continue;
                    host.setChatErrorSnooper(player.method_5671());
                }
            } else {
                class_3222 player = source.method_9211().method_3760().method_14566(optionalTarget);
                if (player != null) {
                    CarpetScriptHost host = (CarpetScriptHost)this.retrieveForExecution(player.method_5820());
                    targets.add(host);
                    if (host.errorSnooper == null) {
                        host.setChatErrorSnooper(player.method_5671());
                    }
                }
            }
        } else {
            targets.add(this);
            if (this.errorSnooper == null) {
                this.setChatErrorSnooper(source);
            }
        }
        return targets;
    }

    public CarpetScriptHost retrieveOwnForExecution(class_2168 source) throws CommandSyntaxException {
        class_3222 player;
        if (!this.perUser) {
            if (this.errorSnooper == null) {
                this.setChatErrorSnooper(source);
            }
            return this;
        }
        try {
            player = source.method_9207();
        }
        catch (CommandSyntaxException ignored) {
            throw new SimpleCommandExceptionType((Message)new class_2585("Cannot run player based apps without the player context")).create();
        }
        CarpetScriptHost userHost = (CarpetScriptHost)this.retrieveForExecution(player.method_5820());
        if (userHost.errorSnooper == null) {
            userHost.setChatErrorSnooper(source);
        }
        return userHost;
    }

    public Value handleCommandLegacy(class_2168 source, String call, List<Integer> coords, String arg) {
        try {
            return this.callLegacy(source, call, coords, arg);
        }
        catch (CarpetExpressionException exc) {
            this.handleErrorWithStack("Error while running custom command", exc);
            return Value.NULL;
        }
        catch (ArithmeticException ae) {
            this.handleErrorWithStack("Math doesn't compute", ae);
            return Value.NULL;
        }
    }

    public Value handleCommand(class_2168 source, FunctionValue function, List<Value> args) {
        try {
            return this.call(source, function, args);
        }
        catch (CarpetExpressionException exc) {
            this.handleErrorWithStack("Error while running custom command", exc);
            return Value.NULL;
        }
        catch (ArithmeticException ae) {
            this.handleErrorWithStack("Math doesn't compute", ae);
            return Value.NULL;
        }
    }

    public Value callLegacy(class_2168 source, String call, List<Integer> coords, String arg) {
        if (CarpetServer.scriptServer.stopAll) {
            throw new CarpetExpressionException("SCARPET PAUSED", null);
        }
        FunctionValue function = this.getFunction(call);
        if (function == null) {
            throw new CarpetExpressionException("UNDEFINED", null);
        }
        ArrayList<LazyValue> argv = new ArrayList<LazyValue>();
        if (coords != null) {
            for (Integer n : coords) {
                argv.add((c, t) -> new NumericValue(n.intValue()));
            }
        }
        String sign = "";
        for (Tokenizer.Token tok : Tokenizer.simplepass(arg)) {
            switch (tok.type) {
                case VARIABLE: {
                    LazyValue var = this.getGlobalVariable(tok.surface);
                    if (var != null) {
                        argv.add(var);
                        break;
                    }
                }
                case STRINGPARAM: {
                    argv.add((c, t) -> new StringValue(tok.surface));
                    sign = "";
                    break;
                }
                case LITERAL: {
                    String finalSign;
                    try {
                        finalSign = sign;
                        argv.add((c, t) -> new NumericValue(finalSign + tok.surface));
                        sign = "";
                        break;
                    }
                    catch (NumberFormatException exception) {
                        throw new CarpetExpressionException("Fail: " + sign + tok.surface + " seems like a number but it is not a number. Use quotes to ensure its a string", null);
                    }
                }
                case HEX_LITERAL: {
                    String finalSign;
                    try {
                        finalSign = sign;
                        argv.add((c, t) -> new NumericValue(new BigInteger(finalSign + tok.surface.substring(2), 16).doubleValue()));
                        sign = "";
                        break;
                    }
                    catch (NumberFormatException exception) {
                        throw new CarpetExpressionException("Fail: " + sign + tok.surface + " seems like a number but it is not a number. Use quotes to ensure its a string", null);
                    }
                }
                case OPERATOR: 
                case UNARY_OPERATOR: {
                    if ((tok.surface.equals("-") || tok.surface.equals("-u")) && sign.isEmpty()) {
                        sign = "-";
                        break;
                    }
                    throw new CarpetExpressionException("Fail: operators, like " + tok.surface + " are not allowed in invoke", null);
                }
                case FUNCTION: {
                    throw new CarpetExpressionException("Fail: passing functions like " + tok.surface + "() to invoke is not allowed", null);
                }
                case OPEN_PAREN: 
                case COMMA: 
                case CLOSE_PAREN: 
                case MARKER: {
                    throw new CarpetExpressionException("Fail: " + tok.surface + " is not allowed in invoke", null);
                }
            }
        }
        List<String> list = function.getArguments();
        if (argv.size() != list.size()) {
            String error = "Fail: stored function " + call + " takes " + list.size() + " arguments, not " + argv.size() + ":\n";
            for (int i = 0; i < Math.max(argv.size(), list.size()); ++i) {
                error = error + (i < list.size() ? list.get(i) : "??") + " => " + (i < argv.size() ? ((LazyValue)argv.get(i)).evalValue(null).getString() : "??") + "\n";
            }
            throw new CarpetExpressionException(error, null);
        }
        try {
            CarpetContext context = new CarpetContext(this, source, class_2338.field_10980);
            return function.getExpression().evalValue(() -> function.lazyEval(context, 1, function.getExpression(), function.getToken(), argv), context, 1);
        }
        catch (ExpressionException e) {
            throw new CarpetExpressionException(e.getMessage(), e.stack);
        }
    }

    public Value call(class_2168 source, FunctionValue function, List<Value> suppliedArgs) {
        if (CarpetServer.scriptServer.stopAll) {
            throw new CarpetExpressionException("SCARPET PAUSED", null);
        }
        List<LazyValue> argv = FunctionValue.lazify(suppliedArgs);
        List<String> args = function.getArguments();
        if (argv.size() != args.size()) {
            String error = "Fail: stored function " + function.getPrettyString() + " takes " + args.size() + " arguments, not " + argv.size() + ":\n";
            for (int i = 0; i < Math.max(argv.size(), args.size()); ++i) {
                error = error + (i < args.size() ? args.get(i) : "??") + " => " + (i < argv.size() ? argv.get(i).evalValue(null).getString() : "??") + "\n";
            }
            throw new CarpetExpressionException(error, null);
        }
        try {
            CarpetContext context = new CarpetContext(this, source, class_2338.field_10980);
            return function.getExpression().evalValue(() -> function.lazyEval(context, 1, function.getExpression(), function.getToken(), argv), context, 1);
        }
        catch (ExpressionException e) {
            throw new CarpetExpressionException(e.getMessage(), e.stack);
        }
    }

    public Value callUDF(class_2338 pos, class_2168 source, FunctionValue fun, List<Value> argv) throws InvalidCallbackException {
        if (CarpetServer.scriptServer.stopAll) {
            return Value.NULL;
        }
        try {
            fun.assertArgsOk(argv, b -> {
                throw new InternalExpressionException("");
            });
        }
        catch (InternalExpressionException ignored) {
            throw new InvalidCallbackException();
        }
        try {
            CarpetContext context = new CarpetContext(this, source, pos);
            return fun.getExpression().evalValue(() -> fun.lazyEval(context, 1, fun.getExpression(), fun.getToken(), FunctionValue.lazify(argv)), context, 1);
        }
        catch (ExpressionException e) {
            this.handleExpressionException("Callback failed", e);
            return Value.NULL;
        }
    }

    @Override
    public void onClose() {
        super.onClose();
        FunctionValue closing = this.getFunction("__on_close");
        if (closing != null) {
            class_3222 player = this.user == null ? null : this.scriptServer.server.method_3760().method_14566(this.user);
            class_2168 source = player != null ? player.method_5671() : this.scriptServer.server.method_3739();
            try {
                this.callUDF(class_2338.field_10980, source, closing, Collections.emptyList());
            }
            catch (InvalidCallbackException invalidCallbackException) {
                // empty catch block
            }
        }
        if (this.user == null) {
            String markerName = "__scarpet_marker_" + (this.getName() == null ? "" : this.getName());
            for (class_3218 world : this.scriptServer.server.method_3738()) {
                for (class_1297 e : world.method_18198(class_1299.field_6131, as -> as.method_5752().contains(markerName))) {
                    e.method_5650();
                }
            }
            if (this.saveTimeout > 0) {
                this.dumpState();
            }
        }
    }

    private void dumpState() {
        Module.saveData(this.main, null, this.globalState, false);
    }

    private class_2520 loadState() {
        return Module.getData(this.main, null, false);
    }

    public class_2520 readFileTag(String file, boolean isShared) {
        if (this.getName() == null && !isShared) {
            return null;
        }
        if (file != null) {
            return Module.getData(this.main, file, isShared);
        }
        if (this.parent == null) {
            return this.globalState;
        }
        return ((CarpetScriptHost)this.parent).globalState;
    }

    public boolean writeTagFile(class_2520 tag, String file, boolean isShared) {
        if (this.getName() == null && !isShared) {
            return false;
        }
        if (file != null) {
            return Module.saveData(this.main, file, tag, isShared);
        }
        CarpetScriptHost responsibleHost = this.parent != null ? (CarpetScriptHost)this.parent : this;
        responsibleHost.globalState = tag;
        if (responsibleHost.saveTimeout == 0) {
            responsibleHost.dumpState();
            responsibleHost.saveTimeout = 200;
        }
        return true;
    }

    public boolean removeResourceFile(String resource, boolean isShared, String type) {
        if (this.getName() == null && !isShared) {
            return false;
        }
        return Module.dropExistingFile(this.main, resource, type.equals("nbt") ? "nbt" : "txt", isShared);
    }

    public boolean appendLogFile(String resource, boolean isShared, String type, List<String> data) {
        if (this.getName() == null && !isShared) {
            return false;
        }
        return Module.appendToTextFile(this.main, resource, type, isShared, data);
    }

    public List<String> readTextResource(String resource, boolean isShared) {
        if (this.getName() == null && !isShared) {
            return null;
        }
        return Module.listFile(this.main, resource, "txt", isShared);
    }

    public void tick() {
        if (this.saveTimeout > 0) {
            --this.saveTimeout;
            if (this.saveTimeout == 0) {
                this.dumpState();
            }
        }
    }

    public void setChatErrorSnooper(class_2168 source) {
        this.responsibleSource = source;
        this.errorSnooper = (expr, token, message) -> {
            try {
                source.method_9207();
            }
            catch (CommandSyntaxException e) {
                return null;
            }
            String shebang = message;
            shebang = expr.module != null ? shebang + " in " + expr.module.getName() + "" : shebang + " in system chat";
            if (token != null) {
                String[] lines = expr.getCodeString().split("\n");
                shebang = lines.length > 1 ? shebang + " at line " + (token.lineno + 1) + ", pos " + (token.linepos + 1) : shebang + " at pos " + (token.pos + 1);
                Messenger.m(source, "r " + shebang);
                if (lines.length > 1 && token.lineno > 0) {
                    Messenger.m(source, "l " + lines[token.lineno - 1]);
                }
                Messenger.m(source, "l " + lines[token.lineno].substring(0, token.linepos), "r  HERE>> ", "l " + lines[token.lineno].substring(token.linepos));
                if (lines.length > 1 && token.lineno < lines.length - 1) {
                    Messenger.m(source, "l " + lines[token.lineno + 1]);
                }
            } else {
                Messenger.m(source, "r " + shebang);
            }
            return new ArrayList();
        };
    }

    @Override
    public void resetErrorSnooper() {
        this.responsibleSource = null;
        super.resetErrorSnooper();
    }

    public void handleErrorWithStack(String intro, Exception exception) {
        if (this.responsibleSource != null) {
            if (exception instanceof CarpetExpressionException) {
                ((CarpetExpressionException)exception).printStack(this.responsibleSource);
            }
            String message = exception.getMessage();
            Messenger.m(this.responsibleSource, "r " + intro + (message.isEmpty() ? "" : ": " + message));
        } else {
            CarpetSettings.LOG.error(intro + ": " + exception.getMessage());
        }
    }

    @Override
    public void handleExpressionException(String message, ExpressionException exc) {
        this.handleErrorWithStack(message, new CarpetExpressionException(exc.getMessage(), exc.stack));
    }

    public CarpetScriptServer getScriptServer() {
        return this.scriptServer;
    }

    @Override
    public boolean issueDeprecation(String feature) {
        if (super.issueDeprecation(feature)) {
            Messenger.m(this.responsibleSource, "rb '" + feature + "' is deprecated and soon will be removed. Please consult the docs for their replacement");
            return true;
        }
        return false;
    }

    static class ListComparator<T extends Comparable<T>>
    implements Comparator<Pair<List<T>, ?>> {
        ListComparator() {
        }

        @Override
        public int compare(Pair<List<T>, ?> p1, Pair<List<T>, ?> p2) {
            List o1 = (List)p1.getKey();
            List o2 = (List)p2.getKey();
            for (int i = 0; i < Math.min(o1.size(), o2.size()); ++i) {
                int c = ((Comparable)o1.get(i)).compareTo(o2.get(i));
                if (c == 0) continue;
                return c;
            }
            return Integer.compare(o1.size(), o2.size());
        }
    }
}

