/*
 * Decompiled with CFR 0.152.
 */
package carpet.script;

import carpet.CarpetServer;
import carpet.CarpetSettings;
import carpet.script.CarpetEventServer;
import carpet.script.CarpetScriptHost;
import carpet.script.ScriptHost;
import carpet.script.argument.FunctionArgument;
import carpet.script.bundled.BundledModule;
import carpet.script.bundled.FileModule;
import carpet.script.bundled.Module;
import carpet.script.command.CommandToken;
import carpet.script.exception.InvalidCallbackException;
import carpet.script.value.FunctionValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.utils.Messenger;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class CarpetScriptServer {
    public final MinecraftServer server;
    public CarpetScriptHost globalHost;
    public Map<String, CarpetScriptHost> modules;
    public Set<String> unloadableModules;
    public long tickStart;
    public boolean stopAll;
    private Set<String> holyMoly;
    public CarpetEventServer events;
    private static final List<Module> bundledModuleData = new ArrayList<Module>();
    private static final List<Module> ruleModuleData = new ArrayList<Module>();

    public static void registerBuiltInScript(BundledModule app) {
        bundledModuleData.add(app);
    }

    public static void registerSettingsApp(BundledModule app) {
        ruleModuleData.add(app);
    }

    public CarpetScriptServer(MinecraftServer server) {
        this.server = server;
        this.init();
    }

    private void init() {
        ScriptHost.systemGlobals.clear();
        this.events = new CarpetEventServer(this.server);
        this.modules = new HashMap<String, CarpetScriptHost>();
        this.unloadableModules = new HashSet<String>();
        this.tickStart = 0L;
        this.stopAll = false;
        this.holyMoly = this.server.method_3734().method_9235().getRoot().getChildren().stream().map(CommandNode::getName).collect(Collectors.toSet());
        this.globalHost = CarpetScriptHost.create(this, null, false, null, p -> true, false);
    }

    public void initializeForWorld() {
        CarpetServer.settingsManager.initializeScarpetRules();
        CarpetServer.extensions.forEach(e -> {
            if (e.customSettingsManager() != null) {
                e.customSettingsManager().initializeScarpetRules();
            }
        });
        if (CarpetSettings.scriptsAutoload) {
            Messenger.m(this.server.method_3739(), "Auto-loading world scarpet apps");
            for (String moduleName : this.listAvailableModules(false)) {
                this.addScriptHost(this.server.method_3739(), moduleName, null, true, true, false);
            }
        }
    }

    public Module getModule(String name, boolean allowLibraries) {
        try {
            Path folder = this.server.method_27050(class_5218.field_24188).resolve("scripts");
            Files.createDirectories(folder, new FileAttribute[0]);
            Optional<Path> scriptPath = Files.walk(folder, new FileVisitOption[0]).filter(script -> script.getFileName().toString().equalsIgnoreCase(name + ".sc") || allowLibraries && script.getFileName().toString().equalsIgnoreCase(name + ".scl")).findFirst();
            if (scriptPath.isPresent()) {
                return new FileModule(scriptPath.get());
            }
            if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                Path globalFolder = FabricLoader.getInstance().getConfigDir().resolve("carpet/scripts");
                Files.createDirectories(globalFolder, new FileAttribute[0]);
                scriptPath = Files.walk(globalFolder, new FileVisitOption[0]).filter(script -> script.getFileName().toString().equalsIgnoreCase(name + ".sc") || allowLibraries && script.getFileName().toString().equalsIgnoreCase(name + ".scl")).findFirst();
                if (scriptPath.isPresent()) {
                    return new FileModule(scriptPath.get());
                }
            }
        }
        catch (IOException e) {
            CarpetSettings.LOG.error("Exception while loading the app: ", (Throwable)e);
        }
        for (Module moduleData : bundledModuleData) {
            if (!moduleData.getName().equalsIgnoreCase(name) || !allowLibraries && moduleData.isLibrary()) continue;
            return moduleData;
        }
        return null;
    }

    public Module getRuleModule(String name) {
        for (Module moduleData : ruleModuleData) {
            if (!moduleData.getName().equalsIgnoreCase(name)) continue;
            return moduleData;
        }
        return null;
    }

    public List<String> listAvailableModules(boolean includeBuiltIns) {
        ArrayList<String> moduleNames = new ArrayList<String>();
        if (includeBuiltIns) {
            for (Module mi : bundledModuleData) {
                if (mi.isLibrary() || mi.getName().endsWith("_beta")) continue;
                moduleNames.add(mi.getName());
            }
        }
        try {
            Path worldScripts = this.server.method_27050(class_5218.field_24188).resolve("scripts");
            Files.createDirectories(worldScripts, new FileAttribute[0]);
            Files.walk(worldScripts, new FileVisitOption[0]).filter(f -> f.toString().endsWith(".sc")).forEach(f -> moduleNames.add(f.getFileName().toString().replaceFirst("\\.sc$", "").toLowerCase(Locale.ROOT)));
            if (includeBuiltIns && FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                Path globalScripts = FabricLoader.getInstance().getConfigDir().resolve("carpet/scripts");
                Files.createDirectories(globalScripts, new FileAttribute[0]);
                Files.walk(globalScripts, new FileVisitOption[0]).filter(f -> f.toString().endsWith(".sc")).forEach(f -> moduleNames.add(f.getFileName().toString().replaceFirst("\\.sc$", "").toLowerCase(Locale.ROOT)));
            }
        }
        catch (IOException e) {
            CarpetSettings.LOG.error("Exception while searching for apps: ", (Throwable)e);
        }
        return moduleNames;
    }

    public ScriptHost getHostByName(String name) {
        if (name == null) {
            return this.globalHost;
        }
        return this.modules.get(name);
    }

    /*
     * Unable to fully structure code
     */
    public boolean addScriptHost(class_2168 source, String name, Function<class_2168, Boolean> commandValidator, boolean perPlayer, boolean autoload, boolean isRuleApp) {
        if (commandValidator == null) {
            commandValidator = (Function<class_2168, Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$addScriptHost$8(net.minecraft.class_2168 ), (Lnet/minecraft/class_2168;)Ljava/lang/Boolean;)();
        }
        start = System.nanoTime();
        name = name.toLowerCase(Locale.ROOT);
        reload = false;
        if (this.modules.containsKey(name)) {
            if (isRuleApp) {
                return false;
            }
            this.removeScriptHost(source, name, false, isRuleApp);
            reload = true;
        }
        v0 = module = isRuleApp != false ? this.getRuleModule(name) : this.getModule(name, false);
        if (module == null) {
            Messenger.m(source, new Object[]{"r Failed to add " + name + " app"});
            return false;
        }
        newHost = CarpetScriptHost.create(this, module, perPlayer, source, commandValidator, isRuleApp);
        if (newHost == null) {
            Messenger.m(source, new Object[]{"r Failed to add " + name + " app"});
            return false;
        }
        if (module.getCode() == null) {
            Messenger.m(source, new Object[]{"r Unable to load " + name + " app - not found"});
            return false;
        }
        this.modules.put(name, newHost);
        if (!isRuleApp) {
            this.unloadableModules.add(name);
        }
        if (autoload && !newHost.persistenceRequired) {
            this.removeScriptHost(source, name, false, false);
            return false;
        }
        v1 = action = reload != false ? "reloaded" : "loaded";
        if (newHost.appConfig.get(StringValue.of("commands")) != null) {
            try {
                command = newHost.readCommands(commandValidator);
                if (command != null) {
                    if (!isRuleApp) {
                        Messenger.m(source, new Object[]{"gi " + name + " app " + action + " with /" + name + " command"});
                    }
                    this.server.method_3734().method_9235().register(command);
                    CarpetServer.settingsManager.notifyPlayersCommandsChanged();
                }
                if (isRuleApp) ** GOTO lbl56
                Messenger.m(source, new Object[]{"gi " + name + " app " + action});
            }
            catch (CommandSyntaxException cse) {
                this.removeScriptHost(source, name, false, false);
                Messenger.m(source, new Object[]{"r Failed to build command system for " + name + " thus failed to load the app ", cse.getRawMessage()});
                return false;
            }
        } else if (!this.addLegacyCommand(source, name, reload, isRuleApp == false, commandValidator)) {
            this.removeScriptHost(source, name, false, false);
            Messenger.m(source, new Object[]{"r Failed to build command system for " + name + " thus failed to load the app"});
            return false;
        }
lbl56:
        // 5 sources

        if (newHost.isPerUser()) {
            newHost.retrieveForExecution(source, null);
        }
        end = System.nanoTime();
        CarpetSettings.LOG.info("App " + name + " loaded in " + (end - start) / 1000000L + " ms");
        return true;
    }

    private boolean addLegacyCommand(class_2168 source, String hostName, boolean isReload, boolean notifySource, Function<class_2168, Boolean> useValidator) {
        String loaded;
        CarpetScriptHost host = this.modules.get(hostName);
        String string = loaded = isReload ? "reloaded" : "loaded";
        if (host == null) {
            return true;
        }
        if (host.getFunction("__command") == null) {
            if (notifySource) {
                Messenger.m(source, "gi " + hostName + " app " + loaded + ".");
            }
            return true;
        }
        if (this.holyMoly.contains(hostName)) {
            Messenger.m(source, "gi " + hostName + " app " + loaded + " with no command.");
            Messenger.m(source, "gi Tried to mask vanilla command.");
            return true;
        }
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)hostName).requires(player -> this.modules.containsKey(hostName) && (Boolean)useValidator.apply((class_2168)player) != false)).executes(c -> {
            CarpetScriptHost targetHost = this.modules.get(hostName).retrieveOwnForExecution((class_2168)c.getSource());
            Value response = targetHost.handleCommandLegacy((class_2168)c.getSource(), "__command", null, "");
            if (!response.isNull()) {
                Messenger.m((class_2168)c.getSource(), "gi " + response.getString());
            }
            return (int)response.readInteger();
        });
        for (String function : host.globaFunctionNames(host.main, s -> !s.startsWith("_")).sorted().collect(Collectors.toList())) {
            if (host.appConfig.getOrDefault(StringValue.of("legacy_command_type_support"), Value.FALSE).getBoolean()) {
                try {
                    FunctionValue functionValue = host.getFunction(function);
                    command = host.addPathToCommand((LiteralArgumentBuilder<class_2168>)command, CommandToken.parseSpec(CommandToken.specFromSignature(functionValue), host), FunctionArgument.fromCommandSpec(host, functionValue));
                    continue;
                }
                catch (CommandSyntaxException e) {
                    return false;
                }
            }
            command = (LiteralArgumentBuilder)command.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)function).requires(player -> this.modules.containsKey(hostName) && this.modules.get(hostName).getFunction(function) != null)).executes(c -> {
                CarpetScriptHost targetHost = this.modules.get(hostName).retrieveOwnForExecution((class_2168)c.getSource());
                Value response = targetHost.handleCommandLegacy((class_2168)c.getSource(), function, null, "");
                if (!response.isNull()) {
                    Messenger.m((class_2168)c.getSource(), "gi " + response.getString());
                }
                return (int)response.readInteger();
            })).then(class_2170.method_9244((String)"args...", (ArgumentType)StringArgumentType.greedyString()).executes(c -> {
                CarpetScriptHost targetHost = this.modules.get(hostName).retrieveOwnForExecution((class_2168)c.getSource());
                Value response = targetHost.handleCommandLegacy((class_2168)c.getSource(), function, null, StringArgumentType.getString((CommandContext)c, (String)"args..."));
                if (!response.isNull()) {
                    Messenger.m((class_2168)c.getSource(), "gi " + response.getString());
                }
                return (int)response.readInteger();
            })));
        }
        if (notifySource) {
            Messenger.m(source, "gi " + hostName + " app " + loaded + " with /" + hostName + " command");
        }
        this.server.method_3734().method_9235().register(command);
        CarpetServer.settingsManager.notifyPlayersCommandsChanged();
        return true;
    }

    public boolean removeScriptHost(class_2168 source, String name, boolean notifySource, boolean isRuleApp) {
        if (!this.modules.containsKey(name = name.toLowerCase(Locale.ROOT)) || !isRuleApp && !this.unloadableModules.contains(name)) {
            if (notifySource) {
                Messenger.m(source, "r No such app found: ", "wb  " + name);
            }
            return false;
        }
        this.events.removeAllHostEvents(this.modules.get(name));
        this.modules.get(name).onClose();
        this.modules.remove(name);
        if (!isRuleApp) {
            this.unloadableModules.remove(name);
        }
        CarpetServer.settingsManager.notifyPlayersCommandsChanged();
        if (notifySource) {
            Messenger.m(source, "gi Removed " + name + " app");
        }
        return true;
    }

    public boolean runEventCall(class_2168 sender, String hostname, String optionalTarget, FunctionValue udf, List<Value> argv) {
        CarpetScriptHost host = this.globalHost;
        if (hostname != null) {
            host = this.modules.get(hostname);
        }
        if (host == null) {
            return false;
        }
        if (host.isPerUser() && optionalTarget == null) {
            return true;
        }
        class_3222 target = null;
        if (optionalTarget != null && (target = sender.method_9211().method_3760().method_14566(optionalTarget)) == null) {
            return false;
        }
        int successes = this.signal(sender, target, hostname, udf, argv, true);
        return successes >= 0;
    }

    public void runScheduledCall(class_2338 origin, class_2168 source, String hostname, CarpetScriptHost host, FunctionValue udf, List<Value> argv) {
        if (hostname != null && !this.modules.containsKey(hostname)) {
            return;
        }
        try {
            host.callUDF(origin, source, udf, argv);
        }
        catch (InvalidCallbackException | NullPointerException exception) {
            // empty catch block
        }
    }

    public int signal(class_2168 sender, class_3222 optionalRecipient, String hostname, FunctionValue udf, List<Value> argv, boolean reportFails) {
        if (hostname == null) {
            if (optionalRecipient != null) {
                return 0;
            }
            try {
                this.globalHost.callUDF(class_2338.field_10980, sender, udf, argv);
            }
            catch (InvalidCallbackException | NullPointerException npe) {
                return reportFails ? -1 : 0;
            }
            return 1;
        }
        String hostRecipient = optionalRecipient == null ? null : optionalRecipient.method_5820();
        class_2168 source = optionalRecipient == null ? sender : optionalRecipient.method_5671().method_9206(CarpetSettings.runPermissionLevel);
        int successes = 0;
        for (CarpetScriptHost host : this.modules.get(hostname).retrieveForExecution(sender, hostRecipient)) {
            class_2168 executingSource = host.perUser ? source.method_9211().method_3760().method_14566(host.user).method_5671() : source.method_9211().method_3739();
            try {
                host.callUDF(class_2338.field_10980, source.method_9206(CarpetSettings.runPermissionLevel), udf, argv);
            }
            catch (InvalidCallbackException | NullPointerException npe) {
                if (!reportFails) continue;
                return -1;
            }
            ++successes;
        }
        return successes;
    }

    public void tick() {
        this.events.tick();
        for (CarpetScriptHost host : this.modules.values()) {
            host.tick();
        }
    }

    public void onClose() {
        for (ScriptHost scriptHost : this.modules.values()) {
            scriptHost.onClose();
        }
    }

    public void onPlayerJoin(class_3222 player) {
        this.modules.values().forEach(h -> {
            if (h.isPerUser()) {
                try {
                    h.retrieveOwnForExecution(player.method_5671());
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
        });
    }

    public void reload(MinecraftServer server) {
        HashMap<String, TransferData> apps = new HashMap<String, TransferData>();
        this.modules.forEach((s, h) -> apps.put((String)s, new TransferData((CarpetScriptHost)h)));
        apps.keySet().forEach(s -> this.removeScriptHost(server.method_3739(), (String)s, false, false));
        CarpetEventServer.Event.clearAllBuiltinEvents();
        this.init();
        apps.forEach((s, data) -> this.addScriptHost(server.method_3739(), (String)s, data.commandValidator, data.perUser, false, data.isRuleApp));
    }

    private static /* synthetic */ Boolean lambda$addScriptHost$8(class_2168 p) {
        return true;
    }

    static {
        CarpetScriptServer.registerBuiltInScript(BundledModule.carpetNative("camera", false));
        CarpetScriptServer.registerBuiltInScript(BundledModule.carpetNative("overlay", false));
        CarpetScriptServer.registerBuiltInScript(BundledModule.carpetNative("event_test", false));
        CarpetScriptServer.registerBuiltInScript(BundledModule.carpetNative("stats_test", false));
        CarpetScriptServer.registerBuiltInScript(BundledModule.carpetNative("math", true));
        CarpetScriptServer.registerBuiltInScript(BundledModule.carpetNative("chunk_display", false));
        CarpetScriptServer.registerBuiltInScript(BundledModule.carpetNative("ai_tracker", false));
        CarpetScriptServer.registerBuiltInScript(BundledModule.carpetNative("draw_beta", false));
        CarpetScriptServer.registerBuiltInScript(BundledModule.carpetNative("distance_beta", false));
    }

    static class TransferData {
        boolean perUser;
        Function<class_2168, Boolean> commandValidator;
        boolean isRuleApp;

        private TransferData(CarpetScriptHost host) {
            this.perUser = host.perUser;
            this.commandValidator = host.commandValidator;
            this.isRuleApp = host.isRuleApp;
        }
    }
}

