/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.api;

import carpet.script.CarpetContext;
import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.LazyValue;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.EntityValue;
import carpet.script.value.FormattedTextValue;
import carpet.script.value.ListValue;
import carpet.script.value.NullValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1259;
import net.minecraft.class_1297;
import net.minecraft.class_151;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_266;
import net.minecraft.class_267;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_270;
import net.minecraft.class_274;
import net.minecraft.class_2960;
import net.minecraft.class_2995;
import net.minecraft.class_3002;
import net.minecraft.class_3004;
import net.minecraft.class_3222;

public class Scoreboards {
    private static String getScoreboardKeyFromValue(Value keyValue) {
        if (keyValue instanceof EntityValue) {
            class_1297 e = ((EntityValue)keyValue).getEntity();
            if (e instanceof class_1657) {
                return e.method_5477().getString();
            }
            return e.method_5845();
        }
        return keyValue.getString();
    }

    public static void apply(Expression expression) {
        expression.addLazyFunction("scoreboard", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            class_2995 scoreboard = cc.s.method_9211().method_3845();
            if (lv.size() == 0) {
                ListValue ret = ListValue.wrap(scoreboard.method_1163().stream().map(StringValue::new).collect(Collectors.toList()));
                return (_c, _t) -> ret;
            }
            String objectiveName = ((LazyValue)lv.get(0)).evalValue((Context)c).getString();
            class_266 objective = scoreboard.method_1165(objectiveName);
            if (objective == null) {
                return LazyValue.NULL;
            }
            if (lv.size() == 1) {
                ListValue ret = ListValue.wrap(scoreboard.method_1184(objective).stream().map(s -> new StringValue(s.method_1129())).collect(Collectors.toList()));
                return (_c, _t) -> ret;
            }
            String key = Scoreboards.getScoreboardKeyFromValue(((LazyValue)lv.get(1)).evalValue((Context)c));
            if (!scoreboard.method_1183(key, objective) && lv.size() == 2) {
                return LazyValue.NULL;
            }
            class_267 scoreboardPlayerScore = scoreboard.method_1180(key, objective);
            NumericValue retval = new NumericValue(scoreboardPlayerScore.method_1126());
            if (lv.size() > 2) {
                scoreboardPlayerScore.method_1128(NumericValue.asNumber(((LazyValue)lv.get(2)).evalValue((Context)c)).getInt());
            }
            return (_c, _t) -> retval;
        });
        expression.addLazyFunction("scoreboard_remove", -1, (c, t, lv) -> {
            String objectiveName;
            if (lv.size() == 0) {
                throw new InternalExpressionException("'scoreboard_remove' requires at least one parameter");
            }
            CarpetContext cc = (CarpetContext)c;
            class_2995 scoreboard = cc.s.method_9211().method_3845();
            class_266 objective = scoreboard.method_1165(objectiveName = ((LazyValue)lv.get(0)).evalValue((Context)c).getString());
            if (objective == null) {
                return LazyValue.FALSE;
            }
            if (lv.size() == 1) {
                scoreboard.method_1194(objective);
                return LazyValue.TRUE;
            }
            String key = Scoreboards.getScoreboardKeyFromValue(((LazyValue)lv.get(1)).evalValue((Context)c));
            if (!scoreboard.method_1183(key, objective)) {
                return LazyValue.NULL;
            }
            class_267 scoreboardPlayerScore = scoreboard.method_1180(key, objective);
            NumericValue previous = new NumericValue(scoreboardPlayerScore.method_1126());
            scoreboard.method_1155(key, objective);
            return (c_, t_) -> previous;
        });
        expression.addLazyFunction("scoreboard_add", -1, (c, t, lv) -> {
            class_274 criterion;
            CarpetContext cc = (CarpetContext)c;
            class_2995 scoreboard = cc.s.method_9211().method_3845();
            if (lv.size() == 0 || lv.size() > 2) {
                throw new InternalExpressionException("'scoreboard_add' should have one or two parameters");
            }
            String objectiveName = ((LazyValue)lv.get(0)).evalValue((Context)c).getString();
            if (lv.size() == 1) {
                criterion = class_274.field_1468;
            } else {
                String critetionName = ((LazyValue)lv.get(1)).evalValue((Context)c).getString();
                criterion = class_274.method_1224((String)critetionName).orElse(null);
                if (criterion == null) {
                    throw new InternalExpressionException("Unknown scoreboard criterion: " + critetionName);
                }
            }
            class_266 objective = scoreboard.method_1165(objectiveName);
            if (objective != null) {
                return LazyValue.FALSE;
            }
            scoreboard.method_1168(objectiveName, criterion, (class_2561)new class_2585(objectiveName), criterion.method_1227());
            return LazyValue.TRUE;
        });
        expression.addLazyFunction("scoreboard_display", 2, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            class_2995 scoreboard = cc.s.method_9211().method_3845();
            String location = ((LazyValue)lv.get(0)).evalValue((Context)c).getString();
            int slot = class_269.method_1192((String)location);
            if (slot < 0) {
                throw new InternalExpressionException("Invalid objective slot: " + location);
            }
            Value target = ((LazyValue)lv.get(1)).evalValue((Context)c);
            if (target instanceof NullValue) {
                scoreboard.method_1158(slot, null);
                return (_c, _t) -> new NumericValue(slot);
            }
            String objectiveString = target.getString();
            class_266 objective = scoreboard.method_1165(objectiveString);
            if (objective == null) {
                return LazyValue.NULL;
            }
            scoreboard.method_1158(slot, objective);
            return (_c, _t) -> new NumericValue(slot);
        });
        expression.addLazyFunction("team_list", -1, (c, t, lv) -> {
            if (lv.size() > 1) {
                throw new InternalExpressionException("'team_list' requires zero or one parameters");
            }
            CarpetContext cc = (CarpetContext)c;
            class_2995 scoreboard = cc.s.method_9211().method_3845();
            if (lv.size() == 0) {
                ListValue ret = ListValue.wrap(scoreboard.method_1196().stream().map(StringValue::of).collect(Collectors.toList()));
                return (_c, _t) -> ret;
            }
            if (lv.size() == 1) {
                class_268 team = scoreboard.method_1153(((LazyValue)lv.get(0)).evalValue((Context)c).getString());
                if (team == null) {
                    return LazyValue.NULL;
                }
                ListValue ret = ListValue.wrap(team.method_1204().stream().map(StringValue::of).collect(Collectors.toList()));
                return (_c, _t) -> ret;
            }
            return LazyValue.NULL;
        });
        expression.addLazyFunction("team_add", -1, (c, t, lv) -> {
            if (lv.size() >= 3 || lv.size() <= 0) {
                throw new InternalExpressionException("'team_add' requires one or two parameters");
            }
            CarpetContext cc = (CarpetContext)c;
            class_2995 scoreboard = cc.s.method_9211().method_3845();
            String teamName = ((LazyValue)lv.get(0)).evalValue((Context)c).getString();
            if (lv.size() == 1) {
                if (scoreboard.method_1153(teamName) == null) {
                    scoreboard.method_1171(teamName);
                    StringValue ret = new StringValue(teamName);
                    return (_c, _t) -> ret;
                }
                return LazyValue.NULL;
            }
            if (lv.size() == 2) {
                Value playerVal = ((LazyValue)lv.get(1)).evalValue((Context)c);
                String player = EntityValue.getPlayerNameByValue(playerVal);
                if (player == null) {
                    return LazyValue.NULL;
                }
                class_268 team = scoreboard.method_1153(teamName);
                if (team == null) {
                    return LazyValue.NULL;
                }
                if (team.method_1206((class_270)scoreboard.method_1164(player))) {
                    return LazyValue.FALSE;
                }
                scoreboard.method_1172(player, scoreboard.method_1153(teamName));
                return LazyValue.TRUE;
            }
            return LazyValue.NULL;
        });
        expression.addLazyFunction("team_remove", 1, (c, t, lv) -> {
            Value teamVal;
            String team;
            CarpetContext cc = (CarpetContext)c;
            class_2995 scoreboard = cc.s.method_9211().method_3845();
            if (scoreboard.method_1153(team = (teamVal = ((LazyValue)lv.get(0)).evalValue((Context)c)).getString()) != null) {
                scoreboard.method_1191(scoreboard.method_1153(team));
                return LazyValue.TRUE;
            }
            return LazyValue.NULL;
        });
        expression.addLazyFunction("team_leave", 1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            class_2995 scoreboard = cc.s.method_9211().method_3845();
            Value playerVal = ((LazyValue)lv.get(0)).evalValue((Context)c);
            String player = EntityValue.getPlayerNameByValue(playerVal);
            if (player == null) {
                return LazyValue.NULL;
            }
            NumericValue ret = new NumericValue(scoreboard.method_1195(player));
            return (_c, _t) -> ret;
        });
        expression.addLazyFunction("team_property", -1, (c, t, lv) -> {
            class_268 team;
            CarpetContext cc = (CarpetContext)c;
            class_2995 scoreboard = cc.s.method_9211().method_3845();
            if (lv.size() < 2 || lv.size() > 3) {
                throw new InternalExpressionException("'team_property' requires two or three arguments");
            }
            Value teamVal = ((LazyValue)lv.get(0)).evalValue((Context)c);
            Value propertyVal = ((LazyValue)lv.get(1)).evalValue((Context)c);
            Value settingVal = null;
            boolean modifying = false;
            if (lv.size() == 3) {
                modifying = true;
                settingVal = ((LazyValue)lv.get(2)).evalValue((Context)c);
            }
            if ((team = scoreboard.method_1153(teamVal.getString())) == null) {
                return LazyValue.NULL;
            }
            if (!(propertyVal instanceof StringValue)) {
                throw new InternalExpressionException("'team_property' requires a string as the second argument");
            }
            switch (propertyVal.getString()) {
                case "collisionRule": {
                    if (!modifying) {
                        StringValue ret = new StringValue(team.method_1203().field_1436);
                        return (_c, _t) -> ret;
                    }
                    if (!(settingVal instanceof StringValue)) {
                        throw new InternalExpressionException("'team_property' requires a string as the third argument for the property " + propertyVal.getString());
                    }
                    class_270.class_271 collisionRule = class_270.class_271.method_1210((String)settingVal.getString());
                    if (collisionRule == null) {
                        throw new InternalExpressionException("Unknown value for property " + propertyVal.getString() + ": " + settingVal.getString());
                    }
                    team.method_1145(collisionRule);
                    break;
                }
                case "color": {
                    if (!modifying) {
                        StringValue ret = new StringValue(team.method_1202().method_537());
                        return (_c, _t) -> ret;
                    }
                    if (!(settingVal instanceof StringValue)) {
                        throw new InternalExpressionException("'team_property' requires a string as the third argument for the property " + propertyVal.getString());
                    }
                    class_124 color = class_124.method_533((String)settingVal.getString().toUpperCase());
                    if (color == null || !color.method_543()) {
                        throw new InternalExpressionException("Unknown value for property " + propertyVal.getString() + ": " + settingVal.getString());
                    }
                    team.method_1141(color);
                    break;
                }
                case "deathMessageVisibility": {
                    if (!modifying) {
                        StringValue ret = new StringValue(team.method_1200().field_1445);
                        return (_c, _t) -> ret;
                    }
                    if (!(settingVal instanceof StringValue)) {
                        throw new InternalExpressionException("'team_property' requires a string as the third argument for the property " + propertyVal.getString());
                    }
                    class_270.class_272 deathMessageVisibility = class_270.class_272.method_1213((String)settingVal.getString());
                    if (deathMessageVisibility == null) {
                        throw new InternalExpressionException("Unknown value for property " + propertyVal.getString() + ": " + settingVal.getString());
                    }
                    team.method_1133(deathMessageVisibility);
                    break;
                }
                case "displayName": {
                    if (!modifying) {
                        FormattedTextValue ret = new FormattedTextValue(team.method_1140());
                        return (_c, _t) -> ret;
                    }
                    if (!(settingVal instanceof StringValue)) {
                        throw new InternalExpressionException("'team_property' requires a string or formatted text as the third argument for the property " + propertyVal.getString());
                    }
                    Object displayName = settingVal instanceof FormattedTextValue ? ((FormattedTextValue)settingVal).getText() : new class_2585(settingVal.getString());
                    team.method_1137(displayName);
                    break;
                }
                case "friendlyFire": {
                    if (!modifying) {
                        NumericValue ret = new NumericValue(team.method_1205());
                        return (_c, _t) -> ret;
                    }
                    if (!(settingVal instanceof NumericValue)) {
                        throw new InternalExpressionException("'team_property' requires a boolean as the third argument for the property " + propertyVal.getString());
                    }
                    boolean friendlyFire = settingVal.getBoolean();
                    team.method_1135(friendlyFire);
                    break;
                }
                case "nametagVisibility": {
                    if (!modifying) {
                        StringValue ret = new StringValue(team.method_1201().field_1445);
                        return (_c, _t) -> ret;
                    }
                    if (!(settingVal instanceof StringValue)) {
                        throw new InternalExpressionException("'team_property' requires a string as the third argument for the property " + propertyVal.getString());
                    }
                    class_270.class_272 nametagVisibility = class_270.class_272.method_1213((String)settingVal.getString());
                    if (nametagVisibility == null) {
                        throw new InternalExpressionException("Unknown value for property " + propertyVal.getString() + ": " + settingVal.getString());
                    }
                    team.method_1149(nametagVisibility);
                    break;
                }
                case "prefix": {
                    if (!modifying) {
                        FormattedTextValue ret = new FormattedTextValue(team.method_1144());
                        return (_c, _t) -> ret;
                    }
                    if (!(settingVal instanceof StringValue)) {
                        throw new InternalExpressionException("'team_property ' requires a string or formatted text as the third argument for the property " + propertyVal.getString());
                    }
                    Object prefix = settingVal instanceof FormattedTextValue ? ((FormattedTextValue)settingVal).getText() : new class_2585(settingVal.getString());
                    team.method_1138(prefix);
                    break;
                }
                case "seeFriendlyInvisibles": {
                    if (!modifying) {
                        NumericValue ret = new NumericValue(team.method_1199());
                        return (_c, _t) -> ret;
                    }
                    if (!(settingVal instanceof NumericValue)) {
                        throw new InternalExpressionException("'team_property' requires a boolean as the third argument for the property " + propertyVal.getString());
                    }
                    boolean seeFriendlyInvisibles = settingVal.getBoolean();
                    team.method_1143(seeFriendlyInvisibles);
                    break;
                }
                case "suffix": {
                    if (!modifying) {
                        FormattedTextValue ret = new FormattedTextValue(team.method_1136());
                        return (_c, _t) -> ret;
                    }
                    if (!(settingVal instanceof StringValue)) {
                        throw new InternalExpressionException("'team_property' requires a string or formatted text as the third argument for the property " + propertyVal.getString());
                    }
                    Object suffix = settingVal instanceof FormattedTextValue ? ((FormattedTextValue)settingVal).getText() : new class_2585(settingVal.getString());
                    team.method_1139(suffix);
                    break;
                }
                default: {
                    throw new InternalExpressionException("team property " + propertyVal.getString() + " is not a valid property");
                }
            }
            return LazyValue.TRUE;
        });
        expression.addLazyFunction("bossbar", -1, (c, t, lv) -> {
            class_2960 identifier;
            class_3004 bossBarManager = ((CarpetContext)c).s.method_9211().method_3837();
            if (lv.size() > 3) {
                throw new InternalExpressionException("'bossbar' accepts max three arguments");
            }
            if (lv.size() == 0) {
                ListValue ret = ListValue.wrap(bossBarManager.method_12969().stream().map(class_3002::method_12959).map(class_2960::toString).map(StringValue::of).collect(Collectors.toList()));
                return (_c, _t) -> ret;
            }
            String id = ((LazyValue)lv.get(0)).evalValue((Context)c).getString();
            try {
                identifier = new class_2960(id);
            }
            catch (class_151 invalidIdentifierException) {
                return LazyValue.NULL;
            }
            if (lv.size() == 1) {
                if (bossBarManager.method_12971(identifier) != null) {
                    return LazyValue.FALSE;
                }
                Value ret = StringValue.of(bossBarManager.method_12970(identifier, (class_2561)new class_2585(id)).method_12959().toString());
                return (_c, _t) -> ret;
            }
            String property = ((LazyValue)lv.get(1)).evalValue((Context)c).getString();
            class_3002 bossBar = bossBarManager.method_12971(identifier);
            if (bossBar == null) {
                return LazyValue.NULL;
            }
            Value propertyValue = lv.size() == 3 ? ((LazyValue)lv.get(2)).evalValue((Context)c) : null;
            switch (property) {
                case "color": {
                    if (propertyValue == null) {
                        class_1259.class_1260 color = bossBar.method_5420();
                        if (color == null) {
                            return LazyValue.NULL;
                        }
                        return (_c, _t) -> StringValue.of(color.method_5421());
                    }
                    class_1259.class_1260 color = class_1259.class_1260.method_5422((String)propertyValue.getString());
                    if (color == null) {
                        return LazyValue.NULL;
                    }
                    bossBar.method_5416(class_1259.class_1260.method_5422((String)propertyValue.getString()));
                    return LazyValue.TRUE;
                }
                case "max": {
                    if (propertyValue == null) {
                        return (_c, _t) -> NumericValue.of(bossBar.method_12960());
                    }
                    if (!(propertyValue instanceof NumericValue)) {
                        throw new InternalExpressionException("'bossbar' requires a number as the value for the property " + property);
                    }
                    bossBar.method_12956(((NumericValue)propertyValue).getInt());
                    return LazyValue.TRUE;
                }
                case "name": {
                    if (propertyValue == null) {
                        return (_c, _t) -> new FormattedTextValue(bossBar.method_5414());
                    }
                    if (propertyValue instanceof FormattedTextValue) {
                        bossBar.method_5413(((FormattedTextValue)propertyValue).getText());
                    } else {
                        bossBar.method_5413((class_2561)new class_2585(propertyValue.getString()));
                    }
                    return LazyValue.TRUE;
                }
                case "add_player": {
                    if (propertyValue == null) {
                        throw new InternalExpressionException("Bossbar property " + property + " can't be queried, add a third parameter");
                    }
                    if (propertyValue instanceof ListValue) {
                        ((ListValue)propertyValue).getItems().forEach(v -> {
                            class_3222 player = EntityValue.getPlayerByValue(((CarpetContext)c).s.method_9211(), propertyValue);
                            if (player != null) {
                                bossBar.method_14088(player);
                            }
                        });
                        return LazyValue.TRUE;
                    }
                    class_3222 player = EntityValue.getPlayerByValue(((CarpetContext)c).s.method_9211(), propertyValue);
                    if (player != null) {
                        bossBar.method_14088(player);
                        return LazyValue.TRUE;
                    }
                    return LazyValue.FALSE;
                }
                case "players": {
                    if (propertyValue == null) {
                        return (_c, _t) -> ListValue.wrap(bossBar.method_14092().stream().map(EntityValue::new).collect(Collectors.toList()));
                    }
                    if (propertyValue instanceof ListValue) {
                        bossBar.method_14094();
                        ((ListValue)propertyValue).getItems().forEach(v -> {
                            class_3222 p = EntityValue.getPlayerByValue(((CarpetContext)c).s.method_9211(), v);
                            if (p != null) {
                                bossBar.method_14088(p);
                            }
                        });
                        return LazyValue.TRUE;
                    }
                    class_3222 p = EntityValue.getPlayerByValue(((CarpetContext)c).s.method_9211(), propertyValue);
                    bossBar.method_14094();
                    if (p != null) {
                        bossBar.method_14088(p);
                        return LazyValue.TRUE;
                    }
                    return LazyValue.FALSE;
                }
                case "style": {
                    if (propertyValue == null) {
                        return (_c, _t) -> StringValue.of(bossBar.method_5415().method_5425());
                    }
                    class_1259.class_1261 style = class_1259.class_1261.method_5424((String)propertyValue.getString());
                    if (style == null) {
                        throw new InternalExpressionException("'" + propertyValue.getString() + "' is not a valid value for property " + property);
                    }
                    bossBar.method_5409(style);
                    return LazyValue.TRUE;
                }
                case "value": {
                    if (propertyValue == null) {
                        return (_c, _t) -> NumericValue.of(bossBar.method_12955());
                    }
                    if (!(propertyValue instanceof NumericValue)) {
                        throw new InternalExpressionException("'bossbar' requires a number as the value for the property " + property);
                    }
                    bossBar.method_12954(((NumericValue)propertyValue).getInt());
                    return LazyValue.TRUE;
                }
                case "visible": {
                    if (propertyValue == null) {
                        return (_c, _t) -> new NumericValue(bossBar.method_14093());
                    }
                    bossBar.method_14091(propertyValue.getBoolean());
                    return LazyValue.TRUE;
                }
                case "remove": {
                    bossBarManager.method_12973(bossBar);
                    return LazyValue.TRUE;
                }
            }
            throw new InternalExpressionException("Unknown bossbar property " + property);
        });
    }
}

